/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.client.admin;

import java.io.IOException;
import java.io.StringBufferInputStream;
import java.net.URI;
import java.rmi.RemoteException;
import oracle.kv.impl.admin.DdlResultsReport;
import oracle.kv.impl.client.admin.ClientAdminService;
import oracle.kv.impl.client.admin.ExecutionInfo;
import oracle.kv.impl.client.admin.ExecutionInfoImpl;
import oracle.kv.impl.security.AuthContext;
import oracle.kv.impl.security.ContextProxy;
import oracle.kv.impl.security.login.LoginHandle;
import oracle.kv.impl.test.ExceptionTestHook;
import oracle.kv.impl.test.ExceptionTestHookExecute;
import oracle.kv.impl.util.JsonUtils;
import oracle.kv.impl.util.registry.RemoteAPI;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;

public class ClientAdminServiceAPI
extends RemoteAPI {
    public static final short STATEMENT_RESULT_VERSION = 7;
    private static final AuthContext NULL_CTX = null;
    private final ClientAdminService proxyRemote;
    public static ExceptionTestHook<String, RemoteException> REMOTE_FAULT_HOOK;

    private ClientAdminServiceAPI(ClientAdminService remote, LoginHandle loginHdl) throws RemoteException {
        super(remote);
        this.proxyRemote = ContextProxy.create(remote, loginHdl, this.getSerialVersion());
    }

    public static ClientAdminServiceAPI wrap(ClientAdminService remote, LoginHandle loginHdl) throws RemoteException {
        return new ClientAdminServiceAPI(remote, loginHdl);
    }

    public ExecutionInfo execute(String statement, String namespace) throws RemoteException {
        assert (ExceptionTestHookExecute.doHookIfSet(REMOTE_FAULT_HOOK, "execute"));
        if (this.getSerialVersion() < 14) {
            return this.convertInfo(this.proxyRemote.execute(statement, NULL_CTX, this.getSerialVersion()));
        }
        return this.convertInfo(this.proxyRemote.execute(statement, namespace, NULL_CTX, this.getSerialVersion()));
    }

    public ExecutionInfo getExecutionStatus(int planId) throws RemoteException {
        assert (ExceptionTestHookExecute.doHookIfSet(REMOTE_FAULT_HOOK, "getExecutionStatus"));
        return this.proxyRemote.getExecutionStatus(planId, NULL_CTX, this.getSerialVersion());
    }

    public boolean canHandleDDL() throws RemoteException {
        return this.proxyRemote.canHandleDDL(NULL_CTX, this.getSerialVersion());
    }

    public URI getMasterRmiAddress() throws RemoteException {
        return this.proxyRemote.getMasterRmiAddress(NULL_CTX, this.getSerialVersion());
    }

    public ExecutionInfo interruptAndCancel(int planId) throws RemoteException {
        assert (ExceptionTestHookExecute.doHookIfSet(REMOTE_FAULT_HOOK, "interruptAndCancel"));
        return this.proxyRemote.interruptAndCancel(planId, NULL_CTX, this.getSerialVersion());
    }

    private ExecutionInfo convertInfo(ExecutionInfo execInfo) {
        if (this.getSerialVersion() < 7) {
            String jsonInfo = execInfo.getJSONInfo();
            boolean showResult = false;
            try {
                JsonParser parser = JsonUtils.createJsonParser(new StringBufferInputStream(jsonInfo));
                JsonNode json = parser.readValueAsTree();
                String type = JsonUtils.getAsText(json, "type");
                if (type != null && (type.equals("show") || type.equals("describe"))) {
                    showResult = true;
                }
            }
            catch (IOException ignore) {
                showResult = true;
            }
            if (showResult) {
                return new ExecutionInfoImpl(execInfo.getPlanId(), execInfo.isTerminated(), "Statement completed.", DdlResultsReport.STATEMENT_COMPLETED_JSON, execInfo.isSuccess(), execInfo.isCancelled(), execInfo.getErrorMessage(), execInfo.needsTermination(), execInfo.getJSONInfo());
            }
        }
        return execInfo;
    }
}

