/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import oracle.kv.Depth;
import oracle.kv.KeyValueVersion;
import oracle.kv.StoreIteratorConfig;
import oracle.kv.ValueVersion;
import oracle.kv.Version;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.KeySerializer;
import oracle.kv.impl.api.Request;
import oracle.kv.impl.api.StoreIteratorParams;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.ops.ResultKey;
import oracle.kv.impl.api.ops.ResultKeyValueVersion;
import oracle.kv.impl.api.ops.TableIterate;
import oracle.kv.impl.api.ops.TableKeysIterate;
import oracle.kv.impl.api.parallelscan.PartitionScanIterator;
import oracle.kv.impl.api.table.PrimaryKeyImpl;
import oracle.kv.impl.api.table.RowImpl;
import oracle.kv.impl.api.table.TableAPIImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TableKey;
import oracle.kv.impl.api.table.TargetTables;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.stats.DetailedMetrics;
import oracle.kv.table.MultiRowOptions;
import oracle.kv.table.PrimaryKey;
import oracle.kv.table.Row;
import oracle.kv.table.TableIterator;
import oracle.kv.table.TableIteratorOptions;

public class TableScan {
    private TableScan() {
    }

    static TableIterator<Row> createTableIterator(final TableAPIImpl apiImpl, final TableKey key, MultiRowOptions getOptions, TableIteratorOptions iterateOptions, Set<Integer> partitions) {
        final TargetTables targetTables = TableAPIImpl.makeTargetTables(key.getTable(), getOptions);
        StoreIteratorConfig config = new StoreIteratorConfig();
        if (iterateOptions != null) {
            config.setMaxConcurrentRequests(iterateOptions.getMaxConcurrentRequests());
        }
        final StoreIteratorParams params = new StoreIteratorParams(TableAPIImpl.getDirection(iterateOptions, key), TableAPIImpl.getBatchSize(iterateOptions), key.getKeyBytes(), TableAPIImpl.makeKeyRange(key, getOptions), Depth.PARENT_AND_DESCENDANTS, TableAPIImpl.getConsistency(iterateOptions), TableAPIImpl.getTimeout(iterateOptions), TableAPIImpl.getTimeoutUnit(iterateOptions), partitions);
        if (key.getMajorKeyComplete()) {
            return TableScan.createPartitionRowIterator(apiImpl, params, key, targetTables);
        }
        return new PartitionScanIterator<Row>(apiImpl.getStore(), config, params){

            @Override
            protected TableIterate generateGetterOp(byte[] resumeKey) {
                return new TableIterate(params, targetTables, key.getMajorKeyComplete(), resumeKey);
            }

            @Override
            protected void convertResult(Result result, List<Row> elementList) {
                List<ResultKeyValueVersion> byteKeyResults = result.getKeyValueVersionList();
                Row[] rows = TableScan.convertTableRowResults(apiImpl, byteKeyResults, key.getTable(), targetTables);
                if (rows == null) {
                    return;
                }
                Collections.addAll(elementList, rows);
            }

            @Override
            protected int compare(Row one, Row two) {
                return one.compareTo(two);
            }
        };
    }

    static TableIterator<PrimaryKey> createTableKeysIterator(TableAPIImpl apiImpl, final TableKey key, MultiRowOptions getOptions, TableIteratorOptions iterateOptions) {
        final TargetTables targetTables = TableAPIImpl.makeTargetTables(key.getTable(), getOptions);
        StoreIteratorConfig config = new StoreIteratorConfig();
        if (iterateOptions != null) {
            config.setMaxConcurrentRequests(iterateOptions.getMaxConcurrentRequests());
        }
        final StoreIteratorParams params = new StoreIteratorParams(TableAPIImpl.getDirection(iterateOptions, key), TableAPIImpl.getBatchSize(iterateOptions), key.getKeyBytes(), TableAPIImpl.makeKeyRange(key, getOptions), Depth.PARENT_AND_DESCENDANTS, TableAPIImpl.getConsistency(iterateOptions), TableAPIImpl.getTimeout(iterateOptions), TableAPIImpl.getTimeoutUnit(iterateOptions));
        if (key.getMajorKeyComplete()) {
            return TableScan.createPartitionKeyIterator(apiImpl, params, key, targetTables);
        }
        return new PartitionScanIterator<PrimaryKey>(apiImpl.getStore(), config, params){

            @Override
            protected TableKeysIterate generateGetterOp(byte[] resumeKey) {
                return new TableKeysIterate(params, targetTables, key.getMajorKeyComplete(), resumeKey);
            }

            @Override
            protected void convertResult(Result result, List<PrimaryKey> elementList) {
                List<ResultKey> byteKeyResults = result.getKeyList();
                PrimaryKey[] keys = TableScan.convertTableKeyResults(byteKeyResults, key.getTable(), targetTables);
                if (keys == null) {
                    return;
                }
                Collections.addAll(elementList, keys);
            }

            @Override
            protected int compare(PrimaryKey one, PrimaryKey two) {
                return one.compareTo(two);
            }
        };
    }

    static TableIterator<KeyValueVersion> createTableKVIterator(TableAPIImpl apiImpl, final TableKey key, MultiRowOptions getOptions, TableIteratorOptions iterateOptions, Set<Integer> partitions) {
        final TargetTables targetTables = TableAPIImpl.makeTargetTables(key.getTable(), getOptions);
        StoreIteratorConfig config = new StoreIteratorConfig();
        if (iterateOptions != null) {
            config.setMaxConcurrentRequests(iterateOptions.getMaxConcurrentRequests());
        }
        final StoreIteratorParams params = new StoreIteratorParams(TableAPIImpl.getDirection(iterateOptions, key), TableAPIImpl.getBatchSize(iterateOptions), key.getKeyBytes(), TableAPIImpl.makeKeyRange(key, getOptions), Depth.PARENT_AND_DESCENDANTS, TableAPIImpl.getConsistency(iterateOptions), TableAPIImpl.getTimeout(iterateOptions), TableAPIImpl.getTimeoutUnit(iterateOptions), partitions);
        if (key.getMajorKeyComplete()) {
            throw new IllegalArgumentException("The major path cannot be complete for the key.");
        }
        return new PartitionScanIterator<KeyValueVersion>(apiImpl.getStore(), config, params){

            @Override
            protected TableIterate generateGetterOp(byte[] resumeKey) {
                return new TableIterate(params, targetTables, key.getMajorKeyComplete(), resumeKey);
            }

            @Override
            protected void convertResult(Result result, List<KeyValueVersion> elementList) {
                List<ResultKeyValueVersion> byteKeyResults = result.getKeyValueVersionList();
                int cnt = byteKeyResults.size();
                if (cnt == 0) {
                    assert (!result.hasMoreElements());
                    return;
                }
                for (int i = 0; i < cnt; ++i) {
                    ResultKeyValueVersion entry = byteKeyResults.get(i);
                    KeySerializer keySerializer = this.storeImpl.getKeySerializer();
                    elementList.add(KVStoreImpl.createKeyValueVersion(keySerializer.fromByteArray(entry.getKeyBytes()), entry.getValue(), entry.getVersion(), entry.getExpirationTime()));
                }
            }

            @Override
            protected int compare(KeyValueVersion one, KeyValueVersion two) {
                return one.getKey().compareTo(two.getKey());
            }
        };
    }

    private static Row[] convertTableRowResults(TableAPIImpl apiImpl, List<ResultKeyValueVersion> byteKeyResults, TableImpl table, TargetTables targetTables) {
        int cnt = byteKeyResults.size();
        if (cnt == 0) {
            return null;
        }
        Row[] rowResults = new Row[cnt];
        int actualCount = 0;
        for (ResultKeyValueVersion entry : byteKeyResults) {
            RowImpl fullKey;
            if (targetTables.hasAncestorTables()) {
                table = table.getTopLevelTable();
            }
            if ((fullKey = table.createRowFromKeyBytes(entry.getKeyBytes())) != null) {
                Version version = entry.getVersion();
                assert (version != null);
                ValueVersion vv = new ValueVersion(entry.getValue(), version);
                RowImpl row = apiImpl.getRowFromValueVersion(vv, fullKey, entry.getExpirationTime(), false);
                rowResults[actualCount++] = row;
                continue;
            }
            rowResults[actualCount++] = null;
        }
        return rowResults;
    }

    private static PrimaryKey[] convertTableKeyResults(List<ResultKey> byteKeyResults, TableImpl table, TargetTables targetTables) {
        int cnt = byteKeyResults.size();
        if (cnt == 0) {
            return null;
        }
        PrimaryKey[] keyResults = new PrimaryKey[cnt];
        int actualCount = 0;
        for (ResultKey entry : byteKeyResults) {
            if (targetTables.hasAncestorTables()) {
                table = table.getTopLevelTable();
            }
            PrimaryKeyImpl pKey = table.createPrimaryKeyFromResultKey(entry);
            keyResults[actualCount++] = pKey;
        }
        return keyResults;
    }

    private static TableIterator<Row> createPartitionRowIterator(final TableAPIImpl apiImpl, final StoreIteratorParams params, TableKey key, final TargetTables targetTables) {
        final KVStoreImpl store = apiImpl.getStore();
        byte[] parentKeyBytes = store.getKeySerializer().toByteArray(key.getKey());
        final PartitionId partitionId = store.getDispatcher().getPartitionId(parentKeyBytes);
        Set<Integer> partitions = params.getPartitions();
        if (partitions != null && !partitions.contains(partitionId.getPartitionId())) {
            return new EmptyTableIterator<Row>();
        }
        final TableImpl table = key.getTable();
        return new MultiGetIteratorWrapper<Row>(){
            private boolean moreElements = true;
            private byte[] resumeKey = null;

            Row[] getMoreElements() {
                if (!this.moreElements) {
                    return null;
                }
                TableIterate op = new TableIterate(params, targetTables, true, this.resumeKey);
                Request req = store.makeReadRequest((InternalOperation)op, partitionId, params.getConsistency(), params.getTimeout(), params.getTimeoutUnit());
                Result result = store.executeRequest(req);
                this.moreElements = result.hasMoreElements();
                List<ResultKeyValueVersion> byteKeyResults = result.getKeyValueVersionList();
                if (byteKeyResults.isEmpty()) {
                    assert (!this.moreElements);
                    return null;
                }
                this.resumeKey = byteKeyResults.get(byteKeyResults.size() - 1).getKeyBytes();
                return TableScan.convertTableRowResults(apiImpl, byteKeyResults, table, targetTables);
            }
        };
    }

    private static TableIterator<PrimaryKey> createPartitionKeyIterator(TableAPIImpl apiImpl, final StoreIteratorParams params, TableKey key, final TargetTables targetTables) {
        final KVStoreImpl store = apiImpl.getStore();
        byte[] parentKeyBytes = store.getKeySerializer().toByteArray(key.getKey());
        final PartitionId partitionId = store.getDispatcher().getPartitionId(parentKeyBytes);
        Set<Integer> partitions = params.getPartitions();
        if (partitions != null && !partitions.contains(partitionId.getPartitionId())) {
            return new EmptyTableIterator<PrimaryKey>();
        }
        final TableImpl table = key.getTable();
        return new MultiGetIteratorWrapper<PrimaryKey>(){
            private boolean moreElements = true;
            private byte[] resumeKey = null;

            PrimaryKey[] getMoreElements() {
                if (!this.moreElements) {
                    return null;
                }
                TableKeysIterate op = new TableKeysIterate(params, targetTables, true, this.resumeKey);
                Request req = store.makeReadRequest((InternalOperation)op, partitionId, params.getConsistency(), params.getTimeout(), params.getTimeoutUnit());
                Result result = store.executeRequest(req);
                this.moreElements = result.hasMoreElements();
                List<ResultKey> byteKeyResults = result.getKeyList();
                if (byteKeyResults.isEmpty()) {
                    assert (!this.moreElements);
                    return null;
                }
                this.resumeKey = byteKeyResults.get(byteKeyResults.size() - 1).getKeyBytes();
                return TableScan.convertTableKeyResults(byteKeyResults, table, targetTables);
            }
        };
    }

    private static class EmptyTableIterator<E>
    extends MultiGetIteratorWrapper<E> {
        private EmptyTableIterator() {
        }

        @Override
        E[] getMoreElements() {
            return null;
        }
    }

    private static abstract class MultiGetIteratorWrapper<E>
    implements TableIterator<E> {
        private E[] elements = null;
        private int nextElement = 0;

        private MultiGetIteratorWrapper() {
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            if (this.elements != null && this.nextElement < this.elements.length) {
                return true;
            }
            this.elements = this.getMoreElements();
            if (this.elements == null) {
                return false;
            }
            assert (this.elements.length > 0);
            this.nextElement = 0;
            return true;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.elements[this.nextElement++];
        }

        abstract E[] getMoreElements();

        @Override
        public void close() {
        }

        @Override
        public List<DetailedMetrics> getPartitionMetrics() {
            return Collections.emptyList();
        }

        @Override
        public List<DetailedMetrics> getShardMetrics() {
            return Collections.emptyList();
        }
    }
}

