/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldMap;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.query.compiler.EscapeUtil;

public class TablePath {
    private final FieldMap fieldMap;
    private List<StepInfo> steps;
    private boolean isComplex;

    public TablePath(TableImpl table, String path) {
        this(table.getFieldMap(), path);
    }

    protected TablePath(FieldMap fieldMap, String path) {
        this.fieldMap = fieldMap;
        this.steps = path != null ? TablePath.parsePathName(path) : new ArrayList<StepInfo>();
        this.isComplex = this.steps.size() > 1;
    }

    public TablePath(FieldMap fieldMap, List<String> steps) {
        this.fieldMap = fieldMap;
        this.steps = new ArrayList<StepInfo>(steps.size());
        for (int i = 0; i < steps.size(); ++i) {
            this.steps.add(new StepInfo(steps.get(i), false));
        }
        this.isComplex = steps.size() > 1;
    }

    public String toString() {
        return this.getPathName(this.steps.size());
    }

    public int hashCode() {
        return this.getPathName(this.steps.size()).hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof TablePath)) {
            return false;
        }
        TablePath other = (TablePath)o;
        if (this.steps.size() != other.steps.size()) {
            return false;
        }
        for (int i = 0; i < this.steps.size(); ++i) {
            StepInfo si1 = this.steps.get(i);
            StepInfo si2 = other.steps.get(i);
            if (si1.kind == StepKind.MAP_FIELD ? !si1.step.equals(si2.step) : !si1.step.equalsIgnoreCase(si2.step)) {
                return false;
            }
            if (si1.kind == si2.kind) continue;
            return false;
        }
        return true;
    }

    public void clear() {
        this.steps.clear();
        this.isComplex = false;
    }

    final FieldMap getFieldMap() {
        return this.fieldMap;
    }

    public final boolean isComplex() {
        return this.isComplex;
    }

    public boolean isEmpty() {
        return this.steps.isEmpty();
    }

    public int numSteps() {
        return this.steps.size();
    }

    final StepInfo getStepInfo(int pos) {
        return this.steps.get(pos);
    }

    final void addStepInfo(StepInfo si) {
        this.steps.add(si);
        if (this.steps.size() > 1) {
            this.isComplex = true;
        }
    }

    public final String getStep(int pos) {
        return this.steps.get((int)pos).step;
    }

    final void setStep(int pos, String step) {
        this.steps.get((int)pos).step = step;
    }

    final void add(int pos, String step, boolean isQuoted) {
        this.steps.add(pos, new StepInfo(step, isQuoted));
        if (this.steps.size() > 1) {
            this.isComplex = true;
        }
    }

    public final String remove(int pos) {
        StepInfo si = this.steps.remove(pos);
        if (this.steps.size() <= 1) {
            this.isComplex = false;
        }
        return si.step;
    }

    public StepKind getStepKind(int pos) {
        return this.steps.get((int)pos).kind;
    }

    public boolean isMapKeyStep(int pos) {
        return this.steps.get((int)pos).kind == StepKind.MAP_FIELD;
    }

    void setIsMapKeyStep(int pos) {
        this.steps.get((int)pos).kind = StepKind.MAP_FIELD;
    }

    public boolean isKeysStep(int pos) {
        return this.steps.get((int)pos).kind == StepKind.KEYS;
    }

    public boolean isValuesStep(int pos) {
        return this.steps.get((int)pos).kind == StepKind.VALUES;
    }

    void setIsValuesStep(int pos) {
        StepInfo si = this.steps.get(pos);
        si.kind = StepKind.VALUES;
        si.step = "values()";
        si.isQuoted = false;
    }

    public boolean isBracketsStep(int pos) {
        return this.steps.get((int)pos).kind == StepKind.BRACKETS;
    }

    public void reverseSteps() {
        Collections.reverse(this.steps);
    }

    public final String getLastStep() {
        return this.steps.get((int)(this.steps.size() - 1)).step;
    }

    public FieldDefImpl getFirstDef() {
        return this.fieldMap.getFieldDef(this.steps.get((int)0).step);
    }

    static List<StepInfo> parsePathName(String pathname) {
        ArrayList<StepInfo> list = new ArrayList<StepInfo>();
        StringBuilder sb = new StringBuilder();
        boolean inQuotedStep = false;
        boolean isQuoted = false;
        boolean done = false;
        for (int i = 0; i < pathname.length(); ++i) {
            char ch = pathname.charAt(i);
            if (ch == '\"') {
                if (inQuotedStep) {
                    if (i > 0 && pathname.charAt(i - 1) == '\\') {
                        sb.append(ch);
                        continue;
                    }
                    inQuotedStep = false;
                    continue;
                }
                inQuotedStep = true;
                isQuoted = true;
                continue;
            }
            if (!(inQuotedStep || ch != '.' && ch != '[')) {
                String step = sb.toString();
                step = EscapeUtil.inlineEscapedChars(step);
                list.add(new StepInfo(step, isQuoted));
                sb.delete(0, sb.length());
                isQuoted = false;
                if (ch != '[') continue;
                if (++i == pathname.length() || pathname.charAt(i) != ']') {
                    throw new IllegalArgumentException("Malformed path name: " + pathname);
                }
                list.add(new StepInfo("[]", false));
                if (++i != pathname.length()) continue;
                done = true;
                continue;
            }
            sb.append(ch);
        }
        if (!done) {
            String step = sb.toString();
            step = EscapeUtil.inlineEscapedChars(step);
            list.add(new StepInfo(step, isQuoted));
        }
        return list;
    }

    public final String getPathName() {
        return this.getPathName(this.steps.size());
    }

    public final String getPathName(int pos) {
        StringBuilder sb = new StringBuilder();
        int numSteps = this.steps.size();
        for (int i = 0; i < pos; ++i) {
            StepInfo si = this.steps.get(i);
            if (this.isBracketsStep(i)) {
                sb.delete(sb.length() - 1, sb.length());
            }
            if (si.isQuoted) {
                sb.append("\"").append(si.step).append("\"");
            } else {
                sb.append(si.step);
            }
            if (i >= numSteps - 1) continue;
            sb.append(".");
        }
        return sb.toString();
    }

    static class StepInfo {
        String step;
        StepKind kind;
        boolean isQuoted;

        StepInfo(String step, boolean isQuoted) {
            this.step = step;
            this.isQuoted = isQuoted;
            this.kind = !isQuoted ? (step.equals("[]") ? StepKind.BRACKETS : (step.equalsIgnoreCase("values()") ? StepKind.VALUES : (step.equalsIgnoreCase("keys()") ? StepKind.KEYS : StepKind.REC_FIELD))) : StepKind.REC_FIELD;
        }

        StepInfo(StepInfo si) {
            this.step = si.step;
            this.kind = si.kind;
            this.isQuoted = si.isQuoted;
        }
    }

    public static enum StepKind {
        BRACKETS,
        VALUES,
        KEYS,
        REC_FIELD,
        MAP_FIELD;

    }
}

