/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import oracle.kv.Depth;
import oracle.kv.Direction;
import oracle.kv.Key;
import oracle.kv.KeyRange;
import oracle.kv.StoreIteratorConfig;
import oracle.kv.ValueVersion;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.StoreIteratorParams;
import oracle.kv.impl.api.bulk.BulkMultiGet;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.MultiGetBatchTable;
import oracle.kv.impl.api.ops.MultiGetBatchTableKeys;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.ops.ResultKey;
import oracle.kv.impl.api.ops.ResultKeyValueVersion;
import oracle.kv.impl.api.table.PrimaryKeyImpl;
import oracle.kv.impl.api.table.RowImpl;
import oracle.kv.impl.api.table.TableAPIImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TableKey;
import oracle.kv.impl.api.table.TargetTables;
import oracle.kv.table.FieldRange;
import oracle.kv.table.MultiRowOptions;
import oracle.kv.table.PrimaryKey;
import oracle.kv.table.Row;
import oracle.kv.table.TableIterator;
import oracle.kv.table.TableIteratorOptions;

class TableMultiGetBatch {
    private final KVStoreImpl store;
    private final TableAPIImpl apiImpl;
    private final StoreIteratorParams params;
    private final StoreIteratorConfig config;
    private final List<Iterator<PrimaryKey>> primaryKeyIterators;
    private final MultiRowOptions getOptions;
    private final FieldRange fieldRange;
    private final AtomicReference<OperationInfo> opInfo;

    TableMultiGetBatch(TableAPIImpl apiImpl, List<Iterator<PrimaryKey>> primaryKeyIterators, MultiRowOptions getOptions, TableIteratorOptions iterateOptions) {
        this.apiImpl = apiImpl;
        this.primaryKeyIterators = primaryKeyIterators;
        this.getOptions = getOptions;
        this.store = apiImpl.getStore();
        this.opInfo = new AtomicReference<Object>(null);
        TableIteratorOptions tio = iterateOptions;
        this.config = new StoreIteratorConfig();
        if (tio != null) {
            this.config.setMaxConcurrentRequests(tio.getMaxConcurrentRequests());
        }
        KeyRange useRange = null;
        if (getOptions != null) {
            this.fieldRange = getOptions.getFieldRange();
            if (this.fieldRange != null) {
                useRange = TableAPIImpl.createKeyRange(this.fieldRange);
            }
        } else {
            this.fieldRange = null;
        }
        this.params = new StoreIteratorParams(Direction.UNORDERED, TableAPIImpl.getBatchSize(tio), null, useRange, Depth.PARENT_AND_DESCENDANTS, TableAPIImpl.getConsistency(tio), TableAPIImpl.getTimeout(tio), TableAPIImpl.getTimeoutUnit(tio));
    }

    TableIterator<PrimaryKey> createKeysIterator() {
        BulkMultiGet.BulkGetIterator<PrimaryKey, PrimaryKey> getIterator = new BulkMultiGet.BulkGetIterator<PrimaryKey, PrimaryKey>(this.store, this.primaryKeyIterators, this.params, this.config){

            @Override
            public void validateKey(PrimaryKey key) {
                TableMultiGetBatch.this.validatePrimaryKey(key);
            }

            @Override
            public Key getKey(PrimaryKey key) {
                return ((RowImpl)((Object)key)).getPrimaryKey(true);
            }

            @Override
            protected InternalOperation generateBulkGetOp(List<byte[]> parentKeys, byte[] resumeKey) {
                return new MultiGetBatchTableKeys(parentKeys, resumeKey, TableMultiGetBatch.this.getTargetTables(), TableMultiGetBatch.this.params.getSubRange(), TableMultiGetBatch.this.params.getBatchSize());
            }

            @Override
            protected void convertResult(Result result, List<PrimaryKey> elementList) {
                List<ResultKey> results = result.getKeyList();
                if (results.size() == 0) {
                    return;
                }
                TableImpl table = TableMultiGetBatch.this.getTopTable();
                for (ResultKey rkey : results) {
                    PrimaryKeyImpl pkey = table.createPrimaryKeyFromResultKey(rkey);
                    if (pkey == null) {
                        throw new IllegalArgumentException("Fail to convert to primary key");
                    }
                    elementList.add(pkey);
                }
            }
        };
        return getIterator;
    }

    TableIterator<Row> createIterator() {
        BulkMultiGet.BulkGetIterator<PrimaryKey, Row> getIterator = new BulkMultiGet.BulkGetIterator<PrimaryKey, Row>(this.store, this.primaryKeyIterators, this.params, this.config){

            @Override
            public void validateKey(PrimaryKey key) {
                TableMultiGetBatch.this.validatePrimaryKey(key);
            }

            @Override
            public Key getKey(PrimaryKey key) {
                return ((RowImpl)((Object)key)).getPrimaryKey(true);
            }

            @Override
            protected InternalOperation generateBulkGetOp(List<byte[]> parentKeys, byte[] resumeKey) {
                return new MultiGetBatchTable(parentKeys, resumeKey, TableMultiGetBatch.this.getTargetTables(), TableMultiGetBatch.this.params.getSubRange(), TableMultiGetBatch.this.params.getBatchSize());
            }

            @Override
            protected void convertResult(Result result, List<Row> elementList) {
                List<ResultKeyValueVersion> results = result.getKeyValueVersionList();
                if (results.size() == 0) {
                    return;
                }
                TableImpl topTable = TableMultiGetBatch.this.getTopTable();
                for (ResultKeyValueVersion entry : results) {
                    byte[] keyBytes = entry.getKeyBytes();
                    Key key = this.keySerializer.fromByteArray(keyBytes);
                    ValueVersion vv = new ValueVersion(entry.getValue(), entry.getVersion());
                    RowImpl row = topTable.createRowFromKeyBytes(key.toByteArray());
                    if (row == null) {
                        throw new IllegalArgumentException("Fail to convert to row");
                    }
                    row = TableMultiGetBatch.this.apiImpl.getRowFromValueVersion(vv, row, entry.getExpirationTime(), false);
                    elementList.add(row);
                }
            }
        };
        return getIterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validatePrimaryKey(PrimaryKey key) {
        if (this.opInfo.get() == null) {
            AtomicReference<OperationInfo> atomicReference = this.opInfo;
            synchronized (atomicReference) {
                if (this.opInfo.get() == null) {
                    OperationInfo ti = new OperationInfo(key, this.getOptions);
                    this.opInfo.set(ti);
                }
            }
        }
        TableImpl table = this.getTarget();
        assert (table != null);
        if (!table.equals(key.getTable())) {
            throw new IllegalArgumentException("The primary key is not for table \"" + table.getFullName() + "\" but for \"" + key.getTable().getFullName() + "\": " + key.toJsonString(false));
        }
        for (String keyField : table.getShardKey()) {
            if (key.get(keyField) != null) continue;
            throw new IllegalArgumentException("A required field \"" + keyField + "\" is missing from the Primary Key: " + key.toJsonString(false));
        }
        if (this.fieldRange != null) {
            TableKey tkey = TableKey.createKey(table, key, true);
            tkey.validateFieldOrder(this.fieldRange);
        }
    }

    private TableImpl getTarget() {
        return this.opInfo.get().getTarget();
    }

    private TargetTables getTargetTables() {
        return this.opInfo.get().getTargetTables();
    }

    private TableImpl getTopTable() {
        return this.opInfo.get().getTopTable();
    }

    private static final class OperationInfo {
        private final TableImpl target;
        private final TableImpl topTable;
        private final TargetTables targetTables;

        OperationInfo(PrimaryKey key, MultiRowOptions opt) {
            this.target = (TableImpl)key.getTable().clone();
            this.targetTables = TableAPIImpl.makeTargetTables(this.target, opt);
            TableImpl tableImpl = this.topTable = this.targetTables.hasAncestorTables() ? this.target.getTopLevelTable() : this.target;
            if (opt != null) {
                TableAPIImpl.validateMultiRowOptions(opt, this.target, false);
            }
        }

        TableImpl getTarget() {
            return this.target;
        }

        TableImpl getTopTable() {
            return this.topTable;
        }

        TargetTables getTargetTables() {
            return this.targetTables;
        }
    }
}

