/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.util.PackedInteger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import oracle.kv.Key;
import oracle.kv.Value;
import oracle.kv.ValueVersion;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.api.ops.ResultKey;
import oracle.kv.impl.api.table.ArrayDefImpl;
import oracle.kv.impl.api.table.ArrayValueImpl;
import oracle.kv.impl.api.table.BinaryValueImpl;
import oracle.kv.impl.api.table.ComplexValueImpl;
import oracle.kv.impl.api.table.EnumDefImpl;
import oracle.kv.impl.api.table.FieldComparator;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldMap;
import oracle.kv.impl.api.table.FieldMapEntry;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.FieldValueSerialization;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.IndexKeyImpl;
import oracle.kv.impl.api.table.MapDefImpl;
import oracle.kv.impl.api.table.MapValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.api.table.NumberValueImpl;
import oracle.kv.impl.api.table.PrimaryKeyImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.ReturnRowImpl;
import oracle.kv.impl.api.table.RowImpl;
import oracle.kv.impl.api.table.TableJsonUtils;
import oracle.kv.impl.api.table.TableKey;
import oracle.kv.impl.api.table.TableMetadata;
import oracle.kv.impl.api.table.TablePath;
import oracle.kv.impl.api.table.TableVersionException;
import oracle.kv.impl.api.table.TabularFormatter;
import oracle.kv.impl.api.table.TimestampDefImpl;
import oracle.kv.impl.api.table.TimestampValueImpl;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.metadata.MetadataInfo;
import oracle.kv.impl.security.Ownable;
import oracle.kv.impl.security.ResourceOwner;
import oracle.kv.impl.util.ArrayPosition;
import oracle.kv.impl.util.JsonUtils;
import oracle.kv.impl.util.SortableString;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldRange;
import oracle.kv.table.FieldValue;
import oracle.kv.table.Index;
import oracle.kv.table.IndexKey;
import oracle.kv.table.MultiRowOptions;
import oracle.kv.table.RecordDef;
import oracle.kv.table.RecordValue;
import oracle.kv.table.ReturnRow;
import oracle.kv.table.Row;
import oracle.kv.table.Table;
import oracle.kv.table.TimeToLive;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.codehaus.jackson.map.ObjectWriter;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

public class TableImpl
implements Table,
MetadataInfo,
Ownable,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private long id;
    private final TableImpl parent;
    private final TreeMap<String, Index> indexes;
    private final List<String> primaryKey;
    private final List<Integer> primaryKeySizes;
    private final List<String> shardKey;
    private final String description;
    private final Map<String, Table> children;
    private final ArrayList<FieldMap> versions;
    private TimeToLive ttl;
    private TableStatus status;
    private final boolean r2compat;
    private final int schemaId;
    private final ResourceOwner owner;
    private final boolean sysTable;
    private String namespace;
    private volatile transient int version;
    private transient int numKeyComponents;
    private transient String idString;
    private transient RecordDefImpl primaryKeyDef;
    private transient ArrayList<TableVersionInfo> tableVersionInfo;
    public static final String BRACKETS = "[]";
    public static final String KEYS = "keys()";
    public static final String VALUES = "values()";
    public static final String FN_KEYS = "keys(";
    public static final String FN_KEYOF = "keyof(";
    public static final String FN_ELEMENTOF = "elementof(";
    public static final String SEPARATOR = ".";
    private static final int MAX_ID_LENGTH = 32;
    static final int MAX_NAME_LENGTH = 64;
    private static final String SEPARATOR_REGEX = "\\.";
    private static final int INITIAL_TABLE_VERSION = 1;
    public static final String SYSTEM_TABLE_PREFIX = "SYS$";
    private static final String SYSTEM_TABLE_PREFIX_STRING = "SYS";
    static final String VALID_NAME_CHAR_REGEX = "^[A-Za-z][A-Za-z0-9_]*$";
    static final String VALID_NAMESPACE_CHAR_REGEX = "^[A-Za-z][A-Za-z0-9_.]*$";
    private static final int MAX_NAMESPACE_LENGTH = 128;

    private TableImpl(String namespace, String name, TableImpl parent, List<String> primaryKey, List<Integer> primaryKeySizes, List<String> shardKey, FieldMap fields, TimeToLive ttl, boolean r2compat, int schemaId, String description, boolean validate, ResourceOwner owner, boolean sysTable) {
        this.name = name;
        this.namespace = namespace;
        this.parent = parent;
        this.description = description;
        this.primaryKey = primaryKey;
        this.primaryKeySizes = primaryKeySizes;
        this.shardKey = shardKey;
        this.status = TableStatus.READY;
        this.r2compat = r2compat;
        this.schemaId = schemaId;
        this.sysTable = sysTable;
        this.children = new TreeMap<String, Table>(FieldComparator.instance);
        this.indexes = new TreeMap(FieldComparator.instance);
        this.versions = new ArrayList();
        this.versions.add(fields);
        this.ttl = ttl;
        this.setVersion(1);
        TableImpl.validateTableName(name, sysTable);
        if (validate) {
            this.validate();
        }
        this.setIdString();
        this.initializeVersionInfo(validate);
        this.owner = owner == null ? null : new ResourceOwner(owner);
    }

    private TableImpl(TableImpl t) {
        this.name = t.name;
        this.namespace = t.namespace;
        this.id = t.id;
        this.version = t.version;
        this.description = t.description;
        this.parent = t.parent;
        this.primaryKey = t.primaryKey;
        this.primaryKeySizes = t.primaryKeySizes;
        this.shardKey = t.shardKey;
        this.status = t.status;
        this.r2compat = t.r2compat;
        this.schemaId = t.schemaId;
        this.owner = t.owner;
        this.sysTable = t.sysTable;
        this.children = new TreeMap<String, Table>(FieldComparator.instance);
        for (Table table : t.children.values()) {
            this.children.put(table.getName(), ((TableImpl)table).clone());
        }
        this.versions = new ArrayList<FieldMap>(t.versions);
        this.ttl = t.ttl;
        this.setVersion(t.version);
        this.indexes = new TreeMap<String, Index>((SortedMap<String, Index>)t.indexes);
        this.setIdString();
        this.initializeVersionInfo(true);
    }

    public static TableImpl createTable(String namespace, String name, Table parent, List<String> primaryKey, List<Integer> primaryKeySizes, List<String> shardKey, FieldMap fields, boolean r2compat, int schemaId, String description, boolean validate, ResourceOwner owner, TimeToLive ttl, boolean sysTable) {
        if (name == null) {
            throw new IllegalArgumentException("Table names cannot be null");
        }
        return new TableImpl(namespace, name, (TableImpl)parent, primaryKey, primaryKeySizes, shardKey, fields, ttl, r2compat, schemaId, description, validate, owner, sysTable);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.getTableVersion();
        this.setIdString();
        this.initializeVersionInfo(true);
    }

    @Override
    public TableImpl clone() {
        return new TableImpl(this);
    }

    @Override
    public TableImpl getChildTable(String tableName) {
        return (TableImpl)this.children.get(tableName);
    }

    @Override
    public boolean childTableExists(String tableName) {
        return this.children.containsKey(tableName);
    }

    @Override
    public Table getVersion(int version1) {
        if (this.versions.size() < version1 || version1 < 0) {
            throw new IllegalArgumentException("Table version " + version1 + " does not exist for table " + this.getFullName());
        }
        TableImpl newTable = this.clone();
        newTable.setVersion(version1);
        newTable.initializeVersionInfo(true);
        return newTable;
    }

    @Override
    public Map<String, Table> getChildTables() {
        return Collections.unmodifiableMap(this.children);
    }

    @Override
    public Table getParent() {
        return this.parent;
    }

    public String getAvroSchema(boolean pretty) {
        return this.generateAvroSchema(this.version, pretty);
    }

    public Schema getSchema() {
        return this.getVersionInfo().getAvroSchema();
    }

    @Override
    public int getTableVersion() {
        if (this.version == 0) {
            this.setVersion(this.versions.size());
        }
        return this.version;
    }

    @Override
    public Index getIndex(String indexName) {
        return this.indexes.get(indexName);
    }

    public Index getSecondaryIndex(String indexName) {
        Index i = this.indexes.get(indexName);
        if (i == null || i.getType() == Index.IndexType.SECONDARY) {
            return i;
        }
        throw new IllegalArgumentException("The index named " + indexName + " is not a secondary index.");
    }

    public Index getTextIndex(String indexName) {
        Index i = this.indexes.get(indexName);
        if (i == null || i.getType() == Index.IndexType.TEXT) {
            return i;
        }
        throw new IllegalArgumentException("The index named " + indexName + " is not a text index.");
    }

    @Override
    public Map<String, Index> getIndexes() {
        return Collections.unmodifiableMap(this.indexes);
    }

    @Override
    public Map<String, Index> getIndexes(Index.IndexType type) {
        TreeMap<String, Index> r = new TreeMap<String, Index>();
        for (Map.Entry<String, Index> entry : this.indexes.entrySet()) {
            if (entry.getValue().getType() != type) continue;
            r.put(entry.getKey(), entry.getValue());
        }
        return r;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFullName() {
        StringBuilder sb = new StringBuilder();
        this.getTableNameInternal(sb);
        return sb.toString();
    }

    public long getId() {
        return this.id;
    }

    public String getIdString() {
        return this.idString;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<String> getFields() {
        return Collections.unmodifiableList(this.getFieldMap().getFieldNames());
    }

    private void setVersion(int currentVersion) {
        assert (currentVersion > 0);
        this.version = currentVersion;
    }

    @Override
    public FieldDef getField(String fieldName) {
        FieldMapEntry fme = this.getFieldMapEntry(fieldName, false);
        if (fme != null) {
            return fme.getFieldDef();
        }
        return null;
    }

    @Override
    public boolean isNullable(String fieldName) {
        FieldMapEntry fme = this.getFieldMapEntry(fieldName, true);
        return fme.isNullable();
    }

    @Override
    public FieldValue getDefaultValue(String fieldName) {
        FieldMapEntry fme = this.getFieldMapEntry(fieldName, true);
        return fme.getDefaultValue();
    }

    @Override
    public List<String> getPrimaryKey() {
        return Collections.unmodifiableList(this.primaryKey);
    }

    @Override
    public List<String> getShardKey() {
        return Collections.unmodifiableList(this.shardKey);
    }

    public List<String> getPrimaryKeyInternal() {
        return this.primaryKey;
    }

    public int getPrimaryKeySize() {
        return this.primaryKey.size();
    }

    public List<Integer> getPrimaryKeySizes() {
        return this.primaryKeySizes;
    }

    public String getPrimaryKeyColumnName(int i) {
        return this.primaryKey.get(i);
    }

    List<String> getShardKeyInternal() {
        return this.shardKey;
    }

    public int getShardKeySize() {
        return this.shardKey.size();
    }

    @Override
    public RowImpl createRow() {
        return new RowImpl(this.getVersionInfo().getRecordDef(), this);
    }

    @Override
    public RowImpl createRow(RecordValue value) {
        if (value instanceof IndexKey) {
            throw new IllegalArgumentException("Index keys cannot be passed to createRow");
        }
        RowImpl row = this.createRow();
        TableImpl.populateRecord(row, value);
        return row;
    }

    @Override
    public RowImpl createRowWithDefaults() {
        TableVersionInfo info = this.getVersionInfo();
        RowImpl row = this.createRow();
        FieldMap fieldMap = this.getFieldMap();
        for (int pos = 0; pos < fieldMap.size(); ++pos) {
            if (info.isPrimKeyAtPos(pos)) continue;
            row.put(pos, (FieldValue)fieldMap.getDefaultValue(pos));
        }
        return row;
    }

    @Override
    public PrimaryKeyImpl createPrimaryKey() {
        return new PrimaryKeyImpl(this.primaryKeyDef, this);
    }

    @Override
    public PrimaryKeyImpl createPrimaryKey(RecordValue value) {
        if (value instanceof IndexKey) {
            throw new IllegalArgumentException("Index keys cannot be passed to createPrimaryKey");
        }
        PrimaryKeyImpl key = new PrimaryKeyImpl(this.primaryKeyDef, this);
        TableImpl.populateRecord(key, value);
        return key;
    }

    @Override
    public ReturnRowImpl createReturnRow(ReturnRow.Choice returnChoice) {
        return new ReturnRowImpl(this.getVersionInfo().getRecordDef(), this, returnChoice);
    }

    @Override
    public Row createRowFromJson(String jsonInput, boolean exact) {
        return this.createRowFromJson(new ByteArrayInputStream(jsonInput.getBytes()), exact);
    }

    @Override
    public Row createRowFromJson(InputStream jsonInput, boolean exact) {
        RowImpl row = this.createRow();
        ComplexValueImpl.createFromJson((ComplexValueImpl)row, jsonInput, exact, false);
        return row;
    }

    @Override
    public PrimaryKeyImpl createPrimaryKeyFromJson(String jsonInput, boolean exact) {
        return this.createPrimaryKeyFromJson(new ByteArrayInputStream(jsonInput.getBytes()), exact);
    }

    @Override
    public PrimaryKeyImpl createPrimaryKeyFromJson(InputStream jsonInput, boolean exact) {
        PrimaryKeyImpl key = this.createPrimaryKey();
        ComplexValueImpl.createFromJson((ComplexValueImpl)key, jsonInput, exact, false);
        return key;
    }

    @Override
    public FieldRange createFieldRange(String fieldName) {
        FieldDef def = this.getField(fieldName);
        if (def == null) {
            throw new IllegalArgumentException("Field does not exist in table definition: " + fieldName);
        }
        if (!this.primaryKey.contains(fieldName)) {
            throw new IllegalArgumentException("Field does not exist in primary key: " + fieldName);
        }
        return new FieldRange(fieldName, def, this.getPrimaryKeySize(fieldName));
    }

    @Override
    public MultiRowOptions createMultiRowOptions(List<String> tableNames, FieldRange fieldRange) {
        if ((tableNames == null || tableNames.isEmpty()) && fieldRange == null) {
            throw new IllegalArgumentException("createMultiRowOptions must have at least one non-null parameter");
        }
        MultiRowOptions mro = null;
        if (fieldRange != null) {
            mro = new MultiRowOptions(fieldRange);
        }
        if (tableNames != null) {
            ArrayList<Table> ancestorTables = new ArrayList<Table>();
            ArrayList<Table> childTables = new ArrayList<Table>();
            TableImpl topLevelTable = this.getTopLevelTable();
            for (String tableName : tableNames) {
                TableImpl t = topLevelTable.findTable(tableName);
                if (t == this) {
                    throw new IllegalArgumentException("Target table must not appear in included tables list");
                }
                if (TableImpl.isAncestorOf(this, t)) {
                    ancestorTables.add(t);
                    continue;
                }
                assert (TableImpl.isAncestorOf(t, this));
                childTables.add(t);
            }
            if (mro == null) {
                mro = new MultiRowOptions(null, ancestorTables, childTables);
            } else {
                mro.setIncludedParentTables(ancestorTables);
                mro.setIncludedChildTables(childTables);
            }
        }
        return mro;
    }

    public int getPrimaryKeySize(String keyName) {
        if (this.primaryKeySizes != null) {
            return this.primaryKeySizes.get(this.primaryKey.indexOf(keyName));
        }
        return 0;
    }

    public int getPrimaryKeySize(int pos) {
        if (this.primaryKeySizes != null) {
            return this.primaryKeySizes.get(pos);
        }
        return 0;
    }

    public boolean isAncestor(Table ancestor) {
        String fullName = ancestor.getFullName();
        for (Table parentTable = this.getParent(); parentTable != null; parentTable = parentTable.getParent()) {
            if (!fullName.equals(parentTable.getFullName())) continue;
            return true;
        }
        return false;
    }

    public TableImpl getTopLevelTable() {
        if (this.parent != null) {
            return this.parent.getTopLevelTable();
        }
        return this;
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof Table) {
            TableImpl otherDef = (TableImpl)other;
            if (this.getName().equalsIgnoreCase(otherDef.getName()) && this.idsEqual(otherDef)) {
                if (this.getParent() != null ? !this.getParent().equals(otherDef.getParent()) : otherDef.getParent() != null) {
                    return false;
                }
                if (!TableImpl.equalsTTL(this.ttl, otherDef.ttl)) {
                    return false;
                }
                if (!TableImpl.equalsPKSizes(this.primaryKeySizes, otherDef.primaryKeySizes)) {
                    return false;
                }
                return this.versionsEqual(otherDef) && this.getFieldMap().equals(otherDef.getFieldMap());
            }
        }
        return false;
    }

    private boolean idsEqual(TableImpl other) {
        return this.getId() == other.getId() || this.getId() == 0L || other.getId() == 0L;
    }

    private static boolean equalsTTL(TimeToLive ttl, TimeToLive ottl) {
        if (ttl != null) {
            return ttl.equals(ottl);
        }
        return ottl == null;
    }

    private static boolean equalsPKSizes(List<Integer> pks, List<Integer> opks) {
        if (pks != null) {
            if (opks != null && pks.size() == opks.size()) {
                for (int i = 0; i < pks.size(); ++i) {
                    if (pks.get(i) == opks.get(i)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return opks == null;
    }

    public boolean fieldsEqual(Object other) {
        if (other != null && other instanceof Table) {
            TableImpl otherTable = (TableImpl)other;
            if (this.getName().equalsIgnoreCase(otherTable.getName())) {
                if (this.parent != null ? !this.parent.fieldsEqual(otherTable.parent) : otherTable.parent != null) {
                    return false;
                }
                return this.getFieldMap().equals(otherTable.getFieldMap()) && this.primaryKey.equals(otherTable.primaryKey) && this.shardKey.equals(otherTable.shardKey);
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getFullName().hashCode() + this.versions.size() + this.getFieldMap().hashCode() + (this.getDefaultTTL() != null ? this.getDefaultTTL().hashCode() : 0);
    }

    boolean nameEquals(TableImpl other) {
        return this.getFullName().equals(other.getFullName());
    }

    private boolean versionsEqual(TableImpl other) {
        int thisVersion = this.version == 0 ? this.versions.size() : this.version;
        int otherVersion = other.version == 0 ? other.versions.size() : other.version;
        return thisVersion == otherVersion;
    }

    @Override
    public int numTableVersions() {
        return this.versions.size();
    }

    public boolean hasChildren() {
        return this.children.size() != 0;
    }

    public boolean isR2compatible() {
        return this.r2compat;
    }

    public int getSchemaId() {
        return this.schemaId;
    }

    void setId(long id) {
        this.id = id;
        this.setIdString();
    }

    private void setIdString() {
        this.idString = this.id == 0L || this.r2compat ? this.name : TableImpl.createIdString(this.id);
    }

    public static String createIdString(long id) {
        int encodingLength = SortableString.encodingLength(id);
        return SortableString.toSortable(id, encodingLength);
    }

    public FieldMap getFieldMap() {
        return this.getFieldMap(this.version);
    }

    public int getNumKeyComponents() {
        if (this.numKeyComponents == 0) {
            this.calculateNumKeys();
        }
        return this.numKeyComponents;
    }

    private synchronized void calculateNumKeys() {
        if (this.numKeyComponents == 0) {
            int num = this.primaryKey.size() + 1;
            TableImpl t = this;
            while (t.parent != null) {
                ++num;
                t = t.parent;
            }
            this.numKeyComponents = num;
        }
    }

    public TableStatus getStatus() {
        return this.status;
    }

    public synchronized void setStatus(TableStatus newStatus) {
        if (this.status != newStatus && this.status.isDeleting()) {
            throw new IllegalStateException("Table is being deleted, cannot change status to " + (Object)((Object)newStatus));
        }
        this.status = newStatus;
    }

    Map<String, Table> getMutableChildTables() {
        return this.children;
    }

    FieldMapEntry getFieldMapEntry(String fieldName, boolean mustExist) {
        FieldMap fieldMap = this.getFieldMap();
        FieldMapEntry fme = fieldMap.getFieldMapEntry(fieldName);
        if (fme != null) {
            return fme;
        }
        if (mustExist) {
            throw new IllegalArgumentException("Field does not exist in table definition: " + fieldName);
        }
        return null;
    }

    Map<String, Index> getMutableIndexes() {
        return this.indexes;
    }

    public String getParentName() {
        if (this.parent != null) {
            return this.parent.getFullName();
        }
        return null;
    }

    public Key createKey(Row row, boolean allowPartial) {
        this.setTableVersion(row);
        return TableKey.createKey(this, row, allowPartial).getKey();
    }

    public RowImpl createRowFromKeyBytes(byte[] keyBytes) {
        return this.createFromKeyBytes(keyBytes, false);
    }

    public PrimaryKeyImpl createPrimaryKeyFromKeyBytes(byte[] keyBytes) {
        return (PrimaryKeyImpl)this.createFromKeyBytes(keyBytes, true);
    }

    PrimaryKeyImpl createPrimaryKeyFromResultKey(ResultKey rkey) {
        PrimaryKeyImpl pkey = (PrimaryKeyImpl)this.createFromKeyBytes(rkey.getKeyBytes(), true);
        if (pkey != null) {
            pkey.setExpirationTime(rkey.getExpirationTime());
        }
        return pkey;
    }

    private RowImpl createFromKeyBytes(byte[] keyBytes, boolean createPrimaryKey) {
        Key.BinaryKeyIterator keyIter = this.createBinaryKeyIterator(keyBytes);
        if (keyIter == null) {
            return null;
        }
        TableImpl targetTable = this.findTargetTable(keyIter);
        if (targetTable == null) {
            return null;
        }
        keyIter.reset();
        ArrayPosition currentPrimKeyPos = new ArrayPosition(targetTable.primaryKey.size());
        RowImpl row = createPrimaryKey ? targetTable.createPrimaryKey() : targetTable.createRow();
        targetTable.setTableVersion(row);
        if (targetTable.initRowFromKeyBytes(targetTable, currentPrimKeyPos, keyIter, row)) {
            return row;
        }
        return null;
    }

    RowImpl createRowFromBytes(byte[] keyBytes, byte[] valueBytes, boolean keyOnly) {
        RowImpl fullKey = this.createRowFromKeyBytes(keyBytes);
        if (fullKey != null && this.getId() == fullKey.getTableImpl().getId()) {
            if (keyOnly || valueBytes.length == 0) {
                return fullKey;
            }
            Value.Format format = Value.Format.fromFirstByte(valueBytes[0]);
            if (format == Value.Format.TABLE || format == Value.Format.AVRO && this.r2compat) {
                int offset = 1;
                if (format == Value.Format.AVRO && this.r2compat) {
                    offset = PackedInteger.getReadSortedIntLength(valueBytes, 0);
                }
                if (this.initRowFromByteValue(fullKey, valueBytes, format, offset)) {
                    return fullKey;
                }
            }
        }
        return null;
    }

    private boolean initRowFromKeyBytes(TableImpl targetTable, ArrayPosition currentPrimKeyColumn, Key.BinaryKeyIterator keyIter, RowImpl row) {
        if (this.parent != null && !this.parent.initRowFromKeyBytes(targetTable, currentPrimKeyColumn, keyIter, row)) {
            return false;
        }
        assert (!keyIter.atEndOfKey());
        String keyComponent = keyIter.next();
        if (!keyComponent.equals(this.getIdString())) {
            return false;
        }
        int lastPrimKeyCol = this.primaryKey.size() - 1;
        while (currentPrimKeyColumn.hasNext()) {
            int pos = currentPrimKeyColumn.next();
            assert (!keyIter.atEndOfKey());
            int pkFieldPos = row instanceof PrimaryKeyImpl ? pos : targetTable.getVersionInfo().getPrimKeyPositions()[pos];
            String val = keyIter.next();
            FieldDefImpl type = row.getFieldDef(pkFieldPos);
            try {
                row.put(pkFieldPos, (FieldValue)FieldDefImpl.createValueFromKeyString(val, type));
            }
            catch (Exception e) {
                return false;
            }
            if (pos != lastPrimKeyCol) continue;
            break;
        }
        return true;
    }

    int getDataSize(Row row) {
        Value value = this.createValue(row);
        return value.getValue().length + 1;
    }

    int getKeySize(Row row) {
        return this.createKey(row, true).toByteArray().length;
    }

    Value createValue(Row row) {
        if (this.getSchema() == null) {
            return Value.internalCreateValue(new byte[0], Value.Format.TABLE);
        }
        boolean isAvro = this.schemaId != 0 && this.getTableVersion() == 1;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        if (!isAvro) {
            int writeVersion = this.getTableVersion();
            outputStream.write(writeVersion);
            this.setTableVersion(row);
        } else {
            int size = PackedInteger.getWriteSortedIntLength(this.schemaId);
            byte[] buf = new byte[size];
            PackedInteger.writeSortedInt(buf, 0, this.schemaId);
            outputStream.write(buf, 0, size);
            ((RowImpl)row).setTableVersion(1);
        }
        BinaryEncoder e = TableJsonUtils.getEncoderFactory().binaryEncoder(outputStream, null);
        try {
            this.writeAvroRecord(e, (RecordValueImpl)((Object)row), true);
            e.flush();
            return Value.internalCreateValue(outputStream.toByteArray(), isAvro ? Value.Format.AVRO : Value.Format.TABLE);
        }
        catch (IOException ioe) {
            throw new IllegalCommandException("Failed to serialize Avro: " + ioe);
        }
    }

    public boolean initRowFromByteValue(RowImpl row, byte[] data, Value.Format format, int offset) {
        if (data.length >= offset + 1) {
            Schema writerSchema = this.getSchema();
            if (writerSchema == null) {
                return true;
            }
            byte tableVersion = format == Value.Format.AVRO ? (byte)1 : data[offset];
            row.setTableVersion(tableVersion);
            if (tableVersion != this.getTableVersion() && tableVersion > this.numTableVersions()) {
                throw new TableVersionException(tableVersion);
            }
            try {
                if (tableVersion != this.getTableVersion()) {
                    TableVersionInfo info = this.getVersionInfo(tableVersion);
                    writerSchema = info.getAvroSchema();
                }
                if (format != Value.Format.AVRO || offset == 0) {
                    ++offset;
                }
                BinaryDecoder decoder = TableJsonUtils.getDecoderFactory().binaryDecoder(data, offset, data.length - offset, null);
                SimpleAvroReader reader = new SimpleAvroReader(writerSchema, this.getSchema(), row);
                reader.read(decoder);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        this.fillInDefaultValues(row);
        return true;
    }

    private void fillInDefaultValues(RecordValueImpl row) {
        TableVersionInfo info = this.getVersionInfo();
        for (int pos = 0; pos < row.getNumFields(); ++pos) {
            FieldMapEntry fme = this.getFieldMap().getFieldMapEntry(pos);
            if (info.isPrimKeyAtPos(pos)) continue;
            if (fme.hasDefaultValue()) {
                row.put(pos, (FieldValue)fme.getDefaultValue());
                continue;
            }
            if (!fme.isNullable()) continue;
            row.putNull(pos);
        }
    }

    public boolean rowFromValueVersion(ValueVersion vv, RowImpl row) {
        assert (row != null);
        row.setVersion(vv.getVersion());
        if (vv.getValue() == null) {
            this.setTableVersion(row);
            return true;
        }
        byte[] data = vv.getValue().getValue();
        Value.Format format = vv.getValue().getFormat();
        if (!(format == Value.Format.TABLE || format == Value.Format.AVRO && this.r2compat || data.length <= 1)) {
            return false;
        }
        if (this.getSchema() == null) {
            return true;
        }
        return this.initRowFromByteValue(row, data, format, 0);
    }

    void evolve(FieldMap newFields, TimeToLive newTTL) {
        if (this.version == 255) {
            throw new IllegalCommandException("Can't evolve the table any further; too many versions");
        }
        this.validateEvolution(newFields);
        if (this.version != 0 && this.version != this.versions.size()) {
            throw new IllegalCommandException("Table evolution must be performed on the latest version");
        }
        this.versions.add(newFields);
        this.ttl = newTTL;
        this.setVersion(this.getTableVersion() + 1);
        this.initializeVersionInfo(true);
    }

    void validateFieldAddition(String fieldPath, FieldMapEntry fme) {
        if (this.findTableField(fieldPath) != null) {
            throw new IllegalArgumentException("Cannot add field, " + fieldPath + ", it already exists");
        }
        for (FieldMap map : this.versions) {
            FieldDefImpl def = TableImpl.findTableField(new TablePath(map, fieldPath));
            if (def == null || ((Object)def).equals(fme.getFieldDef())) continue;
            throw new IllegalArgumentException("Cannot add field, " + fieldPath + ". A version " + "of the table contains this name and the types do " + "not match, is: " + fme.getFieldDef().getType() + ", was: " + def.getType());
        }
    }

    boolean hasValueFields() {
        return this.getSchema() != null;
    }

    private void validateEvolution(FieldMap newFields) {
        for (String fieldName : this.primaryKey) {
            FieldDefImpl newDef;
            FieldDef oldDef = this.getField(fieldName);
            if (oldDef.equals(newDef = newFields.getFieldDef(fieldName))) continue;
            throw new IllegalCommandException("Evolution cannot modify the primary key");
        }
        for (Index index : this.indexes.values()) {
            for (IndexImpl.IndexField ifield : ((IndexImpl)index).getIndexFields()) {
                TablePath fieldPath = ifield.isJson() ? ifield.getJsonFieldPath() : ifield;
                FieldDefImpl def = TableImpl.findTableField(newFields, fieldPath.getPathName());
                if (def == null) {
                    throw new IllegalCommandException("Evolution cannot remove indexed fields");
                }
                FieldDefImpl origDef = TableImpl.findTableField(fieldPath);
                if (def.equals(origDef)) continue;
                throw new IllegalCommandException("Evolution cannot modify indexed fields");
            }
        }
    }

    public String toJsonString(boolean pretty) {
        return this.toJsonString(pretty, false);
    }

    public String toJsonString(boolean pretty, boolean includeChildren) {
        return TableJsonUtils.toJsonString(this, pretty, includeChildren);
    }

    public String formatTable(boolean asJson, List<List<String>> fieldPaths) {
        LinkedHashMap<String, Object> fields = null;
        if (fieldPaths != null) {
            fields = new LinkedHashMap<String, Object>();
            for (List<String> fieldPath : fieldPaths) {
                TablePath tablePath = new TablePath(this.getFieldMap(), fieldPath);
                if (tablePath.getLastStep() == BRACKETS || tablePath.getLastStep().equalsIgnoreCase(VALUES)) {
                    FieldDefImpl def = TableImpl.findTableField(tablePath);
                    if (def != null) {
                        fields.put(tablePath.getPathName(), def);
                        continue;
                    }
                    throw new IllegalArgumentException("No such field in table " + this.getFullName() + ": " + tablePath.getPathName());
                }
                fields.put(tablePath.getPathName(), this.getFieldMap().getFieldMapEntry(tablePath));
            }
        }
        if (asJson) {
            if (fields == null) {
                return this.toJsonString(true);
            }
            ObjectWriter writer = JsonUtils.createWriter(true);
            ObjectNode o = JsonUtils.createObjectNode();
            ArrayNode array = o.putArray("fields");
            for (Map.Entry e : fields.entrySet()) {
                ObjectNode fnode = array.addObject();
                fnode.put("name", (String)e.getKey());
                Object obj = e.getValue();
                if (obj instanceof FieldDefImpl) {
                    ((FieldDefImpl)obj).toJson(fnode);
                    continue;
                }
                assert (obj instanceof FieldMapEntry);
                ((FieldMapEntry)obj).toJson(fnode);
            }
            try {
                return writer.writeValueAsString(o);
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException("Failed to serialize table description: " + ioe.getMessage());
            }
        }
        return TabularFormatter.formatTable(this, fields);
    }

    public void addIndex(Index index) {
        this.checkForDuplicateIndex(index);
        this.indexes.put(index.getName(), index);
    }

    public Index removeIndex(String indexName) {
        return this.indexes.remove(indexName);
    }

    Key.BinaryKeyIterator createBinaryKeyIterator(byte[] key) {
        Key.BinaryKeyIterator keyIter = new Key.BinaryKeyIterator(key);
        if (this.parent != null) {
            for (int i = 0; i < this.parent.getNumKeyComponents(); ++i) {
                if (keyIter.atEndOfKey()) {
                    return null;
                }
                keyIter.skip();
            }
        }
        if (keyIter.atEndOfKey()) {
            return null;
        }
        String tableId = keyIter.next();
        if (this.getIdString().equals(tableId)) {
            return keyIter;
        }
        return null;
    }

    public TableImpl findTargetTable(byte[] key) {
        Key.BinaryKeyIterator iter = this.createBinaryKeyIterator(key);
        if (iter != null) {
            return this.findTargetTable(iter);
        }
        return null;
    }

    TableImpl findTargetTable(Key.BinaryKeyIterator keyIter) {
        int numPrimaryKeyComponentsToSkip = this.primaryKey.size();
        if (this.parent != null) {
            numPrimaryKeyComponentsToSkip -= this.parent.primaryKey.size();
        }
        for (int i = 0; i < numPrimaryKeyComponentsToSkip; ++i) {
            if (keyIter.atEndOfKey()) {
                return null;
            }
            keyIter.skip();
        }
        if (keyIter.atEndOfKey()) {
            return this;
        }
        String childId = keyIter.next();
        for (Table table : this.children.values()) {
            if (!((TableImpl)table).getIdString().equals(childId)) continue;
            return ((TableImpl)table).findTargetTable(keyIter);
        }
        return null;
    }

    public boolean isKeyComponent(String fieldName) {
        for (String component : this.primaryKey) {
            if (!fieldName.equalsIgnoreCase(component)) continue;
            return true;
        }
        return false;
    }

    public int findKeyComponent(String fieldName) {
        for (int i = 0; i < this.primaryKey.size(); ++i) {
            String pkname = this.primaryKey.get(i);
            if (!fieldName.equalsIgnoreCase(pkname)) continue;
            return i;
        }
        return -1;
    }

    boolean isIndexKeyComponent(TablePath tablePath) {
        for (Index index : this.indexes.values()) {
            if (!((IndexImpl)index).isIndexPath(tablePath)) continue;
            return true;
        }
        return false;
    }

    private FieldMap getFieldMap(int version1) {
        if (this.versions.size() < version1 || version1 < 0) {
            throw new IllegalCommandException("Table version " + version1 + " does not exist for table " + this.name);
        }
        int versionToGet = version1 == 0 ? this.versions.size() : version1;
        return this.versions.get(versionToGet - 1);
    }

    private TableVersionInfo getVersionInfo(int version1) {
        if (this.versions.size() < version1 || version1 < 0) {
            throw new IllegalCommandException("Table version " + version1 + " does not exist for table " + this.name);
        }
        int versionToGet = version1 == 0 ? this.versions.size() : version1;
        return this.tableVersionInfo.get(versionToGet - 1);
    }

    private TableVersionInfo getVersionInfo() {
        return this.getVersionInfo(this.version);
    }

    public int[] getPrimKeyPositions() {
        return this.getVersionInfo().getPrimKeyPositions();
    }

    public RecordDefImpl getRowDef() {
        return this.getVersionInfo().getRecordDef();
    }

    boolean isPrimKeyAtPos(int i) {
        return this.getVersionInfo().isPrimKeyAtPos(i);
    }

    private void throwMissingState(String state) {
        throw new IllegalCommandException("Table is missing state required for construction: " + state);
    }

    private void validate() {
        String pkField;
        int i;
        FieldMap fields;
        if (this.primaryKey.isEmpty()) {
            this.throwMissingState("primary key");
        }
        if (this.name == null) {
            this.throwMissingState("table name");
        }
        if ((fields = this.getFieldMap(0)) == null || fields.isEmpty()) {
            this.throwMissingState("no fields defined");
        }
        if (this.parent != null && this.primaryKey.size() <= this.parent.primaryKey.size()) {
            throw new IllegalCommandException("Child table needs a primary key component");
        }
        if (this.shardKey.size() > this.primaryKey.size()) {
            throw new IllegalCommandException("Shard key must be a subset of the primary key");
        }
        for (i = 0; i < this.shardKey.size(); ++i) {
            pkField = this.primaryKey.get(i);
            if (pkField != null && pkField.equals(this.shardKey.get(i))) continue;
            throw new IllegalCommandException("Shard key must be a subset of the primary key");
        }
        for (i = 0; i < this.primaryKey.size(); ++i) {
            pkField = this.primaryKey.get(i);
            FieldMapEntry fme = this.getFieldMapEntry(pkField, false);
            if (fme == null) {
                throw new IllegalCommandException("Primary key field is not a valid field: " + pkField);
            }
            fme.setAsPrimaryKey();
            FieldDefImpl field = fme.getFieldDef();
            if (!field.isValidKeyField()) {
                throw new IllegalCommandException("Field type cannot be part of a primary key: " + field.getType() + ", field name: " + pkField);
            }
            if (this.primaryKeySizes == null) continue;
            this.validateKeyFieldSize(field, this.primaryKeySizes.get(i));
        }
    }

    private void validateKeyFieldSize(FieldDef field, int size) {
        if (size != 0 && !field.isInteger()) {
            throw new IllegalCommandException("Only Integer sizes can be constrained. Invalid type: " + field.getType());
        }
        if (size != 0 && (size < 1 || size > 5)) {
            throw new IllegalCommandException("Size constraint value on primary key must be between 1 and 5. Invalid value: " + size);
        }
    }

    public void createExportRowFromValueSchema(Schema writerSchema, Schema readerSchema, RowImpl row, byte[] data, int offset, int tableVersion) {
        if (data.length >= offset + 1) {
            ++offset;
            if (readerSchema == null) {
                readerSchema = this.getSchema();
            }
            BinaryDecoder decoder = TableJsonUtils.getDecoderFactory().binaryDecoder(data, offset, data.length - offset, null);
            SimpleAvroReader reader = new SimpleAvroReader(writerSchema, readerSchema, row);
            try {
                reader.read(decoder);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        this.fillInDefaultValues(row);
    }

    public boolean createImportRowFromKeyBytes(Row keyRecord, Key.BinaryKeyIterator keyIter, Iterator<String> pkIter) {
        if (this.parent != null && !this.parent.createImportRowFromKeyBytes(keyRecord, keyIter, pkIter)) {
            return false;
        }
        assert (!keyIter.atEndOfKey());
        this.setTableVersion(keyRecord);
        keyIter.next();
        String lastKeyField = this.primaryKey.get(this.primaryKey.size() - 1);
        while (pkIter.hasNext()) {
            if (keyIter.atEndOfKey()) {
                return false;
            }
            String field = pkIter.next();
            String val = keyIter.next();
            FieldDefImpl type = (FieldDefImpl)this.getField(field);
            try {
                keyRecord.put(field, (FieldValue)FieldDefImpl.createValueFromKeyString(val, type));
            }
            catch (Exception e) {
                return false;
            }
            if (!field.equals(lastKeyField)) continue;
            break;
        }
        return true;
    }

    private void getTableNameInternal(StringBuilder sb) {
        if (this.parent != null) {
            this.parent.getTableNameInternal(sb);
            sb.append(SEPARATOR);
        }
        sb.append(this.name);
    }

    public String generateAvroSchema(int versionToUse, boolean pretty) {
        boolean hasSchema = false;
        ObjectWriter writer = JsonUtils.createWriter(pretty);
        ObjectNode sch = JsonUtils.createObjectNode();
        sch.put("type", "record");
        String schemaName = this.getName();
        if (this.sysTable) {
            schemaName = schemaName.replace("$", "_");
        }
        sch.put("name", schemaName);
        ArrayNode array = sch.putArray("fields");
        TableVersionInfo versionInfo = this.getVersionInfo(versionToUse);
        FieldMap fmap = versionInfo.getFieldMap();
        for (int pos = 0; pos < fmap.size(); ++pos) {
            FieldMapEntry fme = fmap.getFieldMapEntry(pos);
            String fname = fme.getFieldName();
            if (versionInfo.isPrimKeyAtPos(pos)) continue;
            hasSchema = true;
            ObjectNode fnode = array.addObject();
            fnode.put("name", fname);
            fme.createAvroTypeAndDefault(fnode);
            if (fme.getFieldDef().getDescription() == null) continue;
            fnode.put("doc", fme.getFieldDef().getDescription());
        }
        if (!hasSchema) {
            return null;
        }
        try {
            return writer.writeValueAsString(sch);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("IO Error writing Avro schema string", ioe);
        }
    }

    public String toString() {
        return "Table[" + this.name + ", " + (this.parent == null ? "-" : this.parent.getFullName()) + ", " + this.indexes.size() + ", " + this.children.size() + ", " + (Object)((Object)this.status) + ", " + this.getTableVersion() + "]";
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getNamespaceName() {
        return TableMetadata.makeNamespaceName(this.namespace, this.getFullName());
    }

    private TableImpl findTable(String fullName) {
        String[] path = TableImpl.parseFullName(fullName);
        if (!path[0].equals(this.name)) {
            throw new IllegalArgumentException("No such table: " + fullName);
        }
        Table target = this;
        for (int i = 1; i < path.length; ++i) {
            if ((target = target.getChildTable(path[i])) != null) continue;
            throw new IllegalArgumentException("No such table: " + fullName);
        }
        return target;
    }

    private static boolean isAncestorOf(TableImpl start, TableImpl target) {
        TableImpl currentParent = start.parent;
        while (currentParent != null) {
            if (currentParent.id == target.id) {
                return true;
            }
            currentParent = currentParent.parent;
        }
        return false;
    }

    public static void validateIdentifier(String name, int maxLen, String type) {
        if (!name.matches(VALID_NAME_CHAR_REGEX)) {
            throw new IllegalArgumentException("Table, index and unquoted field names may contain only alphanumeric values plus the character \"_\": " + name);
        }
        if (!Character.isLetter(name.charAt(0)) || name.charAt(0) == '_') {
            throw new IllegalArgumentException(type + " must start with an alphabetic character");
        }
        if (name.length() > maxLen) {
            throw new IllegalArgumentException("Illegal name: " + name + ". " + type + " must be less than or equal to " + maxLen + " characters.");
        }
    }

    static void validateTableName(String tableName, boolean systemTable) {
        if (systemTable) {
            String[] nameComps = tableName.split("\\$");
            if (nameComps.length != 2 || !nameComps[0].equalsIgnoreCase(SYSTEM_TABLE_PREFIX_STRING)) {
                throw new IllegalCommandException("System table names must be of the format SYS$<name>");
            }
            tableName = nameComps[1];
        }
        TableImpl.validateIdentifier(tableName, 32, "Table names");
    }

    public static void validateNamespace(String namespace) {
        if (namespace == null) {
            return;
        }
        if (!namespace.matches(VALID_NAMESPACE_CHAR_REGEX)) {
            throw new IllegalArgumentException("Namespaces may contain only alphanumeric values plus the characters \"_\" and \".\" : " + namespace);
        }
        if (!Character.isLetter(namespace.charAt(0))) {
            throw new IllegalArgumentException("Namespaces must start with an alphabetic character");
        }
        if (namespace.length() > 128) {
            throw new IllegalArgumentException("Illegal namespace: " + namespace + ". Namespaces must be less than or equal to " + 128 + " characters.");
        }
    }

    static String[] parseFullName(String fullName) {
        if (fullName == null) {
            throw new IllegalArgumentException("null table name");
        }
        return fullName.split(SEPARATOR_REGEX);
    }

    @Override
    public Metadata.MetadataType getType() {
        return Metadata.MetadataType.TABLE;
    }

    @Override
    public int getSourceSeqNum() {
        return this.versions.size();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    private static void populateRecord(RecordValueImpl dest, RecordValue src) {
        assert (!(dest instanceof IndexKeyImpl));
        assert (!(src instanceof IndexKeyImpl));
        RecordDef srcDef = src.getDefinition();
        for (String fname : dest.getFieldNamesInternal()) {
            FieldValue v;
            if (!srcDef.contains(fname) || (v = src.get(fname)) == null) continue;
            dest.put(fname, v);
        }
        dest.validate();
    }

    void checkForDuplicateIndex(Index index) {
        for (Map.Entry<String, Index> entry : this.indexes.entrySet()) {
            Index existingIndex = entry.getValue();
            if (!index.getType().equals((Object)existingIndex.getType()) || !((IndexImpl)index).getIndexFields().equals(((IndexImpl)existingIndex).getIndexFields())) continue;
            throw new IllegalCommandException("Index is a duplicate of an existing index with another name.  Existing index name: " + entry.getKey() + ", new index name: " + index.getName());
        }
    }

    private void setTableVersion(Row row) {
        ((RowImpl)row).setTableVersion(this.getTableVersion());
    }

    public FieldDefImpl findTableField(String fieldPath) {
        return TableImpl.findTableField(this.getFieldMap(), fieldPath);
    }

    static FieldDefImpl findTableField(FieldMap fieldMap, String fieldPath) {
        return TableImpl.findTableField(new TablePath(fieldMap, fieldPath));
    }

    static FieldDefImpl findTableField(TablePath tablePath) {
        assert (!tablePath.isEmpty());
        FieldDefImpl def = tablePath.getFieldMap().getFieldDef(tablePath.getStep(0));
        if (def == null || !tablePath.isComplex()) {
            return def;
        }
        return def.findField(tablePath, 1);
    }

    @Override
    public ResourceOwner getOwner() {
        return this.owner;
    }

    @Override
    public TimeToLive getDefaultTTL() {
        return this.ttl;
    }

    static boolean compareTTL(TimeToLive ttl1, TimeToLive ttl2) {
        if (ttl1 == null) {
            return ttl2 == null;
        }
        if (ttl2 == null) {
            return false;
        }
        return ttl1.equals(ttl2);
    }

    public boolean isSystemTable() {
        return this.sysTable;
    }

    public boolean dontExport() {
        return this.isSystemTable();
    }

    private void writeAvro(Encoder encoder, FieldValueImpl fieldValue, FieldDef fieldDef) throws IOException {
        if (fieldDef != null && fieldDef.isJson()) {
            TableImpl.serializeJson(encoder, fieldValue);
            return;
        }
        switch (fieldValue.getType()) {
            case INTEGER: {
                encoder.writeInt(fieldValue.asInteger().get());
                break;
            }
            case LONG: {
                encoder.writeLong(fieldValue.asLong().get());
                break;
            }
            case DOUBLE: {
                encoder.writeDouble(fieldValue.asDouble().get());
                break;
            }
            case FLOAT: {
                encoder.writeFloat(fieldValue.asFloat().get());
                break;
            }
            case NUMBER: {
                encoder.writeBytes(((NumberValueImpl)fieldValue).getBytes());
                break;
            }
            case STRING: {
                encoder.writeString(fieldValue.asString().get());
                break;
            }
            case BOOLEAN: {
                encoder.writeBoolean(fieldValue.asBoolean().get());
                break;
            }
            case BINARY: {
                encoder.writeBytes(fieldValue.asBinary().get());
                break;
            }
            case FIXED_BINARY: {
                encoder.writeFixed(fieldValue.asFixedBinary().get());
                break;
            }
            case ENUM: {
                encoder.writeEnum(fieldValue.asEnum().getIndex());
                break;
            }
            case TIMESTAMP: {
                encoder.writeBytes(((TimestampValueImpl)fieldValue).getBytes());
                break;
            }
            case RECORD: {
                RecordValueImpl rval = (RecordValueImpl)fieldValue;
                this.writeAvroRecord(encoder, rval, false);
                break;
            }
            case MAP: {
                this.writeAvroMap(encoder, (MapValueImpl)fieldValue);
                break;
            }
            case ARRAY: {
                this.writeAvroArray(encoder, (ArrayValueImpl)fieldValue);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected type: " + fieldValue);
            }
        }
    }

    private void writeAvroRecord(Encoder encoder, RecordValueImpl record, boolean isRow) throws IOException {
        TableVersionInfo info = this.getVersionInfo();
        FieldMap fieldMap = record.getDefinition().getFieldMap();
        for (int pos = 0; pos < fieldMap.size(); ++pos) {
            FieldMapEntry fme = fieldMap.getFieldMapEntry(pos);
            if (isRow && info.isPrimKeyAtPos(pos)) continue;
            FieldValueImpl fv = record.get(pos);
            if (fv == null || fv.isNull()) {
                if (fv == null) {
                    fv = fme.getDefaultValue();
                }
                if (fv.isNull()) {
                    if (!fme.isNullable()) {
                        String fieldName = fme.getFieldName();
                        throw new IllegalCommandException("The field can not be null: " + fieldName);
                    }
                    encoder.writeIndex(fme.hasDefaultValue() ? 1 : 0);
                    encoder.writeNull();
                    continue;
                }
            }
            if (fme.isNullable()) {
                encoder.writeIndex(fme.hasDefaultValue() ? 0 : 1);
            }
            this.writeAvro(encoder, fv, fme.getFieldDef());
        }
    }

    private void writeAvroMap(Encoder encoder, MapValueImpl mapValue) throws IOException {
        FieldDefImpl elementDef = mapValue.getElementDef().isJson() ? mapValue.getElementDef() : null;
        encoder.writeMapStart();
        encoder.setItemCount(mapValue.size());
        for (Map.Entry<String, FieldValue> entry : mapValue.getFieldsInternal().entrySet()) {
            encoder.startItem();
            encoder.writeString(entry.getKey());
            this.writeAvro(encoder, (FieldValueImpl)entry.getValue(), elementDef);
        }
        encoder.writeMapEnd();
    }

    private void writeAvroArray(Encoder encoder, ArrayValueImpl arrayValue) throws IOException {
        FieldDefImpl elementDef = arrayValue.getElementDef().isJson() ? arrayValue.getElementDef() : null;
        encoder.writeArrayStart();
        encoder.setItemCount(arrayValue.size());
        for (FieldValue fv : arrayValue.getArrayInternal()) {
            encoder.startItem();
            this.writeAvro(encoder, (FieldValueImpl)fv, elementDef);
        }
        encoder.writeArrayEnd();
    }

    private static void serializeJson(Encoder encoder, FieldValueImpl fieldValue) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        FieldValueSerialization.writeFieldValue(fieldValue, true, out, (short)0);
        encoder.writeBytes(baos.toByteArray());
    }

    private static FieldValueImpl deserializeJson(Decoder in) throws IOException {
        byte[] bytes = in.readBytes(null).array();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        DataInputStream din = new DataInputStream(bais);
        FieldValueImpl newValue = (FieldValueImpl)FieldValueSerialization.readFieldValue(null, din, (short)0);
        return newValue;
    }

    private void createPrimKeyDef() {
        FieldMap pkFieldMap = null;
        FieldMap tableFieldMap = this.getFieldMap(this.version);
        pkFieldMap = new FieldMap();
        for (int i = 0; i < this.primaryKey.size(); ++i) {
            String pkFieldName = this.primaryKey.get(i);
            int pos = tableFieldMap.getFieldPos(pkFieldName);
            FieldMapEntry fme = tableFieldMap.getFieldMapEntry(pos).clone();
            fme.setNullable();
            pkFieldMap.put(fme);
        }
        this.primaryKeyDef = new RecordDefImpl(pkFieldMap, null);
    }

    public RecordDefImpl getPrimKeyDef() {
        return this.primaryKeyDef;
    }

    private void initializeVersionInfo(boolean validate) {
        this.tableVersionInfo = new ArrayList(this.versions.size());
        for (int i = 0; i < this.versions.size(); ++i) {
            FieldMap fm = this.versions.get(i);
            this.tableVersionInfo.add(new TableVersionInfo(i + 1, fm));
        }
        if (validate) {
            this.getSchema();
            this.createPrimKeyDef();
        }
    }

    public FieldDefImpl getPrimKeyColumnDef(int i) {
        return this.primaryKeyDef.getFieldDef(i);
    }

    public short getRequiredSerialVersion() {
        short requiredSerialVersion = 4;
        for (int i = 0; i < this.versions.size(); ++i) {
            FieldMap fieldMap = this.versions.get(i);
            requiredSerialVersion = (short)Math.max(requiredSerialVersion, fieldMap.getRequiredSerialVersion());
        }
        if (this.ttl != null) {
            requiredSerialVersion = (short)Math.max(requiredSerialVersion, 10);
        }
        if (this.namespace != null) {
            requiredSerialVersion = (short)Math.max(requiredSerialVersion, 14);
        }
        return requiredSerialVersion;
    }

    private class TableVersionInfo {
        private final int[] primKeyPositions;
        private final boolean[] isPrimKeyAtPos;
        private final int tableVersion;
        private final FieldMap fieldMap;
        private final RecordDefImpl recordDef;
        private Schema avroSchema;
        private boolean isKeyOnly;

        private TableVersionInfo(int tableVersion, FieldMap tableFieldMap) {
            this.tableVersion = tableVersion;
            this.fieldMap = tableFieldMap;
            this.primKeyPositions = new int[TableImpl.this.primaryKey.size()];
            this.isPrimKeyAtPos = new boolean[tableFieldMap.size()];
            this.recordDef = !this.fieldMap.isEmpty() ? new RecordDefImpl(TableImpl.this.getName(), this.fieldMap) : null;
            this.initPositionInfo();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Schema getAvroSchema() {
            if (this.avroSchema == null && !this.isKeyOnly) {
                TableVersionInfo tableVersionInfo = this;
                synchronized (tableVersionInfo) {
                    if (this.avroSchema == null) {
                        String schemaString = TableImpl.this.generateAvroSchema(this.tableVersion, false);
                        if (schemaString != null) {
                            this.avroSchema = new Schema.Parser().parse(schemaString);
                        } else {
                            this.isKeyOnly = true;
                        }
                    }
                }
            }
            return this.avroSchema;
        }

        private FieldMap getFieldMap() {
            return this.fieldMap;
        }

        private RecordDefImpl getRecordDef() {
            return this.recordDef;
        }

        private boolean isPrimKeyAtPos(int pos) {
            return this.isPrimKeyAtPos[pos];
        }

        private int[] getPrimKeyPositions() {
            return this.primKeyPositions;
        }

        private void initPositionInfo() {
            for (int i = 0; i < TableImpl.this.primaryKey.size(); ++i) {
                String pkFieldName = (String)TableImpl.this.primaryKey.get(i);
                int pos = this.fieldMap.getFieldPos(pkFieldName);
                assert (pos >= 0);
                this.primKeyPositions[i] = pos;
                this.isPrimKeyAtPos[pos] = true;
            }
        }
    }

    private static class SimpleAvroReader {
        private final RowImpl row;
        private final Schema expected;
        private final ResolvingDecoder resolver;
        final RecordDefImpl recordDef;

        private SimpleAvroReader(Schema writer, Schema reader, RowImpl row) {
            this.expected = reader;
            this.row = row;
            this.recordDef = row.getDefinition();
            this.resolver = writer == reader ? null : SimpleAvroReader.getResolvingDecoder(writer, reader);
        }

        private static ResolvingDecoder getResolvingDecoder(Schema actual, Schema expected) {
            try {
                return TableJsonUtils.getDecoderFactory().resolvingDecoder(Schema.applyAliases(actual, expected), expected, null);
            }
            catch (IOException iOException) {
                return null;
            }
        }

        private FieldValue read(Decoder in) throws IOException {
            if (this.resolver != null) {
                return this.readWithResolver(in);
            }
            this.readRecord(this.expected, this.recordDef, this.row, in);
            return this.row;
        }

        private FieldValue readWithResolver(Decoder in) throws IOException {
            this.resolver.configure(in);
            this.readRecord(this.expected, this.recordDef, this.row, this.resolver);
            this.resolver.drain();
            return this.row;
        }

        private FieldValue read(Schema schema, FieldDefImpl def, Decoder in) throws IOException {
            switch (schema.getType()) {
                case RECORD: {
                    return this.readRecord(schema, def, null, in);
                }
                case ENUM: {
                    return this.readEnum(def, in);
                }
                case ARRAY: {
                    return this.readAvroArray(schema, def, in);
                }
                case MAP: {
                    return this.readAvroMap(schema, def, in);
                }
                case UNION: {
                    Schema effectiveType = schema.getTypes().get(in.readIndex());
                    return this.read(effectiveType, def, in);
                }
                case FIXED: {
                    return this.readFixed(schema, def, in);
                }
                case STRING: {
                    return FieldDefImpl.stringDef.createString(in.readString());
                }
                case BYTES: {
                    if (def.isJson()) {
                        return TableImpl.deserializeJson(in);
                    }
                    if (def.isTimestamp()) {
                        return this.readTimestamp(def, in);
                    }
                    if (def.isNumber()) {
                        return this.readNumber(in);
                    }
                    return this.readBinary(in);
                }
                case INT: {
                    return FieldDefImpl.integerDef.createInteger(in.readInt());
                }
                case LONG: {
                    return FieldDefImpl.longDef.createLong(in.readLong());
                }
                case FLOAT: {
                    return FieldDefImpl.floatDef.createFloat(in.readFloat());
                }
                case DOUBLE: {
                    return FieldDefImpl.doubleDef.createDouble(in.readDouble());
                }
                case BOOLEAN: {
                    return FieldDefImpl.booleanDef.createBoolean(in.readBoolean());
                }
                case NULL: {
                    in.readNull();
                    return NullValueImpl.getInstance();
                }
            }
            throw new IllegalStateException("Unknown type: " + schema);
        }

        private RecordValueImpl readRecord(Schema schema, FieldDefImpl def, RecordValueImpl record, Decoder in) throws IOException {
            if (in instanceof ResolvingDecoder) {
                return this.resolveRecord(def, record, (ResolvingDecoder)in);
            }
            RecordDefImpl rdef = (RecordDefImpl)def;
            if (record == null) {
                record = rdef.createRecord();
            }
            for (Schema.Field f : schema.getFields()) {
                record.put(f.name(), this.read(f.schema(), rdef.getField(f.name()), in));
            }
            return record;
        }

        private RecordValueImpl resolveRecord(FieldDefImpl def, RecordValueImpl record, ResolvingDecoder in) throws IOException {
            RecordDefImpl rdef = (RecordDefImpl)def;
            if (record == null) {
                record = rdef.createRecord();
            }
            for (Schema.Field f : in.readFieldOrder()) {
                record.put(f.name(), this.read(f.schema(), rdef.getField(f.name()), in));
            }
            return record;
        }

        private MapValueImpl readAvroMap(Schema schema, FieldDefImpl def, Decoder in) throws IOException {
            MapDefImpl mdef = (MapDefImpl)def;
            MapValueImpl map = mdef.createMap();
            Schema valueType = schema.getValueType();
            long i = in.readMapStart();
            while (i != 0L) {
                for (long j = 0L; j < i; ++j) {
                    String key = in.readString();
                    map.put(key, this.read(valueType, mdef.getElement(), in));
                }
                i = in.mapNext();
            }
            return map;
        }

        private ArrayValueImpl readAvroArray(Schema schema, FieldDefImpl def, Decoder in) throws IOException {
            ArrayDefImpl adef = (ArrayDefImpl)def;
            ArrayValueImpl array = adef.createArray();
            Schema elementType = schema.getElementType();
            long i = in.readArrayStart();
            while (i != 0L) {
                for (long j = 0L; j < i; ++j) {
                    array.add(this.read(elementType, adef.getElement(), in));
                }
                i = in.arrayNext();
            }
            return array;
        }

        private FieldValue readEnum(FieldDefImpl def, Decoder in) throws IOException {
            EnumDefImpl edef = (EnumDefImpl)def;
            return edef.createEnum(in.readEnum());
        }

        private FieldValue readFixed(Schema schema, FieldDefImpl def, Decoder in) throws IOException {
            int size = schema.getFixedSize();
            byte[] bytes = new byte[size];
            in.readFixed(bytes, 0, size);
            return def.createFixedBinary(bytes);
        }

        private BinaryValueImpl readBinary(Decoder in) throws IOException {
            return FieldDefImpl.binaryDef.createBinary(in.readBytes(null).array());
        }

        private FieldValueImpl readTimestamp(FieldDefImpl def, Decoder in) throws IOException {
            return ((TimestampDefImpl)def).createTimestamp(in.readBytes(null).array());
        }

        private FieldValueImpl readNumber(Decoder in) throws IOException {
            return FieldDefImpl.numberDef.createNumber(in.readBytes(null).array());
        }
    }

    public static enum TableStatus {
        DELETING{

            @Override
            public boolean isDeleting() {
                return true;
            }
        }
        ,
        READY{

            @Override
            public boolean isReady() {
                return true;
            }
        };


        public boolean isDeleting() {
            return false;
        }

        public boolean isReady() {
            return false;
        }
    }
}

