/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import java.io.IOException;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.FixedBinaryValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.api.table.TableJsonUtils;
import oracle.kv.impl.util.JsonUtils;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FixedBinaryDef;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.node.TextNode;

@Persistent(version=1)
public class FixedBinaryDefImpl
extends FieldDefImpl
implements FixedBinaryDef {
    private static final long serialVersionUID = 1L;
    private String name;
    private final int size;

    FixedBinaryDefImpl(int size, String description) {
        super(FieldDef.Type.FIXED_BINARY, description);
        this.size = size;
        this.validate();
    }

    FixedBinaryDefImpl(String name, int size, String description) {
        this(size, description);
        if (name == null) {
            throw new IllegalArgumentException("FixedBinaryDef requires a name");
        }
        this.name = name;
    }

    FixedBinaryDefImpl(String name, int size) {
        this(name, size, null);
    }

    private FixedBinaryDefImpl() {
        super(FieldDef.Type.BINARY);
        this.size = 0;
        this.name = null;
    }

    private FixedBinaryDefImpl(FixedBinaryDefImpl impl) {
        super(impl);
        this.name = impl.name;
        this.size = impl.size;
    }

    @Override
    public FixedBinaryDefImpl clone() {
        return new FixedBinaryDefImpl(this);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.size + this.name.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof FixedBinaryDefImpl) {
            FixedBinaryDefImpl otherDef = (FixedBinaryDefImpl)other;
            return this.size == otherDef.size;
        }
        return false;
    }

    @Override
    public FixedBinaryDef asFixedBinary() {
        return this;
    }

    @Override
    public FixedBinaryValueImpl createFixedBinary(byte[] value) {
        this.validateValue(value);
        return new FixedBinaryValueImpl(value, this);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public FixedBinaryValueImpl fromString(String base64) {
        TextNode n = new TextNode(base64);
        try {
            return this.createFixedBinary(n.getBinaryValue());
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Cannot create binary from string: " + base64, ioe);
        }
    }

    @Override
    public boolean isSubtype(FieldDefImpl superType) {
        if (superType.isFixedBinary()) {
            return this.equals(superType);
        }
        return superType.isBinary() || superType.isAny() || superType.isAnyAtomic();
    }

    @Override
    void toJson(ObjectNode node) {
        super.toJson(node);
        node.put("size", this.size);
        node.put("name", this.name);
    }

    @Override
    public JsonNode mapTypeToAvro(ObjectNode node) {
        if (node == null) {
            node = JsonUtils.createObjectNode();
        }
        node.put("type", "fixed");
        node.put("name", this.name);
        node.put("size", this.size);
        return node;
    }

    @Override
    FieldValueImpl createValue(JsonNode node) {
        if (node == null || node.isNull()) {
            return NullValueImpl.getInstance();
        }
        if (!node.isBinary() && !node.isTextual()) {
            throw new IllegalArgumentException("Default value for type FIXED_BINARY is not binary or text");
        }
        try {
            byte[] bytes;
            if (node.isBinary()) {
                bytes = node.getBinaryValue();
            } else {
                assert (node.isTextual());
                String str = node.getTextValue();
                bytes = TableJsonUtils.decodeBase64(str);
            }
            if (bytes.length != this.size) {
                throw new IllegalArgumentException("Illegal size for FIXED_BINARY: " + bytes.length + ", must be " + this.size);
            }
            return this.createFixedBinary(bytes);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("IOException creating fixed binary value: " + ioe, ioe);
        }
    }

    @Override
    public short getRequiredSerialVersion() {
        return 4;
    }

    public void setName(String n) {
        this.name = n;
        if (this.name == null || this.name.isEmpty()) {
            throw new IllegalArgumentException("Fixed binary types require a name");
        }
    }

    private void validate() {
        if (this.size <= 0) {
            throw new IllegalArgumentException("FixedBinaryDef size limit must be a positive integer");
        }
    }

    private void validateValue(byte[] value) {
        if (value.length != this.size) {
            throw new IllegalArgumentException("Invalid length for FixedBinary array, it must be " + this.size + ", and it is " + value.length);
        }
    }
}

