/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.kv.impl.api.table.FieldComparator;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldMapEntry;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.TablePath;
import oracle.kv.table.FieldDef;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

@Persistent(version=2)
public class FieldMap
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    @Deprecated
    private Map<String, FieldMapEntry> fields;
    @Deprecated
    private List<String> fieldOrder;
    private transient List<FieldMapEntry> fieldProperties;
    private transient List<String> fieldNames;
    private transient Map<String, Integer> fieldPositions;

    public FieldMap() {
        this.fieldNames = new ArrayList<String>();
        this.fieldProperties = new ArrayList<FieldMapEntry>();
        this.fieldPositions = new TreeMap<String, Integer>(FieldComparator.instance);
        this.fields = new TreeMap<String, FieldMapEntry>(FieldComparator.instance);
        this.fieldOrder = this.fieldNames;
    }

    private FieldMap(FieldMap other) {
        assert (other.fieldPositions != null);
        assert (other.fieldProperties != null);
        int numFields = other.fieldNames.size();
        this.fieldProperties = new ArrayList<FieldMapEntry>(numFields);
        for (FieldMapEntry fme : other.fieldProperties) {
            this.fieldProperties.add(fme.clone());
        }
        this.fieldPositions = new TreeMap<String, Integer>(FieldComparator.instance);
        this.fieldPositions.putAll(other.fieldPositions);
        this.fieldNames = new ArrayList<String>(other.fieldNames);
        this.fields = new TreeMap<String, FieldMapEntry>(FieldComparator.instance);
        this.fieldOrder = this.fieldNames;
    }

    public FieldMap clone() {
        return new FieldMap(this);
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        try {
            int numFields = this.fieldProperties.size();
            for (int i = 0; i < numFields; ++i) {
                FieldMapEntry fme = this.fieldProperties.get(i);
                this.fields.put(fme.getFieldName(), fme);
            }
            out.defaultWriteObject();
            this.fields.clear();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            in.defaultReadObject();
            this.convertToNewFormat(false);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    void convertToNewFormat(boolean forDPL) {
        this.fieldNames = this.fieldOrder;
        this.fieldProperties = new ArrayList<FieldMapEntry>(this.fieldOrder.size());
        this.fieldPositions = new TreeMap<String, Integer>(FieldComparator.instance);
        for (String fname : this.fieldNames) {
            FieldMapEntry oldFME = this.fields.get(fname);
            FieldValueImpl defVal = oldFME.getDefaultValueInternal();
            if (forDPL && defVal != null && defVal.isRecord()) {
                ((RecordValueImpl)defVal).convertToNewFormat();
            }
            FieldMapEntry newFME = new FieldMapEntry(fname, oldFME.getFieldDef(), oldFME.isNullable(), defVal);
            this.fieldProperties.add(newFME);
            this.fieldPositions.put(fname, this.fieldProperties.size() - 1);
        }
        this.fields.clear();
    }

    Map<String, Integer> getFieldPositions() {
        return this.fieldPositions;
    }

    List<FieldMapEntry> getFieldProperties() {
        return this.fieldProperties;
    }

    List<String> getFieldNames() {
        return this.fieldNames;
    }

    FieldMapEntry getFieldMapEntry(String name) {
        Integer pos = this.fieldPositions.get(name);
        return pos != null ? this.fieldProperties.get(pos) : null;
    }

    FieldMapEntry getFieldMapEntry(int pos) {
        return this.fieldProperties.get(pos);
    }

    String getFieldName(int pos) {
        return this.fieldNames.get(pos);
    }

    boolean exists(String name) {
        return this.fieldPositions.containsKey(name);
    }

    int getFieldPos(String name) {
        Integer pos = this.fieldPositions.get(name);
        if (pos == null) {
            throw new IllegalArgumentException("There is no field with name " + name);
        }
        return pos;
    }

    FieldDefImpl getFieldDef(int pos) {
        return this.fieldProperties.get(pos).getFieldDef();
    }

    FieldDefImpl getFieldDef(String name) {
        FieldMapEntry fme = this.getFieldMapEntry(name);
        return fme != null ? fme.getFieldDef() : null;
    }

    FieldValueImpl getDefaultValue(int pos) {
        return this.fieldProperties.get(pos).getDefaultValue();
    }

    boolean isNullable(int pos) {
        return this.fieldProperties.get(pos).isNullable();
    }

    public void reverseFieldOrder() {
        Collections.reverse(this.fieldNames);
        Collections.reverse(this.fieldProperties);
        for (int i = 0; i < this.fieldProperties.size(); ++i) {
            this.fieldPositions.put(this.fieldProperties.get(i).getFieldName(), i);
        }
    }

    void put(FieldMapEntry fme) {
        if (this.fieldPositions.put(fme.getFieldName(), this.fieldPositions.size()) != null) {
            throw new IllegalArgumentException("Field " + fme.getFieldName() + " exists already");
        }
        this.fieldProperties.add(fme);
        this.fieldNames.add(fme.getFieldName());
    }

    public void put(String name, FieldDefImpl type, boolean nullable, FieldValueImpl defaultValue) {
        this.put(new FieldMapEntry(name, type, nullable, defaultValue));
    }

    boolean remove(String name) {
        Integer pos = this.fieldPositions.remove(name);
        if (pos == null) {
            return false;
        }
        FieldMapEntry fme = this.fieldProperties.remove(pos);
        assert (fme != null);
        this.fieldNames.remove(pos);
        for (Map.Entry<String, Integer> entry : this.fieldPositions.entrySet()) {
            String fname = entry.getKey();
            Integer fpos = entry.getValue();
            if (fpos <= pos) continue;
            this.fieldPositions.put(fname, fpos - 1);
        }
        return true;
    }

    public boolean isEmpty() {
        return this.fieldProperties.isEmpty();
    }

    int size() {
        return this.fieldProperties.size();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FieldMap)) {
            return false;
        }
        FieldMap other = (FieldMap)obj;
        if (this.fieldProperties.size() != other.fieldProperties.size()) {
            return false;
        }
        for (int i = 0; i < this.fieldProperties.size(); ++i) {
            FieldMapEntry fme2;
            FieldMapEntry fme1 = this.fieldProperties.get(i);
            if (fme1.equals(fme2 = other.fieldProperties.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isPrecise() {
        for (FieldMapEntry fme : this.fieldProperties) {
            if (fme.isPrecise()) continue;
            return false;
        }
        return true;
    }

    public boolean isSubtype(FieldMap superType) {
        if (this.fieldProperties.size() != superType.fieldProperties.size()) {
            return false;
        }
        for (int i = 0; i < this.fieldProperties.size(); ++i) {
            FieldMapEntry fme2;
            FieldMapEntry fme1 = this.fieldProperties.get(i);
            if (fme1.isSubtype(fme2 = superType.fieldProperties.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int code = this.fieldProperties.size();
        for (FieldMapEntry fme : this.fieldProperties) {
            code += fme.hashCode();
        }
        return code;
    }

    void putFields(ObjectNode node) {
        ArrayNode array = node.putArray("fields");
        for (FieldMapEntry fme : this.fieldProperties) {
            ObjectNode fnode = array.addObject();
            fnode.put("name", fme.getFieldName());
            fme.toJson(fnode);
        }
    }

    FieldMapEntry getFieldMapEntry(TablePath tablePath) {
        FieldMap containingMap = this.findContainingMap(tablePath);
        String lastStep = tablePath.getLastStep();
        return containingMap.getFieldMapEntry(lastStep);
    }

    public FieldMap findContainingMap(TablePath tablePath) {
        int stepIndex;
        int numSteps = tablePath.numSteps();
        if (numSteps == 0) {
            throw new IllegalArgumentException(" Field path is empty.");
        }
        if (tablePath.getLastStep() == "[]" || tablePath.getLastStep().equalsIgnoreCase("values()")) {
            throw new IllegalArgumentException("Path " + tablePath.getPathName() + " does not lead to a record field");
        }
        String currentStep = tablePath.getStep(0);
        FieldDef def = this.getFieldDef(currentStep);
        if (def == null) {
            throw new IllegalArgumentException("Field \"" + currentStep + "\" in path " + currentStep + " does not exist.");
        }
        if (numSteps == 1) {
            return this;
        }
        for (stepIndex = 1; stepIndex < numSteps - 1; ++stepIndex) {
            currentStep = tablePath.getStep(stepIndex);
            if (currentStep == "[]") {
                if (def.isArray()) {
                    def = def.asArray().getElement();
                    assert (def != null);
                    continue;
                }
                throw new IllegalArgumentException("Step \"[]\" in path " + tablePath.getPathName() + " does not have an array as input");
            }
            if (currentStep.equalsIgnoreCase("values()")) {
                if (def.isMap()) {
                    def = def.asMap().getElement();
                    assert (def != null);
                    continue;
                }
                throw new IllegalArgumentException("Step \".values()\" in path " + tablePath.getPathName() + " does not have a map as input");
            }
            if (def.isRecord()) {
                if ((def = def.asRecord().getFieldDef(currentStep)) != null) continue;
                throw new IllegalArgumentException("Field \"" + currentStep + "\" in path " + tablePath.getPathName() + " does not exist.");
            }
            if (def.isAnyRecord()) {
                throw new IllegalStateException("AnyRecord cannot be used in table schema.");
            }
            throw new IllegalArgumentException("Step \"" + currentStep + "\" in path " + tablePath.getPathName() + " does not have a record as input");
        }
        currentStep = tablePath.getStep(stepIndex);
        if (!def.isRecord()) {
            throw new IllegalArgumentException("Step \"" + currentStep + "\" in path " + tablePath.getPathName() + " does not have a record as input");
        }
        if (def.asRecord().getFieldDef(currentStep) == null) {
            throw new IllegalArgumentException("Field \"" + currentStep + "\" in path " + tablePath.getPathName() + " does not exist.");
        }
        return ((RecordDefImpl)def).getFieldMap();
    }

    public void removeField(List<String> stepsList) {
        TablePath tablePath = new TablePath(this, stepsList);
        this.removeField(tablePath);
    }

    void removeField(TablePath tablePath) {
        FieldMap containingMap = this.findContainingMap(tablePath);
        containingMap.remove(tablePath.getLastStep());
    }

    public short getRequiredSerialVersion() {
        short requiredSerialVersion = 4;
        for (int i = this.size() - 1; i >= 0; --i) {
            requiredSerialVersion = (short)Math.max(requiredSerialVersion, this.getFieldDef(i).getRequiredSerialVersion());
        }
        return requiredSerialVersion;
    }
}

