/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import java.util.Arrays;
import javax.xml.bind.DatatypeConverter;
import oracle.kv.impl.api.table.BinaryDefImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.table.BinaryValue;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.BinaryNode;

@Persistent(version=1)
public class BinaryValueImpl
extends FieldValueImpl
implements BinaryValue {
    private static final long serialVersionUID = 1L;
    private final byte[] value;

    BinaryValueImpl(byte[] value) {
        if (value == null) {
            throw new IllegalArgumentException("Binary values cannot be null");
        }
        this.value = value;
    }

    private BinaryValueImpl() {
        this.value = null;
    }

    @Override
    public BinaryValueImpl clone() {
        return new BinaryValueImpl(this.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public boolean equals(Object other) {
        if (other instanceof BinaryValueImpl) {
            return Arrays.equals(this.value, ((BinaryValueImpl)other).get());
        }
        return false;
    }

    @Override
    public int compareTo(FieldValue otherValue) {
        return this.equals(otherValue) ? 0 : -1;
    }

    @Override
    public String toString() {
        return DatatypeConverter.printBase64Binary((byte[])this.value);
    }

    @Override
    public FieldDef.Type getType() {
        return FieldDef.Type.BINARY;
    }

    @Override
    public BinaryDefImpl getDefinition() {
        return FieldDefImpl.binaryDef;
    }

    @Override
    public BinaryValue asBinary() {
        return this;
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public byte[] get() {
        return this.value;
    }

    @Override
    public JsonNode toJsonNode() {
        return new BinaryNode(this.value);
    }

    @Override
    public void toStringBuilder(StringBuilder sb) {
        sb.append("\"");
        sb.append(DatatypeConverter.printBase64Binary((byte[])this.value));
        sb.append("\"");
    }

    @Override
    public byte[] getBytes() {
        return this.value;
    }

    public static BinaryValueImpl create(byte[] value) {
        return new BinaryValueImpl(value);
    }
}

