/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import oracle.kv.impl.api.table.ArrayDefImpl;
import oracle.kv.impl.api.table.ComplexValueImpl;
import oracle.kv.impl.api.table.EnumDefImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.JsonDefImpl;
import oracle.kv.impl.api.table.MapValueImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.TableJsonUtils;
import oracle.kv.table.ArrayDef;
import oracle.kv.table.ArrayValue;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.MapValue;
import oracle.kv.table.RecordValue;
import org.codehaus.jackson.JsonLocation;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.JsonNodeFactory;

@Persistent(version=1)
public class ArrayValueImpl
extends ComplexValueImpl
implements ArrayValue {
    private static final long serialVersionUID = 1L;
    private final ArrayList<FieldValue> array;
    private FieldDefImpl homogeneousType;

    ArrayValueImpl(ArrayDef def) {
        super(def);
        this.array = new ArrayList();
    }

    private ArrayValueImpl() {
        super(null);
        this.array = null;
    }

    @Override
    public ArrayValueImpl clone() {
        ArrayValueImpl newArray = new ArrayValueImpl(this.getDefinition());
        for (FieldValue val : this.array) {
            newArray.add(val.clone());
        }
        newArray.homogeneousType = this.homogeneousType;
        return newArray;
    }

    public int hashCode() {
        int code = this.size();
        for (FieldValue val : this.array) {
            code += val.hashCode();
        }
        return code;
    }

    public boolean equals(Object other) {
        if (other instanceof ArrayValueImpl) {
            ArrayValueImpl otherValue = (ArrayValueImpl)other;
            if (this == otherValue) {
                return true;
            }
            if (this.size() == otherValue.size() && this.getDefinition().equals(otherValue.getDefinition()) && (this.homogeneousType == null || this.homogeneousType.equals(otherValue.getHomogeneousType()))) {
                for (int i = 0; i < this.size(); ++i) {
                    if (this.get(i).equals(otherValue.get(i))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public int compareTo(FieldValue other) {
        if (other instanceof ArrayValueImpl) {
            ArrayValueImpl otherImpl = (ArrayValueImpl)other;
            if (!this.getDefinition().equals(otherImpl.getDefinition())) {
                throw new IllegalArgumentException("Cannot compare ArrayValues with different definitions");
            }
            for (int i = 0; i < this.size(); ++i) {
                FieldValueImpl val = this.get(i);
                if (otherImpl.size() < i + 1) {
                    return 1;
                }
                int ret = val.compareTo(otherImpl.get(i));
                if (ret == 0) continue;
                return ret;
            }
            return 0;
        }
        throw new ClassCastException("Object is not an ArrayValue");
    }

    @Override
    public FieldDef.Type getType() {
        return FieldDef.Type.ARRAY;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public ArrayValue asArray() {
        return this;
    }

    @Override
    public ArrayDefImpl getDefinition() {
        return (ArrayDefImpl)this.fieldDef;
    }

    @Override
    public FieldValueImpl get(int index) {
        return (FieldValueImpl)this.array.get(index);
    }

    @Override
    public int size() {
        return this.array.size();
    }

    @Override
    public List<FieldValue> toList() {
        return Collections.unmodifiableList(this.array);
    }

    @Override
    public ArrayValue add(FieldValue value) {
        value = this.validate(value, this.getElementDef());
        this.array.add(value);
        this.trackHomogeneousType(value);
        return this;
    }

    @Override
    public ArrayValue add(int index, FieldValue value) {
        value = this.validate(value, this.getElementDef());
        this.array.add(index, value);
        this.trackHomogeneousType(value);
        return this;
    }

    @Override
    public ArrayValue set(int index, FieldValue value) {
        value = this.validate(value, this.getElementDef());
        this.array.set(index, value);
        this.trackHomogeneousType(value);
        return this;
    }

    @Override
    public ArrayValue add(int value) {
        this.addScalar(this.getElementDef().createInteger(value));
        return this;
    }

    @Override
    public ArrayValue add(int[] values) {
        FieldDefImpl edef = this.getElementDef();
        for (int i : values) {
            this.addScalar(edef.createInteger(i));
        }
        return this;
    }

    @Override
    public ArrayValue add(int index, int value) {
        this.addScalar(index, this.getElementDef().createInteger(value));
        return this;
    }

    @Override
    public ArrayValue set(int index, int value) {
        this.setScalar(index, this.getElementDef().createInteger(value));
        return this;
    }

    @Override
    public ArrayValue add(long value) {
        this.addScalar(this.getElementDef().createLong(value));
        return this;
    }

    @Override
    public ArrayValue add(long[] values) {
        FieldDefImpl edef = this.getElementDef();
        for (long l : values) {
            this.addScalar(edef.createLong(l));
        }
        return this;
    }

    @Override
    public ArrayValue add(int index, long value) {
        this.addScalar(index, this.getElementDef().createLong(value));
        return this;
    }

    @Override
    public ArrayValue set(int index, long value) {
        this.setScalar(index, this.getElementDef().createLong(value));
        return this;
    }

    @Override
    public ArrayValue add(String value) {
        this.addScalar(this.getElementDef().createString(value));
        return this;
    }

    @Override
    public ArrayValue add(String[] values) {
        FieldDefImpl edef = this.getElementDef();
        for (String s : values) {
            this.addScalar(edef.createString(s));
        }
        return this;
    }

    @Override
    public ArrayValue add(int index, String value) {
        this.addScalar(index, this.getElementDef().createString(value));
        return this;
    }

    @Override
    public ArrayValue set(int index, String value) {
        this.setScalar(index, this.getElementDef().createString(value));
        return this;
    }

    @Override
    public ArrayValue add(double value) {
        this.addScalar(this.getElementDef().createDouble(value));
        return this;
    }

    @Override
    public ArrayValue add(double[] values) {
        FieldDefImpl edef = this.getElementDef();
        for (double d : values) {
            this.addScalar(edef.createDouble(d));
        }
        return this;
    }

    @Override
    public ArrayValue add(int index, double value) {
        this.addScalar(index, this.getElementDef().createDouble(value));
        return this;
    }

    @Override
    public ArrayValue set(int index, double value) {
        this.setScalar(index, this.getElementDef().createDouble(value));
        return this;
    }

    @Override
    public ArrayValue add(float value) {
        this.addScalar(this.getElementDef().createFloat(value));
        return this;
    }

    @Override
    public ArrayValue add(float[] values) {
        FieldDefImpl edef = this.getElementDef();
        for (float d : values) {
            this.addScalar(edef.createFloat(d));
        }
        return this;
    }

    @Override
    public ArrayValue add(int index, float value) {
        this.addScalar(index, this.getElementDef().createFloat(value));
        return this;
    }

    @Override
    public ArrayValue set(int index, float value) {
        this.setScalar(index, this.getElementDef().createFloat(value));
        return this;
    }

    @Override
    public ArrayValue addNumber(int value) {
        this.addScalar(this.getElementDef().createNumber(value));
        return this;
    }

    @Override
    public ArrayValue addNumber(int[] values) {
        FieldDefImpl def = this.getElementDef();
        for (int val : values) {
            this.addScalar(def.createNumber(val));
        }
        return this;
    }

    @Override
    public ArrayValue addNumber(int index, int value) {
        this.addScalar(index, this.getElementDef().createNumber(value));
        return this;
    }

    @Override
    public ArrayValue setNumber(int index, int value) {
        this.setScalar(index, this.getElementDef().createNumber(value));
        return this;
    }

    @Override
    public ArrayValue addNumber(long value) {
        this.addScalar(this.getElementDef().createNumber(value));
        return this;
    }

    @Override
    public ArrayValue addNumber(long[] values) {
        FieldDefImpl def = this.getElementDef();
        for (long val : values) {
            this.addScalar(def.createNumber(val));
        }
        return this;
    }

    @Override
    public ArrayValue addNumber(int index, long value) {
        this.addScalar(index, this.getElementDef().createNumber(value));
        return this;
    }

    @Override
    public ArrayValue setNumber(int index, long value) {
        this.setScalar(index, this.getElementDef().createNumber(value));
        return this;
    }

    @Override
    public ArrayValue addNumber(float value) {
        this.addScalar(this.getElementDef().createNumber(value));
        return this;
    }

    @Override
    public ArrayValue addNumber(float[] values) {
        FieldDefImpl def = this.getElementDef();
        for (float val : values) {
            this.addScalar(def.createNumber(val));
        }
        return this;
    }

    @Override
    public ArrayValue addNumber(int index, float value) {
        this.addScalar(index, this.getElementDef().createNumber(value));
        return this;
    }

    @Override
    public ArrayValue setNumber(int index, float value) {
        this.setScalar(index, this.getElementDef().createNumber(value));
        return this;
    }

    @Override
    public ArrayValue addNumber(double value) {
        this.addScalar(this.getElementDef().createNumber(value));
        return this;
    }

    @Override
    public ArrayValue addNumber(double[] values) {
        FieldDefImpl def = this.getElementDef();
        for (double val : values) {
            this.addScalar(def.createNumber(val));
        }
        return this;
    }

    @Override
    public ArrayValue addNumber(int index, double value) {
        this.addScalar(index, this.getElementDef().createNumber(value));
        return this;
    }

    @Override
    public ArrayValue setNumber(int index, double value) {
        this.setScalar(index, this.getElementDef().createNumber(value));
        return this;
    }

    @Override
    public ArrayValue addNumber(BigDecimal value) {
        this.addScalar(this.getElementDef().createNumber(value));
        return this;
    }

    @Override
    public ArrayValue addNumber(BigDecimal[] values) {
        FieldDefImpl def = this.getElementDef();
        for (BigDecimal bd : values) {
            this.addScalar(def.createNumber(bd));
        }
        return this;
    }

    @Override
    public ArrayValue addNumber(int index, BigDecimal value) {
        this.addScalar(index, this.getElementDef().createNumber(value));
        return this;
    }

    @Override
    public ArrayValue setNumber(int index, BigDecimal value) {
        this.setScalar(index, this.getElementDef().createNumber(value));
        return this;
    }

    @Override
    public ArrayValue add(boolean value) {
        this.addScalar(this.getElementDef().createBoolean(value));
        return this;
    }

    @Override
    public ArrayValue add(boolean[] values) {
        FieldDefImpl edef = this.getElementDef();
        for (boolean b : values) {
            this.addScalar(edef.createBoolean(b));
        }
        return this;
    }

    @Override
    public ArrayValue add(int index, boolean value) {
        this.addScalar(index, this.getElementDef().createBoolean(value));
        return this;
    }

    @Override
    public ArrayValue set(int index, boolean value) {
        this.setScalar(index, this.getElementDef().createBoolean(value));
        return this;
    }

    @Override
    public ArrayValue add(byte[] value) {
        this.addScalar(this.getElementDef().createBinary(value));
        return this;
    }

    @Override
    public ArrayValue add(byte[][] values) {
        FieldDefImpl edef = this.getElementDef();
        for (byte[] b : values) {
            this.addScalar(edef.createBinary(b));
        }
        return this;
    }

    @Override
    public ArrayValue add(int index, byte[] value) {
        this.addScalar(index, this.getElementDef().createBinary(value));
        return this;
    }

    @Override
    public ArrayValue set(int index, byte[] value) {
        this.setScalar(index, this.getElementDef().createBinary(value));
        return this;
    }

    @Override
    public ArrayValue addFixed(byte[] value) {
        this.addScalar(this.getElementDef().createFixedBinary(value));
        return this;
    }

    @Override
    public ArrayValue addFixed(byte[][] values) {
        FieldDefImpl edef = this.getElementDef();
        for (byte[] b : values) {
            this.addScalar(edef.createFixedBinary(b));
        }
        return this;
    }

    @Override
    public ArrayValue addFixed(int index, byte[] value) {
        this.addScalar(index, this.getElementDef().createFixedBinary(value));
        return this;
    }

    @Override
    public ArrayValue setFixed(int index, byte[] value) {
        this.setScalar(index, this.getElementDef().createFixedBinary(value));
        return this;
    }

    @Override
    public ArrayValue addEnum(String value) {
        this.addScalar(this.getElementDef().createEnum(value));
        return this;
    }

    @Override
    public ArrayValue addEnum(String[] values) {
        FieldDefImpl edef = this.getElementDef();
        for (String s : values) {
            this.addScalar(edef.createEnum(s));
        }
        return this;
    }

    @Override
    public ArrayValue addEnum(int index, String value) {
        this.addScalar(index, this.getElementDef().createEnum(value));
        return this;
    }

    @Override
    public ArrayValue setEnum(int index, String value) {
        this.setScalar(index, this.getElementDef().createEnum(value));
        return this;
    }

    @Override
    public ArrayValue add(Timestamp value) {
        this.addScalar(this.getElementDef().createTimestamp(value));
        return this;
    }

    @Override
    public ArrayValue add(Timestamp[] values) {
        FieldDefImpl def = this.getElementDef();
        for (Timestamp v : values) {
            this.addScalar(def.createTimestamp(v));
        }
        return this;
    }

    @Override
    public ArrayValue add(int index, Timestamp value) {
        this.addScalar(index, this.getElementDef().createTimestamp(value));
        return this;
    }

    @Override
    public ArrayValue set(int index, Timestamp value) {
        this.addScalar(index, this.getElementDef().createTimestamp(value));
        return this;
    }

    @Override
    public ArrayValue addJsonNull() {
        this.addScalar(this.getElementDef().createJsonNull());
        return this;
    }

    @Override
    public ArrayValue addJsonNull(int index) {
        this.addScalar(index, this.getElementDef().createJsonNull());
        return this;
    }

    @Override
    public ArrayValue setJsonNull(int index) {
        this.setScalar(index, this.getElementDef().createJsonNull());
        return this;
    }

    @Override
    public RecordValue setRecord(int index) {
        RecordValue val = this.getElementDef().createRecord();
        this.array.set(index, val);
        this.clearHomogeneousType();
        return val;
    }

    @Override
    public RecordValueImpl addRecord() {
        RecordValue val = this.getElementDef().createRecord();
        this.array.add(val);
        this.clearHomogeneousType();
        return (RecordValueImpl)val;
    }

    @Override
    public RecordValue addRecord(int index) {
        RecordValue val = this.getElementDef().createRecord();
        this.array.add(index, val);
        this.clearHomogeneousType();
        return val;
    }

    @Override
    public MapValue setMap(int index) {
        MapValue val = this.getElementDef().createMap();
        this.array.set(index, val);
        this.clearHomogeneousType();
        return val;
    }

    @Override
    public MapValueImpl addMap() {
        MapValue val = this.getElementDef().createMap();
        this.array.add(val);
        this.clearHomogeneousType();
        return (MapValueImpl)val;
    }

    @Override
    public MapValue addMap(int index) {
        MapValue val = this.getElementDef().createMap();
        this.array.add(index, val);
        this.clearHomogeneousType();
        return val;
    }

    @Override
    public ArrayValue setArray(int index) {
        ArrayValue val = this.getElementDef().createArray();
        this.array.set(index, val);
        this.clearHomogeneousType();
        return val;
    }

    @Override
    public ArrayValueImpl addArray() {
        ArrayValue val = this.getElementDef().createArray();
        this.array.add(val);
        this.clearHomogeneousType();
        return (ArrayValueImpl)val;
    }

    @Override
    public ArrayValue addArray(int index) {
        ArrayValue val = this.getElementDef().createArray();
        this.array.add(index, val);
        this.clearHomogeneousType();
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayValueImpl addJson(String jsonInput) {
        StringReader reader = new StringReader(jsonInput);
        try {
            ArrayValueImpl arrayValueImpl = this.addJson(reader);
            return arrayValueImpl;
        }
        finally {
            try {
                ((Reader)reader).close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public ArrayValueImpl addJson(Reader jsonReader) {
        this.add(JsonDefImpl.createFromReader(jsonReader));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayValueImpl addJson(int index, String jsonInput) {
        StringReader reader = new StringReader(jsonInput);
        try {
            ArrayValueImpl arrayValueImpl = this.addJson(index, reader);
            return arrayValueImpl;
        }
        finally {
            try {
                ((Reader)reader).close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public ArrayValueImpl addJson(int index, Reader jsonReader) {
        this.add(index, JsonDefImpl.createFromReader(jsonReader));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayValueImpl setJson(int index, String jsonInput) {
        StringReader reader = new StringReader(jsonInput);
        try {
            ArrayValueImpl arrayValueImpl = this.setJson(index, reader);
            return arrayValueImpl;
        }
        finally {
            try {
                ((Reader)reader).close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public ArrayValueImpl setJson(int index, Reader jsonReader) {
        this.set(index, JsonDefImpl.createFromReader(jsonReader));
        return this;
    }

    @Override
    public void addJsonFields(JsonParser jp, String fieldName, boolean exact, boolean addMissingFields) {
        try {
            FieldDefImpl element = this.getElementDef();
            JsonToken t = jp.getCurrentToken();
            JsonLocation location = jp.getCurrentLocation();
            if (t != JsonToken.START_ARRAY) {
                ArrayValueImpl.jsonParseException("Expected [ token to start array, instead found " + (Object)((Object)t), location);
            }
            while ((t = jp.nextToken()) != JsonToken.END_ARRAY) {
                if (t == null || t == JsonToken.END_OBJECT) {
                    ArrayValueImpl.jsonParseException("Did not find end of array", location);
                }
                if (jp.getCurrentToken() == JsonToken.VALUE_NULL && !element.isJson()) {
                    throw new IllegalArgumentException("Invalid null value in JSON input for array");
                }
                switch (element.getType()) {
                    case INTEGER: {
                        ArrayValueImpl.checkNumberType(null, JsonParser.NumberType.INT, jp);
                        this.add(jp.getIntValue());
                        break;
                    }
                    case LONG: {
                        ArrayValueImpl.checkNumberType(null, JsonParser.NumberType.LONG, jp);
                        this.add(jp.getLongValue());
                        break;
                    }
                    case DOUBLE: {
                        ArrayValueImpl.checkNumberType(null, JsonParser.NumberType.DOUBLE, jp);
                        this.add(jp.getDoubleValue());
                        break;
                    }
                    case FLOAT: {
                        ArrayValueImpl.checkNumberType(null, JsonParser.NumberType.FLOAT, jp);
                        this.add(jp.getFloatValue());
                        break;
                    }
                    case NUMBER: {
                        ArrayValueImpl.checkNumberType(null, JsonParser.NumberType.BIG_DECIMAL, jp);
                        this.addNumber(TableJsonUtils.jsonParserGetDecimalValue(jp));
                        break;
                    }
                    case STRING: {
                        this.add(jp.getText());
                        break;
                    }
                    case BINARY: {
                        this.add(jp.getBinaryValue());
                        break;
                    }
                    case FIXED_BINARY: {
                        this.addFixed(jp.getBinaryValue());
                        break;
                    }
                    case BOOLEAN: {
                        this.add(jp.getBooleanValue());
                        break;
                    }
                    case TIMESTAMP: {
                        this.add(element.asTimestamp().fromString(jp.getText()));
                        break;
                    }
                    case ARRAY: {
                        ArrayValueImpl array1 = this.addArray();
                        array1.addJsonFields(jp, null, exact, addMissingFields);
                        break;
                    }
                    case MAP: {
                        MapValueImpl map = this.addMap();
                        map.addJsonFields(jp, null, exact, addMissingFields);
                        break;
                    }
                    case RECORD: {
                        RecordValueImpl record = this.addRecord();
                        record.addJsonFields(jp, null, exact, addMissingFields);
                        break;
                    }
                    case ENUM: {
                        this.addEnum(jp.getText());
                        break;
                    }
                    case JSON: 
                    case ANY_JSON_ATOMIC: {
                        this.array.add(JsonDefImpl.createFromJson(jp, false));
                        break;
                    }
                    case ANY: {
                        throw new IllegalArgumentException("ARRAY(ANY) not suported yet");
                    }
                    case ANY_ATOMIC: {
                        throw new IllegalArgumentException("ARRAY(ANY_ATOMIC) not suported yet");
                    }
                    case ANY_RECORD: {
                        throw new IllegalStateException("An array type cannot have ANY_RECORD as its element type");
                    }
                    case EMPTY: {
                        throw new IllegalStateException("An array type cannot have EMPTY as its element type");
                    }
                }
            }
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Failed to parse JSON input: " + ioe.getMessage(), ioe);
        }
        catch (RuntimeException re) {
            if (re instanceof IllegalArgumentException) {
                throw re;
            }
            throw new IllegalArgumentException("Failed to parse JSON input: " + re.toString(), re);
        }
    }

    @Override
    public FieldValueImpl getNextValue() {
        if (this.size() != 1) {
            throw new IllegalArgumentException("Array values used in ranges must contain only one element");
        }
        ArrayValueImpl newArray = new ArrayValueImpl(this.getDefinition());
        FieldValueImpl fvi = this.get(0).getNextValue();
        newArray.add(fvi);
        return newArray;
    }

    @Override
    public FieldValueImpl getMinimumValue() {
        if (this.size() != 1) {
            throw new IllegalArgumentException("Array values used in ranges must contain only one element");
        }
        ArrayValueImpl newArray = new ArrayValueImpl(this.getDefinition());
        FieldValueImpl fvi = this.get(0).getMinimumValue();
        newArray.add(fvi);
        return newArray;
    }

    @Override
    public JsonNode toJsonNode() {
        ArrayNode node = JsonNodeFactory.instance.arrayNode();
        for (FieldValue value : this.array) {
            node.add(((FieldValueImpl)value).toJsonNode());
        }
        return node;
    }

    @Override
    public void toStringBuilder(StringBuilder sb) {
        sb.append('[');
        for (int i = 0; i < this.array.size(); ++i) {
            if (i > 0) {
                sb.append(',');
            }
            FieldValueImpl value = (FieldValueImpl)this.array.get(i);
            value.toStringBuilder(sb);
        }
        sb.append(']');
    }

    static ArrayValueImpl fromJavaObjectValue(FieldDef def, Object o) {
        List<Object> coll = null;
        coll = o instanceof Iterable ? (List<Object>)o : Arrays.asList((Object[])o);
        ArrayValueImpl newArray = (ArrayValueImpl)def.createArray();
        for (Object t : coll) {
            newArray.add(FieldValueImpl.fromJavaObjectValue(newArray.getElementDef(), t));
        }
        return newArray;
    }

    public void clear() {
        this.array.clear();
    }

    private ArrayValue addScalar(FieldValue value) {
        assert (((FieldDefImpl)value.getDefinition()).isSubtype(this.getElementDef()));
        if (value.isFloat() && this.getElementDef().isJson()) {
            value = FieldDefImpl.doubleDef.createDouble(value.asFloat().get());
        }
        this.trackHomogeneousType(value);
        this.array.add(value);
        return this;
    }

    private ArrayValue addScalar(int index, FieldValue value) {
        assert (((FieldDefImpl)value.getDefinition()).isSubtype(this.getElementDef()));
        if (value.isFloat() && this.getElementDef().isJson()) {
            value = FieldDefImpl.doubleDef.createDouble(value.asFloat().get());
        }
        this.trackHomogeneousType(value);
        this.array.add(index, value);
        return this;
    }

    private ArrayValue setScalar(int index, FieldValue value) {
        assert (((FieldDefImpl)value.getDefinition()).isSubtype(this.getElementDef()));
        if (value.isFloat() && this.getElementDef().isJson()) {
            value = FieldDefImpl.doubleDef.createDouble(value.asFloat().get());
        }
        this.trackHomogeneousType(value);
        this.array.set(index, value);
        return this;
    }

    List<FieldValue> getArrayInternal() {
        return this.array;
    }

    FieldDefImpl getElementDef() {
        return ((ArrayDefImpl)this.fieldDef).getElement();
    }

    FieldDefImpl getHomogeneousType() {
        return this.homogeneousType;
    }

    void setHomogeneousType(FieldDefImpl def) {
        this.homogeneousType = def;
    }

    boolean isHomogeneous() {
        return this.homogeneousType != null;
    }

    public void addInternal(FieldValue value) {
        this.array.add(value);
    }

    ArrayValue addEnum(int value) {
        this.add(((EnumDefImpl)this.getElementDef()).createEnum(value));
        return this;
    }

    private void trackHomogeneousType(FieldValue value) {
        FieldDefImpl elemDef = this.getElementDef();
        if (!elemDef.isWildcard()) {
            return;
        }
        FieldDefImpl valDef = (FieldDefImpl)value.getDefinition();
        if (this.size() == 0) {
            assert (this.homogeneousType == null);
            if (valDef.isAtomic()) {
                this.homogeneousType = valDef;
            }
        } else if (this.homogeneousType != null && this.homogeneousType.getType() != valDef.getType()) {
            this.homogeneousType = null;
        }
    }

    private void clearHomogeneousType() {
        this.homogeneousType = null;
    }
}

