/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.parallelscan;

import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import oracle.kv.Consistency;
import oracle.kv.Depth;
import oracle.kv.Direction;
import oracle.kv.FaultException;
import oracle.kv.Key;
import oracle.kv.KeyRange;
import oracle.kv.KeyValueVersion;
import oracle.kv.ParallelScanIterator;
import oracle.kv.StoreIteratorConfig;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.KeySerializer;
import oracle.kv.impl.api.StoreIteratorParams;
import oracle.kv.impl.api.ops.MultiKeyIterate;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.ops.ResultKey;
import oracle.kv.impl.api.ops.ResultKeyValueVersion;
import oracle.kv.impl.api.ops.StoreIterate;
import oracle.kv.impl.api.ops.StoreKeysIterate;
import oracle.kv.impl.api.parallelscan.PartitionScanIterator;

public class ParallelScan {
    private ParallelScan() {
    }

    public static ParallelScanIterator<Key> createParallelKeyScan(KVStoreImpl storeImpl, Direction direction, int batchSize, Key parentKey, KeyRange subRange, Depth depth, Consistency consistency, long timeout, TimeUnit timeoutUnit, StoreIteratorConfig storeIteratorConfig) throws FaultException {
        if (direction == null) {
            throw new IllegalArgumentException("direction must not be null");
        }
        if (parentKey != null && parentKey.getMinorPath().size() > 0) {
            throw new IllegalArgumentException("Minor path of parentKey must be empty");
        }
        byte[] parentKeyBytes = parentKey != null ? storeImpl.getKeySerializer().toByteArray(parentKey) : null;
        KeyRange useRange = storeImpl.getKeySerializer().restrictRange(parentKey, subRange);
        StoreIteratorParams parallelKeyScanSIP = new StoreIteratorParams(direction, batchSize, parentKeyBytes, useRange, depth, consistency, timeout, timeoutUnit);
        return new PartitionScanIterator<Key>(storeImpl, storeIteratorConfig, parallelKeyScanSIP){

            @Override
            protected MultiKeyIterate generateGetterOp(byte[] resumeKey) {
                return new StoreKeysIterate(this.storeIteratorParams.getParentKeyBytes(), this.storeIteratorParams.getSubRange(), this.storeIteratorParams.getDepth(), this.storeIteratorParams.getPartitionDirection(), this.storeIteratorParams.getBatchSize(), resumeKey);
            }

            @Override
            protected void convertResult(Result result, List<Key> elementList) {
                List<ResultKey> byteKeyResults = result.getKeyList();
                int cnt = byteKeyResults.size();
                if (cnt == 0) {
                    assert (!result.hasMoreElements());
                    return;
                }
                for (int i = 0; i < cnt; ++i) {
                    byte[] entry = byteKeyResults.get(i).getKeyBytes();
                    elementList.add(this.storeImpl.getKeySerializer().fromByteArray(entry));
                }
            }

            @Override
            protected int compare(Key one, Key two) {
                return one.compareTo(two);
            }
        };
    }

    public static ParallelScanIterator<KeyValueVersion> createParallelScan(KVStoreImpl storeImpl, Direction direction, int batchSize, Key parentKey, KeyRange subRange, Depth depth, Consistency consistency, long timeout, TimeUnit timeoutUnit, StoreIteratorConfig storeIteratorConfig) {
        return ParallelScan.createParallelScan(storeImpl, direction, batchSize, parentKey, subRange, depth, consistency, timeout, timeoutUnit, storeIteratorConfig, null);
    }

    public static ParallelScanIterator<KeyValueVersion> createParallelScan(KVStoreImpl storeImpl, Direction direction, int batchSize, Key parentKey, KeyRange subRange, Depth depth, Consistency consistency, long timeout, TimeUnit timeoutUnit, StoreIteratorConfig storeIteratorConfig, Set<Integer> partitions) throws FaultException {
        if (direction == null) {
            throw new IllegalArgumentException("direction must not be null");
        }
        if (parentKey != null && parentKey.getMinorPath().size() > 0) {
            throw new IllegalArgumentException("Minor path of parentKey must be empty");
        }
        byte[] parentKeyBytes = parentKey != null ? storeImpl.getKeySerializer().toByteArray(parentKey) : null;
        KeyRange useRange = storeImpl.getKeySerializer().restrictRange(parentKey, subRange);
        StoreIteratorParams parallelScanSIP = new StoreIteratorParams(direction, batchSize, parentKeyBytes, useRange, depth, consistency, timeout, timeoutUnit, partitions);
        return new PartitionScanIterator<KeyValueVersion>(storeImpl, storeIteratorConfig, parallelScanSIP){

            @Override
            protected MultiKeyIterate generateGetterOp(byte[] resumeKey) {
                return new StoreIterate(this.storeIteratorParams.getParentKeyBytes(), this.storeIteratorParams.getSubRange(), this.storeIteratorParams.getDepth(), this.storeIteratorParams.getPartitionDirection(), this.storeIteratorParams.getBatchSize(), resumeKey);
            }

            @Override
            protected void convertResult(Result result, List<KeyValueVersion> elementList) {
                List<ResultKeyValueVersion> byteKeyResults = result.getKeyValueVersionList();
                int cnt = byteKeyResults.size();
                if (cnt == 0) {
                    assert (!result.hasMoreElements());
                    return;
                }
                for (int i = 0; i < cnt; ++i) {
                    ResultKeyValueVersion entry = byteKeyResults.get(i);
                    KeySerializer keySerializer = this.storeImpl.getKeySerializer();
                    elementList.add(KVStoreImpl.createKeyValueVersion(keySerializer.fromByteArray(entry.getKeyBytes()), entry.getValue(), entry.getVersion(), entry.getExpirationTime()));
                }
            }

            @Override
            protected int compare(KeyValueVersion one, KeyValueVersion two) {
                return one.getKey().compareTo(two.getKey());
            }
        };
    }
}

