/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.parallelscan;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.Direction;
import oracle.kv.ParallelScanIterator;
import oracle.kv.RequestTimeoutException;
import oracle.kv.StoreIteratorException;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.Request;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.parallelscan.ParallelScanHook;

public abstract class BaseParallelScanIteratorImpl<K>
implements ParallelScanIterator<K> {
    private static final long NANOS_TO_MILLIS = 1000000L;
    private static final long WAIT_TIME_MS = 100L;
    private static final int QUEUE_SIZE = 3;
    protected KVStoreImpl storeImpl;
    protected Logger logger;
    protected long requestTimeoutMs;
    protected Direction itrDirection;
    protected KVStoreImpl.TaskExecutor taskExecutor;
    protected TreeSet<Stream> streams;
    protected volatile boolean closed = false;
    protected Exception closeException = null;
    protected K next = null;
    private int maxResultsBatches = 0;

    @Override
    public boolean hasNext() {
        if (this.isClosed()) {
            return false;
        }
        if (this.next == null) {
            this.next = this.getNext();
        }
        return this.next != null;
    }

    @Override
    public K next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        K lastReturned = this.next;
        this.next = null;
        return lastReturned;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        this.close(null);
    }

    protected void setMaxResultsBatches(int maxResultsBatches) {
        this.maxResultsBatches = maxResultsBatches;
    }

    protected int getMaxResultsBatches() {
        return this.maxResultsBatches > 0 ? this.maxResultsBatches : 3;
    }

    private boolean isClosed() {
        if (this.closed) {
            if (this.closeException != null) {
                throw new StoreIteratorException(this.closeException, null);
            }
            return true;
        }
        return false;
    }

    private K getNext() {
        long limitNs = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.requestTimeoutMs);
        while (!this.isClosed()) {
            Stream stream = this.streams.pollFirst();
            if (stream == null) {
                this.close();
                return null;
            }
            Object entry = stream.removeNext();
            if (!stream.isDone()) {
                this.streams.add(stream);
            }
            if (this.isClosed()) {
                return null;
            }
            if (entry != null) {
                return (K)entry;
            }
            long waitMs = Math.min((limitNs - System.nanoTime()) / 1000000L, 100L);
            if (waitMs <= 0L) {
                throw new RequestTimeoutException((int)this.requestTimeoutMs, "Operation timed out on shard: " + stream, null, false);
            }
            stream.waitForNext(waitMs);
        }
        return null;
    }

    protected abstract void close(Exception var1);

    protected abstract int compare(K var1, K var2);

    protected abstract void convertResult(Result var1, List<K> var2);

    public abstract class Stream
    implements Comparable<Stream>,
    Runnable {
        private final BlockingQueue<Result> blocks;
        protected Result currentResultSet;
        private List<K> currentBlock;
        protected int currentResultPos;
        private K nextElem;
        private boolean doneReading;
        private boolean done;
        private boolean active;

        public Stream() {
            this.blocks = new LinkedBlockingQueue<Result>(BaseParallelScanIteratorImpl.this.getMaxResultsBatches());
            this.currentResultPos = -1;
            this.nextElem = null;
            this.doneReading = false;
            this.done = false;
            this.active = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private K removeNext() {
            assert (!this.done);
            Object ret = this.nextElem;
            if (this.currentBlock != null && !this.currentBlock.isEmpty()) {
                do {
                    this.nextElem = this.currentBlock.remove(0);
                    ++this.currentResultPos;
                } while (this.nextElem == null && !this.currentBlock.isEmpty());
            } else {
                this.nextElem = null;
            }
            while (this.nextElem == null) {
                Stream stream = this;
                synchronized (stream) {
                    this.currentResultSet = (Result)this.blocks.poll();
                    this.currentBlock = null;
                    this.currentResultPos = -1;
                    this.submit();
                    if (this.currentResultSet == null) {
                        this.done = this.doneReading;
                        break;
                    }
                }
                int nRecords = this.currentResultSet.getNumRecords();
                if (nRecords <= 0) continue;
                this.currentBlock = new ArrayList(nRecords);
                BaseParallelScanIteratorImpl.this.convertResult(this.currentResultSet, this.currentBlock);
                assert (nRecords == this.currentBlock.size());
                do {
                    this.nextElem = this.currentBlock.remove(0);
                    ++this.currentResultPos;
                } while (this.nextElem == null && !this.currentBlock.isEmpty());
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitForNext(long waitMs) {
            block7: {
                if (this.nextElem != null) {
                    return;
                }
                try {
                    Stream stream = this;
                    synchronized (stream) {
                        if (this.blocks.isEmpty() && !this.doneReading) {
                            this.wait(waitMs);
                        }
                    }
                }
                catch (InterruptedException ex) {
                    if (BaseParallelScanIteratorImpl.this.closed) break block7;
                    BaseParallelScanIteratorImpl.this.logger.log(Level.WARNING, "Unexpected interrupt ", ex);
                }
            }
        }

        boolean isDone() {
            return this.done;
        }

        public synchronized void submit() {
            if (this.active || this.doneReading || this.blocks.remainingCapacity() == 0) {
                return;
            }
            this.active = true;
            try {
                BaseParallelScanIteratorImpl.this.taskExecutor.submit(this);
            }
            catch (RejectedExecutionException ree) {
                this.active = false;
                BaseParallelScanIteratorImpl.this.close(ree);
            }
        }

        @Override
        public void run() {
            try {
                assert (this.active);
                assert (!this.doneReading);
                assert (this.blocks.remainingCapacity() > 0);
                long start = System.nanoTime();
                int count = this.readBlock();
                long end = System.nanoTime();
                long thisTimeMs = (end - start) / 1000000L;
                this.updateDetailedMetrics(thisTimeMs, count);
            }
            catch (RuntimeException re) {
                this.active = false;
                BaseParallelScanIteratorImpl.this.close(re);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int readBlock() {
            Request req = this.makeReadRequest();
            if (req == null) {
                Stream stream = this;
                synchronized (stream) {
                    this.active = false;
                    this.doneReading = true;
                    this.notify();
                    return 0;
                }
            }
            assert (BaseParallelScanIteratorImpl.this.storeImpl.getParallelScanHook() == null || BaseParallelScanIteratorImpl.this.storeImpl.getParallelScanHook().callback(Thread.currentThread(), ParallelScanHook.HookType.BEFORE_EXECUTE_REQUEST, null));
            Result result = BaseParallelScanIteratorImpl.this.storeImpl.executeRequest(req);
            boolean hasMore = this.hasMoreElements(result);
            int nRecords = result.getNumRecords();
            if (nRecords > 0) {
                this.setResumeKey(result);
            }
            Stream stream = this;
            synchronized (stream) {
                this.active = false;
                boolean bl = this.doneReading = !hasMore;
                if (nRecords == 0) {
                    assert (BaseParallelScanIteratorImpl.this.storeImpl.getParallelScanHook() == null || BaseParallelScanIteratorImpl.this.storeImpl.getParallelScanHook().callback(Thread.currentThread(), ParallelScanHook.HookType.AFTER_PROCESSING_STREAM, null));
                    this.notify();
                    return 0;
                }
                this.blocks.add(result);
                this.notify();
            }
            this.submit();
            return nRecords;
        }

        protected abstract void setResumeKey(Result var1);

        protected abstract Request makeReadRequest();

        protected boolean hasMoreElements(Result result) {
            return result.hasMoreElements();
        }

        @Override
        public int compareTo(Stream other) {
            if (this == other) {
                return 0;
            }
            if (BaseParallelScanIteratorImpl.this.itrDirection == Direction.UNORDERED) {
                return this.nextElem == null ? 1 : -1;
            }
            if (this.nextElem == null) {
                return -1;
            }
            Object otherNext = other.nextElem;
            if (otherNext == null) {
                return 1;
            }
            int comp = this.compareInternal(other);
            if (comp == 0) {
                BaseParallelScanIteratorImpl.this.close(new IllegalStateException("Detected an unexpected duplicate record"));
            }
            return comp;
        }

        protected int compareInternal(Stream other) {
            int cmp = BaseParallelScanIteratorImpl.this.compare(this.nextElem, other.nextElem);
            return BaseParallelScanIteratorImpl.this.itrDirection == Direction.FORWARD ? cmp : cmp * -1;
        }

        public String getStatus() {
            return this.done + ", " + this.active + ", " + this.doneReading + ", " + this.blocks.size();
        }

        protected abstract void updateDetailedMetrics(long var1, long var3);
    }
}

