/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.MathContext;
import java.math.RoundingMode;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.query.PreparedStatementImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldDefSerialization;
import oracle.kv.impl.api.table.FieldValueSerialization;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.ReceiveIter;
import oracle.kv.impl.util.SerialVersion;
import oracle.kv.table.FieldValue;

public class TableQuery
extends InternalOperation {
    private final PlanIter queryPlan;
    private final FieldDefImpl resultDef;
    private final boolean mayReturnNULL;
    private final FieldValue[] externalVars;
    private final int numIterators;
    private final int numRegisters;
    private final int batchSize;
    private final byte traceLevel;
    private byte[] primaryResumeKey;
    private byte[] secondaryResumeKey;
    private final long numResultsComputed;
    private final MathContext mathContext;

    public TableQuery(PlanIter queryPlan, FieldDefImpl resultDef, boolean mayReturnNULL, PreparedStatementImpl.DistributionKind distKind, FieldValue[] externalVars, int numIterators, int numRegisters, int batchSize, byte traceLevel, byte[] primaryResumeKey, byte[] secondaryResumeKey, long numResultsComputed, MathContext mathContext) {
        super(distKind == PreparedStatementImpl.DistributionKind.ALL_PARTITIONS ? InternalOperation.OpCode.QUERY_MULTI_PARTITION : (distKind == PreparedStatementImpl.DistributionKind.ALL_SHARDS ? InternalOperation.OpCode.QUERY_MULTI_SHARD : InternalOperation.OpCode.QUERY_SINGLE_PARTITION));
        this.queryPlan = queryPlan;
        this.resultDef = resultDef;
        this.mayReturnNULL = mayReturnNULL;
        this.externalVars = externalVars;
        this.numIterators = numIterators;
        this.numRegisters = numRegisters;
        this.primaryResumeKey = primaryResumeKey;
        this.secondaryResumeKey = secondaryResumeKey;
        this.batchSize = batchSize;
        this.traceLevel = traceLevel;
        this.numResultsComputed = numResultsComputed;
        this.mathContext = mathContext;
    }

    PlanIter getQueryPlan() {
        return this.queryPlan;
    }

    FieldDefImpl getResultDef() {
        return this.resultDef;
    }

    boolean mayReturnNULL() {
        return this.mayReturnNULL;
    }

    FieldValue[] getExternalVars() {
        return this.externalVars;
    }

    int getNumIterators() {
        return this.numIterators;
    }

    int getNumRegisters() {
        return this.numRegisters;
    }

    int getBatchSize() {
        return this.batchSize;
    }

    byte getTraceLevel() {
        return this.traceLevel;
    }

    byte[] getPrimaryResumeKey() {
        return this.primaryResumeKey;
    }

    byte[] getSecondaryResumeKey() {
        return this.secondaryResumeKey;
    }

    long getNumResultsComputed() {
        return this.numResultsComputed;
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        if (serialVersion < 12) {
            out.writeShort(1);
        }
        assert (this.queryPlan instanceof ReceiveIter);
        byte[] serializedQueryPlan = ((ReceiveIter)this.queryPlan).ensureSerializedIter(serialVersion);
        out.write(serializedQueryPlan);
        FieldDefSerialization.writeFieldDef(this.resultDef, out, serialVersion);
        if (serialVersion >= 12) {
            out.writeBoolean(this.mayReturnNULL);
        }
        TableQuery.writeExternalVars(this.externalVars, out, serialVersion);
        out.writeInt(this.numIterators);
        out.writeInt(this.numRegisters);
        out.writeInt(this.batchSize);
        if (serialVersion >= 13) {
            out.writeByte(this.traceLevel);
        }
        if (this.primaryResumeKey == null) {
            out.writeShort(-1);
        } else {
            out.writeShort(this.primaryResumeKey.length);
            out.write(this.primaryResumeKey);
        }
        if (this.secondaryResumeKey == null) {
            out.writeShort(-1);
        } else {
            out.writeShort(this.secondaryResumeKey.length);
            out.write(this.secondaryResumeKey);
        }
        out.writeLong(this.numResultsComputed);
        if (serialVersion >= 14) {
            TableQuery.writeMathContext(this.mathContext, out);
        }
    }

    protected TableQuery(InternalOperation.OpCode opCode, DataInput in, short serialVersion) throws IOException {
        super(opCode, in, serialVersion);
        if (serialVersion < 11) {
            String required = SerialVersion.getKVVersion((short)11).getNumericVersionString();
            String found = SerialVersion.getKVVersion(serialVersion).getNumericVersionString();
            throw new UnsupportedOperationException("Query operations require a client version equal to or greater than " + required + ". The client version detected is " + found);
        }
        try {
            if (serialVersion < 12) {
                in.readShort();
            }
            this.queryPlan = PlanIter.deserializeIter(in, serialVersion);
            this.resultDef = FieldDefSerialization.readFieldDef(in, serialVersion);
            this.mayReturnNULL = serialVersion < 12 ? false : in.readBoolean();
            this.externalVars = TableQuery.readExternalVars(in, serialVersion);
            this.numIterators = in.readInt();
            this.numRegisters = in.readInt();
            this.batchSize = in.readInt();
            this.traceLevel = serialVersion < 13 ? (byte)0 : in.readByte();
            short keyLen = in.readShort();
            if (keyLen < 0) {
                this.primaryResumeKey = null;
            } else {
                this.primaryResumeKey = new byte[keyLen];
                in.readFully(this.primaryResumeKey);
            }
            keyLen = in.readShort();
            if (keyLen < 0) {
                this.secondaryResumeKey = null;
            } else {
                this.secondaryResumeKey = new byte[keyLen];
                in.readFully(this.secondaryResumeKey);
            }
            this.numResultsComputed = in.readLong();
            this.mathContext = serialVersion < 14 ? MathContext.DECIMAL32 : TableQuery.readMathContext(in);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }

    static void writeExternalVars(FieldValue[] vars, DataOutput out, short serialVersion) throws IOException {
        if (vars != null && vars.length > 0) {
            int numVars = vars.length;
            out.writeInt(numVars);
            for (int i = 0; i < numVars; ++i) {
                FieldValueSerialization.writeFieldValue(vars[i], true, out, serialVersion);
            }
        } else {
            out.writeInt(0);
        }
    }

    static FieldValue[] readExternalVars(DataInput in, short serialVersion) throws IOException {
        int numVars = in.readInt();
        if (numVars == 0) {
            return null;
        }
        FieldValue[] vars = new FieldValue[numVars];
        for (int i = 0; i < numVars; ++i) {
            FieldValue val;
            vars[i] = val = FieldValueSerialization.readFieldValue(null, in, serialVersion);
        }
        return vars;
    }

    static void writeMathContext(MathContext mathContext, DataOutput out) throws IOException {
        if (mathContext == null) {
            out.writeByte(0);
        } else if (MathContext.DECIMAL32.equals(mathContext)) {
            out.writeByte(1);
        } else if (MathContext.DECIMAL64.equals(mathContext)) {
            out.writeByte(2);
        } else if (MathContext.DECIMAL128.equals(mathContext)) {
            out.writeByte(3);
        } else if (MathContext.UNLIMITED.equals(mathContext)) {
            out.writeByte(4);
        } else {
            out.writeByte(5);
            out.writeInt(mathContext.getPrecision());
            out.writeInt(mathContext.getRoundingMode().ordinal());
        }
    }

    static MathContext readMathContext(DataInput in) throws IOException {
        byte code = in.readByte();
        switch (code) {
            case 0: {
                return null;
            }
            case 1: {
                return MathContext.DECIMAL32;
            }
            case 2: {
                return MathContext.DECIMAL64;
            }
            case 3: {
                return MathContext.DECIMAL128;
            }
            case 4: {
                return MathContext.UNLIMITED;
            }
            case 5: {
                int precision = in.readInt();
                int roundingMode = in.readInt();
                return new MathContext(precision, RoundingMode.valueOf(roundingMode));
            }
        }
        throw new QueryStateException("Unknown MathContext code.");
    }

    public MathContext getMathContext() {
        return this.mathContext;
    }
}

