/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.DataInput;
import java.io.IOException;
import oracle.kv.KeyRange;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.MultiTableOperation;
import oracle.kv.impl.api.table.TargetTables;

public class MultiDeleteTable
extends MultiTableOperation {
    private final byte[] resumeKey;
    private final boolean majorPathComplete;
    private final int batchSize;
    private transient byte[] lastDeleted;

    public MultiDeleteTable(byte[] parentKey, TargetTables targetTables, KeyRange subRange) {
        super(InternalOperation.OpCode.MULTI_DELETE_TABLE, parentKey, targetTables, subRange);
        this.majorPathComplete = true;
        this.batchSize = 0;
        this.resumeKey = null;
    }

    protected MultiDeleteTable(DataInput in, short serialVersion) throws IOException {
        super(InternalOperation.OpCode.MULTI_DELETE_TABLE, in, serialVersion);
        this.majorPathComplete = true;
        this.batchSize = 0;
        this.resumeKey = null;
    }

    public MultiDeleteTable(byte[] parentKey, long targetTableId, boolean majorPathComplete, int batchSize, byte[] resumeKey) {
        super(InternalOperation.OpCode.MULTI_DELETE_TABLE, parentKey, new TargetTables(targetTableId), null);
        this.majorPathComplete = majorPathComplete;
        this.batchSize = batchSize;
        this.resumeKey = resumeKey;
    }

    byte[] getResumeKey() {
        return this.resumeKey;
    }

    boolean getMajorPathComplete() {
        return this.majorPathComplete;
    }

    int getBatchSize() {
        return this.batchSize;
    }

    public byte[] getLastDeleted() {
        return this.lastDeleted;
    }

    void setLastDeleted(byte[] lastDeleted) {
        this.lastDeleted = lastDeleted;
    }
}

