/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.bulk;

import com.sleepycat.je.utilint.PropUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import oracle.kv.Consistency;
import oracle.kv.Depth;
import oracle.kv.Direction;
import oracle.kv.Key;
import oracle.kv.KeyRange;
import oracle.kv.KeyValueVersion;
import oracle.kv.ParallelScanIterator;
import oracle.kv.StoreIteratorConfig;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.KeySerializer;
import oracle.kv.impl.api.Request;
import oracle.kv.impl.api.StoreIteratorParams;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.MultiGetBatchIterate;
import oracle.kv.impl.api.ops.MultiGetBatchKeysIterate;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.ops.ResultKey;
import oracle.kv.impl.api.ops.ResultKeyValueVersion;
import oracle.kv.impl.api.parallelscan.BaseParallelScanIteratorImpl;
import oracle.kv.impl.api.parallelscan.DetailedMetricsImpl;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.topo.TopologyUtil;
import oracle.kv.impl.util.KVThreadFactory;
import oracle.kv.stats.DetailedMetrics;
import oracle.kv.table.TableIterator;

public class BulkMultiGet {
    public static ParallelScanIterator<KeyValueVersion> createBulkMultiGetIterator(KVStoreImpl storeImpl, List<Iterator<Key>> parentKeyIterators, int batchSize, KeyRange subRange, Depth depth, Consistency consistency, long timeout, TimeUnit timeoutUnit, StoreIteratorConfig config) {
        KeyRange useRange = storeImpl.getKeySerializer().restrictRange(null, subRange);
        final StoreIteratorParams params = new StoreIteratorParams(Direction.UNORDERED, batchSize, null, useRange, depth, consistency, timeout, timeoutUnit);
        return new BulkGetIterator<Key, KeyValueVersion>(storeImpl, parentKeyIterators, params, config){

            @Override
            public void validateKey(Key key) {
            }

            @Override
            public Key getKey(Key key) {
                return key;
            }

            @Override
            protected InternalOperation generateBulkGetOp(List<byte[]> parentKeys, byte[] resumeKey) {
                return new MultiGetBatchIterate(parentKeys, resumeKey, params.getSubRange(), params.getDepth(), params.getBatchSize());
            }

            @Override
            protected void convertResult(Result result, List<KeyValueVersion> elementList) {
                List<ResultKeyValueVersion> results = result.getKeyValueVersionList();
                if (results.size() == 0) {
                    return;
                }
                for (ResultKeyValueVersion entry : results) {
                    byte[] keyBytes = entry.getKeyBytes();
                    Key key = this.keySerializer.fromByteArray(keyBytes);
                    KeyValueVersion value = KVStoreImpl.createKeyValueVersion(key, entry.getValue(), entry.getVersion(), entry.getExpirationTime());
                    elementList.add(value);
                }
            }
        };
    }

    public static ParallelScanIterator<Key> createBulkMultiGetKeysIterator(KVStoreImpl storeImpl, List<Iterator<Key>> parentKeyiterators, int batchSize, KeyRange subRange, Depth depth, Consistency consistency, long timeout, TimeUnit timeoutUnit, StoreIteratorConfig config) {
        KeyRange useRange = storeImpl.getKeySerializer().restrictRange(null, subRange);
        final StoreIteratorParams params = new StoreIteratorParams(Direction.UNORDERED, batchSize, null, useRange, depth, consistency, timeout, timeoutUnit);
        return new BulkGetIterator<Key, Key>(storeImpl, parentKeyiterators, params, config){

            @Override
            public void validateKey(Key key) {
            }

            @Override
            public Key getKey(Key key) {
                return key;
            }

            @Override
            protected InternalOperation generateBulkGetOp(List<byte[]> parentKeys, byte[] resumeKey) {
                return new MultiGetBatchKeysIterate(parentKeys, resumeKey, params.getSubRange(), params.getDepth(), params.getBatchSize());
            }

            @Override
            protected void convertResult(Result result, List<Key> elementList) {
                List<ResultKey> byteKeyResults = result.getKeyList();
                int cnt = byteKeyResults.size();
                if (cnt == 0) {
                    assert (!result.hasMoreElements());
                    return;
                }
                for (int i = 0; i < cnt; ++i) {
                    byte[] entry = byteKeyResults.get(i).getKeyBytes();
                    elementList.add(this.keySerializer.fromByteArray(entry));
                }
            }
        };
    }

    public static abstract class BulkGetIterator<K, V>
    extends BaseParallelScanIteratorImpl<V>
    implements TableIterator<V> {
        private static final Comparator<byte[]> KEY_BYTES_COMPARATOR = new Key.BytesComparator();
        private final PartitionBatch partitionBatchEOF = new PartitionBatch(null, null);
        private final Topology topology;
        private final PartitionValues[] pMap;
        private ExecutorService readerExecutor;
        private HashMap<Future<Integer>, KeysReader> readerTasks;
        private Set<ShardGetStream> getStreams;
        private final Consistency consistency;
        private final TimeUnit timeoutUnit;
        private final long timeout;
        private final Map<RepGroupId, DetailedMetricsImpl> shardMetrics;
        private final AggregateStatistics statistics;
        protected final KeySerializer keySerializer;

        public BulkGetIterator(KVStoreImpl store, List<Iterator<K>> parentKeyIterators, StoreIteratorParams params, StoreIteratorConfig config) {
            this.storeImpl = store;
            this.topology = this.storeImpl.getTopology();
            this.logger = this.storeImpl.getLogger();
            this.keySerializer = this.storeImpl.getKeySerializer();
            this.shardMetrics = new HashMap<RepGroupId, DetailedMetricsImpl>();
            this.statistics = new AggregateStatistics();
            this.consistency = params.getConsistency();
            this.timeout = params.getTimeout();
            this.timeoutUnit = params.getTimeoutUnit();
            this.requestTimeoutMs = this.getRequestTimeoutMs(params.getTimeout(), params.getTimeoutUnit());
            this.itrDirection = params.getDirection();
            int partitionThreshold = params.getBatchSize();
            int nParts = this.topology.getPartitionMap().size();
            PartitionValues[] partitionValues = new PartitionValues[nParts + 1];
            this.pMap = partitionValues;
            for (int i = 0; i <= nParts; ++i) {
                this.pMap[i] = new PartitionValues(i, partitionThreshold);
            }
            int maxConcurrentRequests = config != null ? config.getMaxConcurrentRequests() : 0;
            int RNThreads = this.getNumOfShardTasks();
            int maxShardTasks = maxConcurrentRequests > 0 ? Math.min(maxConcurrentRequests, RNThreads) : RNThreads;
            this.startShardExecutor(maxShardTasks);
            int maxResultsBatches = 32;
            this.setMaxResultsBatches(32);
            this.startReaderExecutor(parentKeyIterators);
            ExecutorService executor = Executors.newSingleThreadExecutor(new KVThreadFactory("BulkGetReadersMonitor", this.logger));
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        BulkGetIterator.this.logReaderProgress(BulkGetIterator.this.readerExecutor);
                        for (Future f : BulkGetIterator.this.readerTasks.keySet()) {
                            int nKeys = (Integer)f.get();
                            BulkGetIterator.this.statistics.aggregate(nKeys);
                        }
                        BulkGetIterator.this.flushPartitions();
                        for (ShardGetStream sgs : BulkGetIterator.this.getStreams) {
                            sgs.setEOFPartitionBatch();
                        }
                    }
                    catch (InterruptedException ie) {
                        BulkGetIterator.this.logger.info(Thread.currentThread() + " caught " + ie);
                    }
                    catch (ExecutionException ee) {
                        BulkGetIterator.this.logger.info(Thread.currentThread() + " caught " + ee);
                    }
                }
            });
            executor.shutdown();
        }

        protected abstract void validateKey(K var1);

        protected abstract Key getKey(K var1);

        protected abstract InternalOperation generateBulkGetOp(List<byte[]> var1, byte[] var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void close(Exception reason) {
            Iterator<Object> iterator = this;
            synchronized (iterator) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                this.closeException = reason;
            }
            for (Future future : this.readerTasks.keySet()) {
                future.cancel(true);
            }
            List<Runnable> unfinishedBusiness = this.readerExecutor.shutdownNow();
            if (!unfinishedBusiness.isEmpty()) {
                int n = unfinishedBusiness.size();
                this.logger.log(Level.FINE, "Bulk get reader executor didn't shutdown cleanly. {0} tasks remaining.", n);
            }
            if (!(unfinishedBusiness = this.taskExecutor.shutdownNow()).isEmpty()) {
                int n = unfinishedBusiness.size();
                this.logger.log(Level.FINE, "Bulk get shard executor didn't shutdown cleanly. {0} tasks remaining.", n);
            }
            this.getStatInfo();
            this.logger.log(Level.INFO, this.statistics.toString());
        }

        @Override
        public List<DetailedMetrics> getPartitionMetrics() {
            return Collections.emptyList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<DetailedMetrics> getShardMetrics() {
            Map<RepGroupId, DetailedMetricsImpl> map = this.shardMetrics;
            synchronized (map) {
                ArrayList<DetailedMetrics> ret = new ArrayList<DetailedMetrics>(this.shardMetrics.size());
                ret.addAll(this.shardMetrics.values());
                return ret;
            }
        }

        private int getRequestTimeoutMs(long timeOut, TimeUnit unit) {
            if (timeOut == 0L) {
                return this.storeImpl.getDefaultRequestTimeoutMs();
            }
            int timeoutMs = PropUtil.durationToMillis(timeOut, unit);
            if (this.requestTimeoutMs > (long)this.storeImpl.getReadTimeoutMs()) {
                String format = "Request timeout parameter: %,d ms exceeds socket read timeout: %,d ms";
                throw new IllegalArgumentException(String.format("Request timeout parameter: %,d ms exceeds socket read timeout: %,d ms", this.requestTimeoutMs, this.storeImpl.getReadTimeoutMs()));
            }
            return timeoutMs;
        }

        private void startShardExecutor(int maxShardTasks) {
            int residualPerShardParallelism;
            int basePerShardParallelism;
            String fmt = "startShardExecutor #ShardTasks:%d, #Shards:%d, base parallelism per shard:%d, residual parallelism per shard:%d";
            int nShards = this.topology.getRepGroupMap().size();
            if (maxShardTasks > nShards) {
                basePerShardParallelism = maxShardTasks / nShards;
                residualPerShardParallelism = maxShardTasks % nShards;
            } else {
                basePerShardParallelism = 1;
                residualPerShardParallelism = 0;
            }
            this.logger.info(String.format("startShardExecutor #ShardTasks:%d, #Shards:%d, base parallelism per shard:%d, residual parallelism per shard:%d", maxShardTasks, nShards, basePerShardParallelism, residualPerShardParallelism));
            Map<RepGroupId, List<PartitionId>> map = TopologyUtil.getRGIdPartMap(this.topology);
            this.taskExecutor = this.storeImpl.getTaskExecutor(maxShardTasks);
            this.streams = new TreeSet();
            this.getStreams = new HashSet<ShardGetStream>();
            block0: for (RepGroupId rgId : this.topology.getRepGroupIds()) {
                int perTaskPartitions;
                List<PartitionId> list = map.get(rgId);
                int nParts = list.size();
                int perShardParallelism = basePerShardParallelism;
                if (residualPerShardParallelism > 0) {
                    --residualPerShardParallelism;
                    ++perShardParallelism;
                }
                int basePerTaskPartitions = nParts / perShardParallelism;
                int residualPerTaskPartitions = nParts % perShardParallelism;
                for (int i = 0; i < nParts; i += perTaskPartitions) {
                    perTaskPartitions = basePerTaskPartitions;
                    if (residualPerTaskPartitions > 0) {
                        ++perTaskPartitions;
                        --residualPerTaskPartitions;
                    }
                    if (perTaskPartitions == 0) continue block0;
                    List<PartitionId> taskPartitions = list.subList(i, i + perTaskPartitions);
                    this.logger.info("Partitions:" + Arrays.toString(taskPartitions.toArray()) + " assigned to RG task");
                    ShardGetStream task = new ShardGetStream(rgId, taskPartitions.size());
                    for (PartitionId pid : taskPartitions) {
                        PartitionValues pv = this.pMap[pid.getPartitionId()];
                        pv.setShardTask(task);
                    }
                    this.streams.add(task);
                    this.getStreams.add(task);
                    task.submit();
                }
            }
        }

        private Consistency getConsistency() {
            return this.consistency != null ? this.consistency : this.storeImpl.getDefaultConsistency();
        }

        private int getNumOfShardTasks() {
            int useNumRepNodes;
            if (this.getConsistency() == Consistency.ABSOLUTE) {
                useNumRepNodes = this.topology.getRepGroupMap().size();
            } else {
                int[] readZoneIds = this.storeImpl.getDispatcher().getReadZoneIds();
                useNumRepNodes = TopologyUtil.getNumRepNodesForRead(this.topology, readZoneIds);
            }
            if (useNumRepNodes == 0) {
                throw new IllegalStateException("Store not yet initialized");
            }
            return useNumRepNodes * 2;
        }

        private void startReaderExecutor(List<Iterator<K>> parentKeyIterators) {
            KVThreadFactory threadFactory = new KVThreadFactory("BulkGetReaders", this.logger);
            int nReaders = parentKeyIterators.size();
            this.readerExecutor = Executors.newFixedThreadPool(nReaders, threadFactory);
            this.readerTasks = new HashMap(nReaders);
            for (int i = 0; i < nReaders; ++i) {
                Iterator<K> keyIterator = parentKeyIterators.get(i);
                KeysReader kr = new KeysReader(keyIterator);
                Future<Integer> future = null;
                try {
                    future = this.readerExecutor.submit(kr);
                }
                catch (RejectedExecutionException ree) {
                    this.close(ree);
                }
                this.readerTasks.put(future, kr);
            }
            this.readerExecutor.shutdown();
        }

        private void flushPartitions() throws InterruptedException {
            for (PartitionValues pv : this.pMap) {
                pv.flush(true);
            }
            this.logger.info("Flushed all partitions");
        }

        private void logReaderProgress(ExecutorService executor) throws InterruptedException {
            long startMs = System.currentTimeMillis();
            long prevTotalRead = 0L;
            while (!executor.awaitTermination(1L, TimeUnit.MINUTES)) {
                String fmt = "Reading continues. %,d values read. Throughput:%,d values/sec";
                long totalRead = this.totalRead();
                long throughput = totalRead * 1000L / (System.currentTimeMillis() - startMs);
                this.logger.log(totalRead > prevTotalRead ? Level.INFO : Level.WARNING, String.format("Reading continues. %,d values read. Throughput:%,d values/sec", totalRead, throughput));
                prevTotalRead = totalRead;
            }
        }

        private long totalRead() {
            long totalRead = 0L;
            for (KeysReader kr : this.readerTasks.values()) {
                totalRead += (long)kr.getReadCount();
            }
            return totalRead;
        }

        private void getStatInfo() {
            for (ShardGetStream sgs : this.getStreams) {
                AggregateStatistics aggregateStatistics = this.statistics;
                aggregateStatistics.batchCount = aggregateStatistics.batchCount + sgs.getBatchCount();
                aggregateStatistics = this.statistics;
                aggregateStatistics.batchQueueUnderflow = aggregateStatistics.batchQueueUnderflow + sgs.getBatchQueueUnderflow();
                aggregateStatistics = this.statistics;
                aggregateStatistics.batchQueueOverflow = aggregateStatistics.batchQueueOverflow + sgs.getBatchQueueOverflow();
                if (this.statistics.maxBatchRequestRepeated >= sgs.getMaxBatchRequestRepeated()) continue;
                this.statistics.maxBatchRequestRepeated = sgs.getMaxBatchRequestRepeated();
            }
        }

        @Override
        protected int compare(V one, V two) {
            return 0;
        }

        static /* synthetic */ Comparator access$2500() {
            return KEY_BYTES_COMPARATOR;
        }

        private class AggregateStatistics {
            private long batchCount;
            private long batchQueueUnderflow;
            private long batchQueueOverflow;
            private int maxBatchRequestRepeated;
            private long readCount;

            private AggregateStatistics() {
            }

            public void aggregate(int entriesRead) {
                this.readCount += (long)entriesRead;
            }

            public long totalGetCount() {
                long total = 0L;
                for (Map.Entry entry : BulkGetIterator.this.shardMetrics.entrySet()) {
                    total += ((DetailedMetricsImpl)entry.getValue()).getScanRecordCount();
                }
                return total;
            }

            private long getTotalDupCount() {
                long total = 0L;
                for (PartitionValues pv : BulkGetIterator.this.pMap) {
                    total += pv.dupCount;
                }
                return total;
            }

            public String toString() {
                String fmt = "%,d key streams; %,d shard streams; %,d keys read; %,d duplicated; %,d get; %,d batches; %,d batch queue underflows; %,d batch queue overflows; %,d av batch size; %,d max batch request repeated;";
                long getCount = this.totalGetCount();
                return String.format("%,d key streams; %,d shard streams; %,d keys read; %,d duplicated; %,d get; %,d batches; %,d batch queue underflows; %,d batch queue overflows; %,d av batch size; %,d max batch request repeated;", BulkGetIterator.this.readerTasks.size(), BulkGetIterator.this.getStreams.size(), this.readCount, this.getTotalDupCount(), getCount, this.batchCount, this.batchQueueUnderflow, this.batchQueueOverflow, this.batchCount > 0L ? getCount / this.batchCount : 0L, this.maxBatchRequestRepeated);
            }
        }

        private class PartitionValues {
            private final int partitionId;
            private ShardGetStream getStream;
            private long getCount = 0L;
            private long dupCount = 0L;
            private final Set<byte[]> keys = new TreeSet<byte[]>(BulkGetIterator.access$2500());
            private final int threshold;

            PartitionValues(int pid, int partitionThreshold) {
                this.partitionId = pid;
                this.threshold = partitionThreshold;
            }

            void setShardTask(ShardGetStream stream) {
                this.getStream = stream;
            }

            synchronized void put(byte[] key) throws InterruptedException {
                if (this.keys.contains(key)) {
                    ++this.dupCount;
                    return;
                }
                this.keys.add(key);
                this.flush(false);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void flush(boolean force) throws InterruptedException {
                int maxRequestSize = 0x100000;
                String fmt = "Queued Partition %d flushed. Batch size %,d; Total:%,d; Number of keys:%,d; request size:%,d";
                int numKeys = this.keys.size();
                while (force && numKeys > 0 || numKeys >= this.threshold) {
                    int getBatchCount = 0;
                    int requestSize = 0;
                    ArrayList<byte[]> le = new ArrayList<byte[]>();
                    PartitionValues partitionValues = this;
                    synchronized (partitionValues) {
                        Iterator<byte[]> iter = this.keys.iterator();
                        while (iter.hasNext()) {
                            byte[] kvBytes = iter.next();
                            iter.remove();
                            ++getBatchCount;
                            --numKeys;
                            le.add(kvBytes);
                            if ((requestSize += kvBytes.length) <= 0x100000) continue;
                            break;
                        }
                        this.getCount += (long)getBatchCount;
                    }
                    PartitionBatch batch = new PartitionBatch(new PartitionId(this.partitionId), le);
                    this.getStream.add(batch);
                    BulkGetIterator.this.logger.fine(String.format("Queued Partition %d flushed. Batch size %,d; Total:%,d; Number of keys:%,d; request size:%,d", this.partitionId, getBatchCount, this.getCount, this.keys.size(), requestSize));
                }
            }
        }

        public class ShardGetStream
        extends BaseParallelScanIteratorImpl.Stream {
            private final RepGroupId rgId;
            private final ArrayBlockingQueue<PartitionBatch> queuedBatchs;
            private long batchCount;
            private long batchQueueUnderflow;
            private long batchQueueOverflows;
            private int maxBatchRequestRepeated;
            private int batchRequestRepeated;
            private PartitionBatch currentBatch;
            private int resumeParentKeyIndex;
            private byte[] resumeKey;

            ShardGetStream(RepGroupId rgId, int numTaskPartitions) {
                super(BulkGetIterator.this);
                this.batchCount = 0L;
                this.batchQueueUnderflow = 0L;
                this.batchQueueOverflows = 0L;
                this.maxBatchRequestRepeated = 0;
                this.batchRequestRepeated = 0;
                this.currentBatch = null;
                this.resumeParentKeyIndex = -1;
                this.resumeKey = null;
                this.rgId = rgId;
                this.queuedBatchs = new ArrayBlockingQueue(numTaskPartitions * 2);
            }

            void add(PartitionBatch partBatch) throws InterruptedException {
                if (!this.queuedBatchs.offer(partBatch)) {
                    ++this.batchQueueOverflows;
                    this.queuedBatchs.put(partBatch);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void updateDetailedMetrics(long timeInMs, long recordCount) {
                DetailedMetricsImpl dmi;
                String shardName = this.rgId.toString();
                Map map = BulkGetIterator.this.shardMetrics;
                synchronized (map) {
                    dmi = (DetailedMetricsImpl)BulkGetIterator.this.shardMetrics.get(this.rgId);
                    if (dmi == null) {
                        dmi = new DetailedMetricsImpl(shardName, timeInMs, recordCount);
                        BulkGetIterator.this.shardMetrics.put(this.rgId, dmi);
                        return;
                    }
                }
                dmi.inc(timeInMs, recordCount);
            }

            @Override
            protected void setResumeKey(Result result) {
                if (result.hasMoreElements()) {
                    this.resumeParentKeyIndex = this.resumeParentKeyIndex == -1 ? result.getResumeParentKeyIndex() : (this.resumeParentKeyIndex += result.getResumeParentKeyIndex());
                    this.resumeKey = result.getPrimaryResumeKey();
                } else {
                    this.resetResumeKey();
                }
            }

            @Override
            protected Request makeReadRequest() {
                List<byte[]> keys;
                if (this.resumeParentKeyIndex == -1) {
                    if (this.currentBatch == null) {
                        this.currentBatch = this.getPartitionBatch();
                        if (this.currentBatch == null) {
                            return null;
                        }
                    }
                    keys = this.currentBatch.entries;
                    ++this.batchCount;
                    this.logMaxBatchRequestRepeated();
                } else {
                    List<byte[]> batchKeys = this.currentBatch.entries;
                    keys = batchKeys.subList(this.resumeParentKeyIndex, batchKeys.size());
                    ++this.batchRequestRepeated;
                }
                InternalOperation op = BulkGetIterator.this.generateBulkGetOp(keys, this.resumeKey);
                return BulkGetIterator.this.storeImpl.makeReadRequest(op, this.currentBatch.pid, BulkGetIterator.this.consistency, BulkGetIterator.this.timeout, BulkGetIterator.this.timeoutUnit);
            }

            @Override
            protected boolean hasMoreElements(Result result) {
                if (result.hasMoreElements()) {
                    return true;
                }
                this.currentBatch = this.getPartitionBatch();
                this.resetResumeKey();
                return this.currentBatch != null;
            }

            public String toString() {
                return "ShardGetStream[" + this.rgId + "]";
            }

            private PartitionBatch getPartitionBatch() {
                try {
                    PartitionBatch pbatch = this.queuedBatchs.poll();
                    if (pbatch == null) {
                        ++this.batchQueueUnderflow;
                        pbatch = this.queuedBatchs.take();
                    }
                    if (pbatch == BulkGetIterator.this.partitionBatchEOF) {
                        return null;
                    }
                    return pbatch;
                }
                catch (InterruptedException ie) {
                    BulkGetIterator.this.logger.info(Thread.currentThread() + " caught " + ie);
                    Thread.currentThread().interrupt();
                    return null;
                }
            }

            private void resetResumeKey() {
                this.resumeParentKeyIndex = -1;
                this.resumeKey = null;
            }

            long getBatchCount() {
                return this.batchCount;
            }

            long getBatchQueueUnderflow() {
                return this.batchQueueUnderflow;
            }

            long getBatchQueueOverflow() {
                return this.batchQueueOverflows;
            }

            int getMaxBatchRequestRepeated() {
                this.logMaxBatchRequestRepeated();
                return this.maxBatchRequestRepeated;
            }

            void setEOFPartitionBatch() throws InterruptedException {
                this.add(BulkGetIterator.this.partitionBatchEOF);
            }

            private void logMaxBatchRequestRepeated() {
                if (this.batchRequestRepeated == 0) {
                    return;
                }
                if (this.batchRequestRepeated > this.maxBatchRequestRepeated) {
                    this.maxBatchRequestRepeated = this.batchRequestRepeated;
                }
                this.batchRequestRepeated = 0;
            }
        }

        private class PartitionBatch {
            final PartitionId pid;
            final List<byte[]> entries;

            PartitionBatch(PartitionId pid, List<byte[]> entries) {
                this.pid = pid;
                this.entries = entries;
            }
        }

        private class KeysReader
        implements Callable<Integer> {
            private final Iterator<K> keyIterator;
            private volatile int readCount = 0;

            KeysReader(Iterator<K> keyIterator) {
                this.keyIterator = keyIterator;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer call() throws Exception {
                KeySerializer serializer = BulkGetIterator.this.storeImpl.getKeySerializer();
                BulkGetIterator.this.logger.info("Started keys reader");
                try {
                    while (this.keyIterator.hasNext()) {
                        Object k = this.keyIterator.next();
                        if (k == null) {
                            throw new IllegalArgumentException("The parent key should not be null");
                        }
                        BulkGetIterator.this.validateKey(k);
                        ++this.readCount;
                        Key key = BulkGetIterator.this.getKey(k);
                        byte[] bytes = serializer.toByteArray(key);
                        PartitionId pid = BulkGetIterator.this.topology.getPartitionId(bytes);
                        BulkGetIterator.this.pMap[pid.getPartitionId()].put(bytes);
                    }
                }
                catch (IllegalArgumentException iae) {
                    BulkGetIterator.this.close(iae);
                }
                finally {
                    BulkGetIterator.this.logger.info("Finished keys reader");
                }
                return this.readCount;
            }

            public int getReadCount() {
                return this.readCount;
            }
        }
    }
}

