/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.hadoop.table;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import oracle.kv.Consistency;
import oracle.kv.Direction;
import oracle.kv.KVStoreException;
import oracle.kv.ParamConstant;
import oracle.kv.PasswordCredentials;
import oracle.kv.hadoop.table.TableInputSplit;
import oracle.kv.impl.security.PasswordManager;
import oracle.kv.impl.security.PasswordStore;
import oracle.kv.impl.security.login.RepNodeLoginManager;
import oracle.kv.impl.security.util.KVStoreLogin;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.topo.split.SplitBuilder;
import oracle.kv.impl.topo.split.TopoSplit;
import oracle.kv.impl.util.ExternalDataSourceUtils;
import oracle.kv.impl.util.TopologyLocator;
import oracle.kv.impl.util.registry.ClientSocketFactory;
import oracle.kv.impl.util.registry.RegistryUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;

abstract class TableInputFormatBase<K, V>
extends InputFormat<K, V> {
    private static final Log LOG = LogFactory.getLog((String)"oracle.kv.hadoop.table.TableInputFormatBase");
    private static final String FILE_SEP = System.getProperty("file.separator");
    private static final String USER_SECURITY_DIR = System.getProperty("user.dir") + FILE_SEP + "TABLE_INPUT_FORMAT_SECURITY_DIR";
    private static String kvStoreName = null;
    private static String[] kvHelperHosts = null;
    private static String[] kvHadoopHosts = null;
    private static String tableName = null;
    private static String primaryKeyProperty = null;
    private static String fieldRangeProperty = null;
    private static Direction direction = Direction.UNORDERED;
    private static Consistency consistency = null;
    private static long timeout = 0L;
    private static TimeUnit timeoutUnit = TimeUnit.MILLISECONDS;
    private static int maxRequests = 0;
    private static int batchSize = 0;
    private static int maxBatches = 0;
    private static String loginFlnm = null;
    private static PasswordCredentials passwordCredentials = null;
    private static String trustFlnm = null;
    private static String localLoginFile = null;
    private static int queryBy = 0;
    private static String whereClause = null;
    private static Integer shardKeyPartitionId = null;

    protected TableInputFormatBase() {
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        Topology topology;
        if (context != null) {
            Configuration conf = context.getConfiguration();
            this.initializeParameters(conf);
        }
        if (kvStoreName == null) {
            throw new IllegalArgumentException("No KV Store Name provided. Use either the " + ParamConstant.KVSTORE_NAME.getName() + " parameter or call " + TableInputFormatBase.class.getName() + ".setKVStoreName().");
        }
        if (kvHelperHosts == null) {
            throw new IllegalArgumentException("No KV Helper Hosts were provided. Use either the " + ParamConstant.KVSTORE_NODES.getName() + " parameter or call " + TableInputFormatBase.class.getName() + ".setKVHelperHosts().");
        }
        if (kvHadoopHosts == null) {
            kvHadoopHosts = new String[kvHelperHosts.length];
            for (int i = 0; i < kvHelperHosts.length; ++i) {
                String[] hostPort = kvHelperHosts[i].trim().split(":");
                TableInputFormatBase.kvHadoopHosts[i] = hostPort[0];
            }
        }
        if (tableName == null) {
            throw new IllegalArgumentException("No Table Name provided. Use either the " + ParamConstant.TABLE_NAME.getName() + " parameter or call " + TableInputFormatBase.class.getName() + ".setTableName().");
        }
        String userName = passwordCredentials == null ? null : passwordCredentials.getUsername();
        KVStoreLogin storeLogin = new KVStoreLogin(userName, localLoginFile);
        storeLogin.loadSecurityProperties();
        storeLogin.prepareRegistryCSF();
        RepNodeLoginManager loginMgr = null;
        if (storeLogin.foundSSLTransport()) {
            loginMgr = KVStoreLogin.getRepNodeLoginMgr(kvHelperHosts, passwordCredentials, kvStoreName);
        }
        try {
            topology = TopologyLocator.get(kvHelperHosts, 0, loginMgr, kvStoreName);
        }
        catch (KVStoreException e) {
            if (passwordCredentials != null) {
                LOG.debug((Object)"Failure on topology retrieval: attempt to communicate with RMI registry over SSL unsuccessful. Changing from SSLClientSocketFactory to ClientSocketFactory and retrying ...");
                ClientSocketFactory.setRMIPolicy(null, kvStoreName);
                RegistryUtils.initRegistryCSF();
                try {
                    topology = TopologyLocator.get(kvHelperHosts, 0, null, kvStoreName);
                }
                catch (KVStoreException e1) {
                    e1.printStackTrace();
                    throw new IOException(e1);
                }
            }
            e.printStackTrace();
            throw new IOException(e);
        }
        List<TopoSplitWrapper> splits = this.getSplitInfo(topology, consistency, queryBy, shardKeyPartitionId);
        ArrayList<InputSplit> ret = new ArrayList<InputSplit>(splits.size());
        for (TopoSplitWrapper ts : splits) {
            TableInputSplit split = new TableInputSplit();
            split.setKVStoreName(kvStoreName);
            split.setKVHelperHosts(kvHelperHosts);
            split.setLocations(kvHadoopHosts);
            split.setTableName(tableName);
            split.setKVStoreSecurity(loginFlnm, passwordCredentials, trustFlnm);
            split.setPrimaryKeyProperty(primaryKeyProperty);
            split.setFieldRangeProperty(fieldRangeProperty);
            split.setDirection(direction);
            split.setConsistency(consistency);
            split.setTimeout(timeout);
            split.setTimeoutUnit(timeoutUnit);
            split.setMaxRequests(maxRequests);
            split.setBatchSize(batchSize);
            split.setMaxBatches(maxBatches);
            split.setPartitionSets(ts.getPartitionSets());
            split.setQueryInfo(queryBy, whereClause);
            split.setShardSet(ts.getShardSet());
            ret.add(split);
        }
        return ret;
    }

    public static void setKVStoreName(String newStoreName) {
        kvStoreName = newStoreName;
    }

    public static void setKVHelperHosts(String[] newHelperHosts) {
        kvHelperHosts = newHelperHosts;
    }

    public static void setKVHadoopHosts(String[] newHadoopHosts) {
        kvHadoopHosts = newHadoopHosts;
    }

    public static void setTableName(String newTableName) {
        tableName = newTableName;
    }

    public static void setPrimaryKeyProperty(String newProperty) {
        primaryKeyProperty = newProperty;
    }

    public static void setFieldRangeProperty(String newProperty) {
        fieldRangeProperty = newProperty;
    }

    public static void setDirection(Direction newDirection) {
        direction = newDirection;
    }

    public static void setConsistency(Consistency consistency) {
        if (consistency != Consistency.ABSOLUTE && consistency != Consistency.NONE_REQUIRED_NO_MASTER && consistency != Consistency.NONE_REQUIRED && consistency != null) {
            throw new IllegalArgumentException("Consistency may only be ABSOLUTE, NONE_REQUIRED_NO_MASTER, or NONE_REQUIRED");
        }
        TableInputFormatBase.consistency = consistency;
    }

    public static void setTimeout(long timeout) {
        TableInputFormatBase.timeout = timeout;
    }

    public static void setTimeoutUnit(TimeUnit timeoutUnit) {
        TableInputFormatBase.timeoutUnit = timeoutUnit;
    }

    public static void setMaxRequests(int newMaxRequests) {
        maxRequests = newMaxRequests;
    }

    public static void setBatchSize(int batchSize) {
        TableInputFormatBase.batchSize = batchSize;
    }

    public static void setMaxBatches(int newMaxBatches) {
        maxBatches = newMaxBatches;
    }

    public static void setKVSecurity(String loginFile, PasswordCredentials userPasswordCredentials, String trustFile) throws IOException {
        TableInputFormatBase.setLocalKVSecurity(loginFile, userPasswordCredentials, trustFile);
    }

    private void initializeParameters(Configuration conf) throws IOException {
        if (conf != null) {
            String maxBatchesStr;
            String batchSizeStr;
            String maxRequestsStr;
            String timeoutParamName;
            String timeoutStr;
            String consistencyStr;
            String fieldRangeProp;
            String primaryKeyProp;
            String hadoopHosts;
            String helperHosts;
            String kvStoreNameProp = conf.get(ParamConstant.KVSTORE_NAME.getName());
            if (kvStoreNameProp != null) {
                kvStoreName = kvStoreNameProp;
            }
            if ((helperHosts = conf.get(ParamConstant.KVSTORE_NODES.getName())) != null) {
                kvHelperHosts = helperHosts.trim().split(",");
            }
            if ((hadoopHosts = conf.get(ParamConstant.KVHADOOP_NODES.getName())) != null) {
                kvHadoopHosts = hadoopHosts.trim().split(",");
            } else if (kvHelperHosts != null) {
                kvHadoopHosts = new String[kvHelperHosts.length];
                for (int i = 0; i < kvHelperHosts.length; ++i) {
                    String[] hostPort = kvHelperHosts[i].trim().split(":");
                    TableInputFormatBase.kvHadoopHosts[i] = hostPort[0];
                }
            }
            String tableNameProp = conf.get(ParamConstant.TABLE_NAME.getName());
            if (tableNameProp != null) {
                tableName = tableNameProp;
            }
            if ((primaryKeyProp = conf.get(ParamConstant.PRIMARY_KEY.getName())) != null) {
                primaryKeyProperty = primaryKeyProp;
            }
            if ((fieldRangeProp = conf.get(ParamConstant.FIELD_RANGE.getName())) != null) {
                fieldRangeProperty = fieldRangeProp;
            }
            if ((consistencyStr = conf.get(ParamConstant.CONSISTENCY.getName())) != null) {
                consistency = ExternalDataSourceUtils.parseConsistency(consistencyStr);
            }
            if ((timeoutStr = conf.get(timeoutParamName = ParamConstant.TIMEOUT.getName())) != null) {
                timeout = ExternalDataSourceUtils.parseTimeout(timeoutStr);
                timeoutUnit = TimeUnit.MILLISECONDS;
            }
            if ((maxRequestsStr = conf.get(ParamConstant.MAX_REQUESTS.getName())) != null) {
                try {
                    maxRequests = Integer.parseInt(maxRequestsStr);
                }
                catch (NumberFormatException NFE) {
                    throw new IllegalArgumentException("Invalid value for " + ParamConstant.MAX_REQUESTS.getName() + ": " + maxRequestsStr);
                }
            }
            if ((batchSizeStr = conf.get(ParamConstant.BATCH_SIZE.getName())) != null) {
                try {
                    batchSize = Integer.parseInt(batchSizeStr);
                }
                catch (NumberFormatException NFE) {
                    throw new IllegalArgumentException("Invalid value for " + ParamConstant.BATCH_SIZE.getName() + ": " + batchSizeStr);
                }
            }
            if ((maxBatchesStr = conf.get(ParamConstant.MAX_BATCHES.getName())) != null) {
                try {
                    maxBatches = Integer.parseInt(maxBatchesStr);
                }
                catch (NumberFormatException NFE) {
                    throw new IllegalArgumentException("Invalid value for " + ParamConstant.MAX_BATCHES.getName() + ": " + maxBatchesStr);
                }
            }
            String loginFile = conf.get("oracle.kv.security");
            String trustFile = conf.get("oracle.kv.ssl.trustStore");
            String username = conf.get("oracle.kv.auth.username");
            String passwordStr = conf.get(ParamConstant.AUTH_USER_PWD_PROPERTY.getName());
            PasswordCredentials passwordCreds = null;
            if (username != null && passwordStr != null) {
                char[] userPassword = passwordStr.toCharArray();
                passwordCreds = new PasswordCredentials(username, userPassword);
            }
            if (passwordCreds == null) {
                String passwordLoc = conf.get("oracle.kv.auth.wallet.dir");
                PasswordManager storeMgr = null;
                if (passwordLoc != null) {
                    char[] userPassword;
                    File walletDirFd = new File(passwordLoc);
                    try {
                        storeMgr = PasswordManager.load("oracle.kv.impl.security.wallet.WalletManager");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new IOException(e);
                    }
                    PasswordStore fileStore = storeMgr.getStoreHandle(walletDirFd);
                    fileStore.open(null);
                    Collection<String> secretAliases = fileStore.getSecretAliases();
                    Iterator<String> aliasItr = secretAliases.iterator();
                    char[] cArray = userPassword = aliasItr.hasNext() ? fileStore.getSecret(aliasItr.next()) : null;
                    if (username != null) {
                        passwordCreds = new PasswordCredentials(username, userPassword);
                    }
                    fileStore.discard();
                } else {
                    passwordLoc = conf.get("oracle.kv.auth.pwdfile.file");
                    if (passwordLoc != null) {
                        char[] userPassword;
                        File passwordFileFd = new File(passwordLoc);
                        try {
                            storeMgr = PasswordManager.load("oracle.kv.impl.security.filestore.FileStoreManager");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new IOException(e);
                        }
                        PasswordStore fileStore = storeMgr.getStoreHandle(passwordFileFd);
                        fileStore.open(null);
                        Collection<String> secretAliases = fileStore.getSecretAliases();
                        Iterator<String> aliasItr = secretAliases.iterator();
                        char[] cArray = userPassword = aliasItr.hasNext() ? fileStore.getSecret(aliasItr.next()) : null;
                        if (username != null) {
                            passwordCreds = new PasswordCredentials(username, userPassword);
                        }
                        fileStore.discard();
                    }
                }
            }
            TableInputFormatBase.setLocalKVSecurity(loginFile, passwordCreds, trustFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setLocalKVSecurity(String loginFile, PasswordCredentials userPasswordCredentials, String trustFile) throws IOException {
        if (loginFile == null) {
            return;
        }
        if (userPasswordCredentials == null) {
            return;
        }
        if (trustFile == null) {
            return;
        }
        File loginFd = new File(loginFile);
        boolean loginIsAbsolute = false;
        if (loginFd.isAbsolute()) {
            loginIsAbsolute = true;
            localLoginFile = loginFile;
            loginFlnm = loginFd.getName();
        } else {
            loginFlnm = loginFile;
        }
        passwordCredentials = userPasswordCredentials;
        File trustFd = new File(trustFile);
        boolean trustIsAbsolute = false;
        if (trustFd.isAbsolute()) {
            trustIsAbsolute = true;
            trustFlnm = trustFd.getName();
        } else {
            trustFlnm = trustFile;
        }
        if (loginIsAbsolute && trustIsAbsolute) {
            return;
        }
        File userSecurityDirFd = new File(USER_SECURITY_DIR);
        if (!userSecurityDirFd.exists() && !userSecurityDirFd.mkdirs()) {
            throw new IOException("failed to create " + userSecurityDirFd);
        }
        ClassLoader cl = TableInputFormatBase.class.getClassLoader();
        if (!loginIsAbsolute) {
            File trustPropFd;
            InputStream loginStream = null;
            loginStream = cl != null ? cl.getResourceAsStream(loginFlnm) : ClassLoader.getSystemResourceAsStream(loginFlnm);
            Properties loginProps = new Properties();
            if (loginStream != null) {
                loginProps.load(loginStream);
            }
            loginProps.remove("oracle.kv.auth.username");
            loginProps.remove("oracle.kv.auth.wallet.dir");
            loginProps.remove("oracle.kv.auth.pwdfile.file");
            String trustProp = loginProps.getProperty("oracle.kv.ssl.trustStore");
            if (trustProp != null && !(trustPropFd = new File(trustProp)).exists()) {
                loginProps.setProperty("oracle.kv.ssl.trustStore", trustPropFd.getName());
            }
            File absoluteLoginFd = new File(USER_SECURITY_DIR + FILE_SEP + loginFlnm);
            FileOutputStream loginFos = new FileOutputStream(absoluteLoginFd);
            try {
                loginProps.store(loginFos, null);
            }
            finally {
                loginFos.close();
            }
            localLoginFile = absoluteLoginFd.toString();
        }
        if (!trustIsAbsolute) {
            InputStream trustStream = null;
            trustStream = cl != null ? cl.getResourceAsStream(trustFlnm) : ClassLoader.getSystemResourceAsStream(trustFlnm);
            File absoluteTrustFd = new File(USER_SECURITY_DIR + FILE_SEP + trustFlnm);
            FileOutputStream trustFlnmFos = new FileOutputStream(absoluteTrustFd);
            try {
                int nextByte = trustStream.read();
                while (nextByte != -1) {
                    trustFlnmFos.write(nextByte);
                    nextByte = trustStream.read();
                }
            }
            finally {
                trustFlnmFos.close();
            }
        }
    }

    public void setQueryInfo(int newQueryBy, String newWhereClause, Integer newPartitionId) {
        queryBy = newQueryBy;
        whereClause = newWhereClause;
        shardKeyPartitionId = newPartitionId;
    }

    private List<TopoSplitWrapper> getSplitInfo(Topology topology, Consistency readConsistency, int whereQueryBy, Integer singlePartitionId) {
        ArrayList<TopoSplitWrapper> retList = new ArrayList<TopoSplitWrapper>();
        if (topology == null) {
            return retList;
        }
        boolean buildSplits = false;
        boolean singleSplit = false;
        int singleId = 1;
        switch (whereQueryBy) {
            case 0: 
            case 3: {
                buildSplits = true;
                break;
            }
            case 1: 
            case 4: {
                if (singlePartitionId == null) {
                    buildSplits = true;
                    break;
                }
                singleSplit = true;
                singleId = singlePartitionId;
                break;
            }
        }
        if (buildSplits) {
            SplitBuilder sb = new SplitBuilder(topology);
            List<TopoSplit> topoSplits = sb.createShardSplits(readConsistency);
            for (TopoSplit topoSplit : topoSplits) {
                HashSet<RepGroupId> shardSet = new HashSet<RepGroupId>();
                List<Set<Integer>> partitionSets = topoSplit.getPartitionSets();
                for (Set<Integer> partitionIds : partitionSets) {
                    for (Integer pId : partitionIds) {
                        PartitionId partitionId = new PartitionId(pId);
                        RepGroupId repGroupId = topology.getRepGroupId(partitionId);
                        shardSet.add(repGroupId);
                    }
                }
                retList.add(new TopoSplitWrapper(topoSplit, shardSet));
            }
            return retList;
        }
        if (singleSplit) {
            HashSet<Integer> partitionSet = new HashSet<Integer>();
            partitionSet.add(singlePartitionId);
            HashSet<RepGroupId> shardSet = new HashSet<RepGroupId>();
            shardSet.add(topology.getRepGroupId(new PartitionId(singleId)));
            retList.add(new TopoSplitWrapper(new TopoSplit(0, partitionSet), shardSet));
            return retList;
        }
        Set<RepGroupId> shardIds = topology.getRepGroupIds();
        for (RepGroupId shardId : shardIds) {
            HashSet<RepGroupId> shardSet = new HashSet<RepGroupId>();
            shardSet.add(shardId);
            retList.add(new TopoSplitWrapper(null, shardSet));
        }
        return retList;
    }

    private static class TopoSplitWrapper {
        private final TopoSplit topoSplit;
        private final Set<RepGroupId> shardSet;

        TopoSplitWrapper(TopoSplit topoSplit, Set<RepGroupId> shardSet) {
            this.topoSplit = topoSplit;
            this.shardSet = shardSet;
        }

        List<Set<Integer>> getPartitionSets() {
            if (this.topoSplit != null) {
                return this.topoSplit.getPartitionSets();
            }
            return Collections.emptyList();
        }

        Set<RepGroupId> getShardSet() {
            if (this.shardSet != null) {
                return this.shardSet;
            }
            return Collections.emptySet();
        }
    }
}

