/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.hadoop.hive.table;

import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import oracle.kv.Consistency;
import oracle.kv.Direction;
import oracle.kv.ParamConstant;
import oracle.kv.hadoop.hive.table.TableHiveInputFormat;
import oracle.kv.hadoop.hive.table.TableSerDe;
import oracle.kv.impl.security.PasswordManager;
import oracle.kv.impl.security.PasswordStore;
import oracle.kv.impl.util.ExternalDataSourceUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.index.IndexPredicateAnalyzer;
import org.apache.hadoop.hive.ql.index.IndexSearchCondition;
import org.apache.hadoop.hive.ql.metadata.DefaultStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveStoragePredicateHandler;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.JobConf;

abstract class TableStorageHandlerBase<K extends WritableComparable<?>, V extends Writable>
extends DefaultStorageHandler
implements HiveStoragePredicateHandler {
    private static final Log LOG = LogFactory.getLog((String)"oracle.kv.hadoop.hive.table.TableStorageHandlerBase");
    protected String kvStoreName = null;
    protected String[] kvHelperHosts = null;
    protected String[] kvHadoopHosts = null;
    protected String tableName = null;
    protected String primaryKeyProperty = null;
    protected String fieldRangeProperty = null;
    protected Direction direction = Direction.UNORDERED;
    protected Consistency consistency = null;
    protected long timeout = 0L;
    protected TimeUnit timeoutUnit = TimeUnit.MILLISECONDS;
    protected int maxRequests = 0;
    protected int batchSize = 0;
    protected int maxBatches = 0;
    protected JobConf jobConf = new JobConf();

    protected TableStorageHandlerBase() {
    }

    public void configureInputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        this.configureJobProperties(tableDesc, jobProperties);
    }

    public void configureOutputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        this.configureJobProperties(tableDesc, jobProperties);
    }

    public void configureTableJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        this.configureJobProperties(tableDesc, jobProperties);
    }

    private void configureJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        Properties tableProperties = tableDesc.getProperties();
        this.kvStoreName = tableProperties.getProperty(ParamConstant.KVSTORE_NAME.getName());
        if (this.kvStoreName == null) {
            throw new IllegalArgumentException("No KV Store Name provided via the '" + ParamConstant.KVSTORE_NAME.getName() + "' property in the " + "TBLPROPERTIES clause.");
        }
        LOG.debug((Object)("kvStoreName = " + this.kvStoreName));
        jobProperties.put(ParamConstant.KVSTORE_NAME.getName(), this.kvStoreName);
        this.jobConf.set(ParamConstant.KVSTORE_NAME.getName(), this.kvStoreName);
        String kvHelperHostsStr = tableProperties.getProperty(ParamConstant.KVSTORE_NODES.getName());
        if (kvHelperHostsStr == null) {
            throw new IllegalArgumentException("No comma-separated list of hostname:port pairs (KV Helper Hosts) provided via the '" + ParamConstant.KVSTORE_NODES.getName() + "' property in the " + "TBLPROPERTIES clause.");
        }
        this.kvHelperHosts = kvHelperHostsStr.trim().split(",");
        jobProperties.put(ParamConstant.KVSTORE_NODES.getName(), kvHelperHostsStr);
        this.jobConf.set(ParamConstant.KVSTORE_NODES.getName(), kvHelperHostsStr);
        LOG.debug((Object)("kvHelperHosts = " + kvHelperHostsStr));
        String kvHadoopHostsStr = tableProperties.getProperty(ParamConstant.KVHADOOP_NODES.getName());
        if (kvHadoopHostsStr != null) {
            this.kvHadoopHosts = kvHadoopHostsStr.trim().split(",");
        } else {
            this.kvHadoopHosts = new String[this.kvHelperHosts.length];
            StringBuilder hadoopBuf = new StringBuilder();
            for (int i = 0; i < this.kvHelperHosts.length; ++i) {
                String[] hostPort = this.kvHelperHosts[i].trim().split(":");
                this.kvHadoopHosts[i] = hostPort[0];
                if (i != 0) {
                    hadoopBuf.append(",");
                }
                hadoopBuf.append(this.kvHadoopHosts[i]);
            }
            kvHadoopHostsStr = hadoopBuf.toString();
        }
        jobProperties.put(ParamConstant.KVHADOOP_NODES.getName(), kvHadoopHostsStr);
        this.jobConf.set(ParamConstant.KVHADOOP_NODES.getName(), kvHadoopHostsStr);
        LOG.debug((Object)("kvHadoopHosts = " + kvHadoopHostsStr));
        this.tableName = tableProperties.getProperty(ParamConstant.TABLE_NAME.getName());
        if (this.tableName == null) {
            throw new IllegalArgumentException("No KV Store Table Name provided via the '" + ParamConstant.TABLE_NAME.getName() + "' property in the " + "TBLPROPERTIES clause.");
        }
        jobProperties.put(ParamConstant.TABLE_NAME.getName(), this.tableName);
        this.jobConf.set(ParamConstant.TABLE_NAME.getName(), this.tableName);
        LOG.debug((Object)("tableName = " + this.tableName));
        this.primaryKeyProperty = tableProperties.getProperty(ParamConstant.PRIMARY_KEY.getName());
        if (this.primaryKeyProperty != null) {
            jobProperties.put(ParamConstant.PRIMARY_KEY.getName(), this.primaryKeyProperty);
            this.jobConf.set(ParamConstant.PRIMARY_KEY.getName(), this.primaryKeyProperty);
        }
        LOG.trace((Object)("primaryKeyProperty = " + this.primaryKeyProperty));
        this.fieldRangeProperty = tableProperties.getProperty(ParamConstant.FIELD_RANGE.getName());
        if (this.fieldRangeProperty != null) {
            jobProperties.put(ParamConstant.FIELD_RANGE.getName(), this.fieldRangeProperty);
            this.jobConf.set(ParamConstant.FIELD_RANGE.getName(), this.fieldRangeProperty);
        }
        LOG.trace((Object)("fieldRangeProperty = " + this.fieldRangeProperty));
        String consistencyStr = tableProperties.getProperty(ParamConstant.CONSISTENCY.getName());
        if (consistencyStr != null) {
            this.consistency = ExternalDataSourceUtils.parseConsistency(consistencyStr);
            jobProperties.put(ParamConstant.CONSISTENCY.getName(), consistencyStr);
            this.jobConf.set(ParamConstant.CONSISTENCY.getName(), consistencyStr);
        }
        LOG.trace((Object)("consistency = " + consistencyStr));
        String timeoutStr = tableProperties.getProperty(ParamConstant.TIMEOUT.getName());
        if (timeoutStr != null) {
            this.timeout = ExternalDataSourceUtils.parseTimeout(timeoutStr);
            this.timeoutUnit = TimeUnit.MILLISECONDS;
            jobProperties.put(ParamConstant.TIMEOUT.getName(), timeoutStr);
            this.jobConf.set(ParamConstant.TIMEOUT.getName(), timeoutStr);
        }
        LOG.trace((Object)("timeout = " + this.timeout));
        String maxRequestsStr = tableProperties.getProperty(ParamConstant.MAX_REQUESTS.getName());
        if (maxRequestsStr != null) {
            try {
                this.maxRequests = Integer.parseInt(maxRequestsStr);
                jobProperties.put(ParamConstant.MAX_REQUESTS.getName(), maxRequestsStr);
                this.jobConf.set(ParamConstant.MAX_REQUESTS.getName(), maxRequestsStr);
            }
            catch (NumberFormatException NFE) {
                LOG.warn((Object)("Invalid value for " + ParamConstant.MAX_REQUESTS.getName() + " [" + maxRequestsStr + "]: proceeding with value determined " + "by system"));
            }
        }
        LOG.trace((Object)("maxRequests = " + this.maxRequests));
        String batchSizeStr = tableProperties.getProperty(ParamConstant.BATCH_SIZE.getName());
        if (batchSizeStr != null) {
            try {
                this.batchSize = Integer.parseInt(batchSizeStr);
                jobProperties.put(ParamConstant.BATCH_SIZE.getName(), batchSizeStr);
                this.jobConf.set(ParamConstant.BATCH_SIZE.getName(), batchSizeStr);
            }
            catch (NumberFormatException NFE) {
                LOG.warn((Object)("Invalid value for " + ParamConstant.BATCH_SIZE.getName() + " [" + batchSizeStr + "]: proceeding with value determined " + "by system"));
            }
        }
        LOG.trace((Object)("batchSize = " + this.batchSize));
        String maxBatchesStr = tableProperties.getProperty(ParamConstant.MAX_BATCHES.getName());
        if (maxBatchesStr != null) {
            try {
                this.maxBatches = Integer.parseInt(maxBatchesStr);
                jobProperties.put(ParamConstant.MAX_BATCHES.getName(), maxBatchesStr);
                this.jobConf.set(ParamConstant.MAX_BATCHES.getName(), maxBatchesStr);
            }
            catch (NumberFormatException NFE) {
                LOG.warn((Object)("Invalid value for " + ParamConstant.MAX_BATCHES.getName() + " [" + maxBatchesStr + "]: proceeding with value determined " + "by system"));
            }
        }
        LOG.trace((Object)("maxBatches = " + this.maxBatches));
        this.configureKVSecurityProperties(tableProperties, jobProperties);
        this.setConf(new Configuration((Configuration)this.jobConf));
    }

    private void configureKVSecurityProperties(Properties tblProperties, Map<String, String> jobProperties) {
        String username;
        String trustFile;
        String loginFile = tblProperties.getProperty("oracle.kv.security");
        if (loginFile != null) {
            jobProperties.put("oracle.kv.security", loginFile);
            this.jobConf.set("oracle.kv.security", loginFile);
        }
        if ((trustFile = tblProperties.getProperty("oracle.kv.ssl.trustStore")) != null) {
            jobProperties.put("oracle.kv.ssl.trustStore", trustFile);
            this.jobConf.set("oracle.kv.ssl.trustStore", trustFile);
        }
        if ((username = tblProperties.getProperty("oracle.kv.auth.username")) != null) {
            jobProperties.put("oracle.kv.auth.username", username);
            this.jobConf.set("oracle.kv.auth.username", username);
        }
        Integer passwordOrWallet = null;
        String passwordLocProp = "oracle.kv.auth.wallet.dir";
        String passwordLoc = tblProperties.getProperty(passwordLocProp);
        if (passwordLoc != null) {
            passwordOrWallet = 1;
        } else {
            passwordLocProp = "oracle.kv.auth.pwdfile.file";
            passwordLoc = tblProperties.getProperty(passwordLocProp);
            if (passwordLoc != null) {
                passwordOrWallet = 0;
            }
        }
        if (passwordLoc != null) {
            jobProperties.put(passwordLocProp, passwordLoc);
            this.jobConf.set(passwordLocProp, passwordLoc);
            PasswordStore passwordStore = null;
            if (passwordOrWallet != null) {
                PasswordManager storeMgr = null;
                if (passwordOrWallet == 1) {
                    File walletDirFd = new File(passwordLoc);
                    if (walletDirFd.exists()) {
                        try {
                            storeMgr = PasswordManager.load("oracle.kv.impl.security.wallet.WalletManager");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new SecurityException(e);
                        }
                        passwordStore = storeMgr.getStoreHandle(walletDirFd);
                    }
                } else {
                    File passwordFileFd = new File(passwordLoc);
                    if (passwordFileFd.exists()) {
                        try {
                            storeMgr = PasswordManager.load("oracle.kv.impl.security.filestore.FileStoreManager");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new SecurityException(e);
                        }
                        passwordStore = storeMgr.getStoreHandle(passwordFileFd);
                    }
                }
            }
            if (passwordStore != null) {
                try {
                    passwordStore.open(null);
                    Collection<String> secretAliases = passwordStore.getSecretAliases();
                    Iterator<String> aliasItr = secretAliases.iterator();
                    char[] userPassword = aliasItr.hasNext() ? passwordStore.getSecret(aliasItr.next()) : null;
                    String password = String.valueOf(userPassword);
                    tblProperties.put(ParamConstant.AUTH_USER_PWD_PROPERTY.getName(), password);
                    jobProperties.put(ParamConstant.AUTH_USER_PWD_PROPERTY.getName(), password);
                    this.jobConf.set(ParamConstant.AUTH_USER_PWD_PROPERTY.getName(), password);
                }
                catch (IOException e) {
                    throw new SecurityException(e);
                }
                finally {
                    passwordStore.discard();
                }
            }
        }
    }

    public HiveStoragePredicateHandler.DecomposedPredicate decomposePredicate(JobConf jobConfig, Deserializer deserializer, ExprNodeDesc predicate) {
        TableHiveInputFormat.resetQueryInfo();
        HiveStoragePredicateHandler.DecomposedPredicate decomposedPredicate = null;
        IndexPredicateAnalyzer analyzer = TableHiveInputFormat.sargablePredicateAnalyzer(predicate, (TableSerDe)deserializer);
        if (analyzer != null) {
            ArrayList<IndexSearchCondition> searchConditions = new ArrayList<IndexSearchCondition>();
            ExprNodeGenericFuncDesc residualPredicate = (ExprNodeGenericFuncDesc)analyzer.analyzePredicate(predicate, searchConditions);
            decomposedPredicate = new HiveStoragePredicateHandler.DecomposedPredicate();
            decomposedPredicate.pushedPredicate = analyzer.translateSearchConditions(searchConditions);
            decomposedPredicate.residualPredicate = residualPredicate;
            StringBuilder whereBuf = new StringBuilder();
            TableHiveInputFormat.buildPushPredicate((ExprNodeDesc)decomposedPredicate.pushedPredicate, whereBuf);
            String whereStr = whereBuf.toString();
            TableHiveInputFormat.setQueryInfo(searchConditions, (TableSerDe)deserializer, whereStr);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"-----------------------------");
                LOG.debug((Object)("residual = " + decomposedPredicate.residualPredicate));
                LOG.debug((Object)("predicate = " + decomposedPredicate.pushedPredicate));
                LOG.debug((Object)("search conditions = " + searchConditions));
                switch (TableHiveInputFormat.getQueryBy()) {
                    case 2: {
                        LOG.debug((Object)("push predicate to secondary index [WHERE " + whereStr + "]"));
                        break;
                    }
                    case 0: 
                    case 1: {
                        LOG.debug((Object)("push predicate to primary index [WHERE " + whereStr + "]"));
                        break;
                    }
                }
                LOG.debug((Object)"-----------------------------");
            }
        } else {
            TableHiveInputFormat.ExtendedPredicateAnalyzer extendedAnalyzer = TableHiveInputFormat.createPredicateAnalyzerForOnql((TableSerDe)deserializer);
            if (extendedAnalyzer == null) {
                LOG.debug((Object)"extended predicate analyzer = null ... NO PREDICATE PUSHDOWN");
                return null;
            }
            ArrayDeque<ExprNodeDesc> pushPredicateDeque = new ArrayDeque<ExprNodeDesc>();
            ExprNodeGenericFuncDesc residualPredicate = (ExprNodeGenericFuncDesc)extendedAnalyzer.analyzePredicate(predicate, pushPredicateDeque);
            if (LOG.isTraceEnabled()) {
                ExprNodeDesc[] qElements = pushPredicateDeque.toArray(new ExprNodeDesc[pushPredicateDeque.size()]);
                LOG.trace((Object)"-----------------------------");
                LOG.trace((Object)"push predicate queue elements:");
                for (int i = 0; i < qElements.length; ++i) {
                    LOG.trace((Object)("element[" + i + "] = " + qElements[i]));
                }
                LOG.trace((Object)"-----------------------------");
            }
            decomposedPredicate = new HiveStoragePredicateHandler.DecomposedPredicate();
            StringBuilder whereBuf = new StringBuilder();
            decomposedPredicate.residualPredicate = residualPredicate;
            decomposedPredicate.pushedPredicate = extendedAnalyzer.translateSearchConditions(pushPredicateDeque, whereBuf);
            if (decomposedPredicate.pushedPredicate != null) {
                if (LOG.isTraceEnabled()) {
                    TableHiveInputFormat.ExtendedPredicateAnalyzer.displayNodeTree((ExprNodeDesc)decomposedPredicate.pushedPredicate);
                }
                String whereStr = whereBuf.toString();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"-----------------------------");
                    LOG.debug((Object)("residual = " + decomposedPredicate.residualPredicate));
                    LOG.debug((Object)("predicate = " + decomposedPredicate.pushedPredicate));
                    LOG.debug((Object)("push predicate via native query [WHERE " + whereStr + "]"));
                    LOG.debug((Object)"-----------------------------");
                }
                TableHiveInputFormat.setQueryInfo((TableSerDe)deserializer, whereStr);
            } else {
                LOG.debug((Object)"Extended predicate analyzer found no predicate to push. Will use all of residual for filtering.");
            }
        }
        return decomposedPredicate;
    }
}

