/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.hadoop.hive.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.kv.table.FieldValue;
import oracle.kv.table.RecordValue;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;

public class TableRecordObjectInspector
extends StandardStructObjectInspector {
    protected static final String DEFAULT_FIELD_NAME = "";
    private static final List<String> DEFAULT_FIELD_NAME_LIST = new ArrayList<String>();
    private static final List<ObjectInspector> DEFAULT_OI_LIST = new ArrayList<ObjectInspector>();

    TableRecordObjectInspector() {
        super(DEFAULT_FIELD_NAME_LIST, DEFAULT_OI_LIST);
    }

    TableRecordObjectInspector(List<String> structFieldNames, List<ObjectInspector> structFieldObjectInspectors) {
        super(structFieldNames, structFieldObjectInspectors);
    }

    TableRecordObjectInspector(List<String> structFieldNames, List<ObjectInspector> structFieldObjectInspectors, List<String> structFieldComments) {
        super(structFieldNames, structFieldObjectInspectors, structFieldComments);
    }

    public StructField getStructFieldRef(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        return super.getStructFieldRef(fieldName);
    }

    public Object getStructFieldData(Object data, StructField fieldRef) {
        if (data == null || fieldRef == null) {
            return null;
        }
        StandardStructObjectInspector.MyField f = (StandardStructObjectInspector.MyField)fieldRef;
        int fieldID = f.getFieldID();
        assert (fieldID >= 0 && fieldID < this.fields.size());
        if (data instanceof FieldValue) {
            if (((FieldValue)data).isNull()) {
                return null;
            }
            RecordValue recordValue = ((FieldValue)data).asRecord();
            int nFields = recordValue.size();
            if (this.fields.size() != nFields) {
                LOG.warn((Object)("Trying to access " + this.fields.size() + " fields inside a RECORD of " + nFields + " elements: " + recordValue.getFieldNames()));
            }
            if (fieldID >= nFields) {
                return null;
            }
            List<String> recFields = recordValue.getFieldNames();
            int i = 0;
            for (String recFieldName : recFields) {
                if (i == fieldID) {
                    return recordValue.get(recFieldName);
                }
                ++i;
            }
        } else {
            if (data instanceof List) {
                List list = (List)data;
                int nFields = list.size();
                if (this.fields.size() != nFields) {
                    LOG.warn((Object)("Trying to access " + this.fields.size() + " fields inside a LIST of " + nFields + " elements: " + list));
                }
                if (fieldID >= nFields) {
                    return null;
                }
                return list.get(fieldID);
            }
            if (data instanceof Object[]) {
                Object[] arr = (Object[])data;
                int nFields = arr.length;
                if (this.fields.size() != nFields) {
                    LOG.warn((Object)("Trying to access " + this.fields.size() + " fields inside an ARRAY of " + nFields + " elements: " + Arrays.asList(arr)));
                }
                if (fieldID >= nFields) {
                    return null;
                }
                return arr[fieldID];
            }
        }
        throw new IllegalArgumentException("invalid input object: must be Object[], List, or RecordValue");
    }

    public List<Object> getStructFieldsDataAsList(Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof FieldValue) {
            if (((FieldValue)data).isNull()) {
                return null;
            }
            RecordValue recordValue = ((FieldValue)data).asRecord();
            assert (recordValue.size() == this.fields.size());
            ArrayList<Object> list = new ArrayList<Object>();
            for (String recFieldName : recordValue.getFieldNames()) {
                list.add(recordValue.get(recFieldName));
            }
            return list;
        }
        if (data instanceof List) {
            List list = (List)data;
            assert (list.size() == this.fields.size());
            return list;
        }
        if (data instanceof Object[]) {
            Object[] arr = (Object[])data;
            assert (arr.length == this.fields.size());
            return Arrays.asList(arr);
        }
        throw new IllegalArgumentException("invalid input object: must be Object[], List, or RecordValue");
    }

    static {
        DEFAULT_FIELD_NAME_LIST.add(DEFAULT_FIELD_NAME);
        DEFAULT_OI_LIST.add(null);
    }

    protected static class TableStructField
    extends StandardStructObjectInspector.MyField {
        public TableStructField() {
            this(0, TableRecordObjectInspector.DEFAULT_FIELD_NAME, null);
        }

        public TableStructField(int fieldId, String fieldName, ObjectInspector fieldObjectInspector) {
            super(fieldId, fieldName, fieldObjectInspector);
        }

        public TableStructField(int fieldId, String fieldName, ObjectInspector fieldObjectInspector, String fieldComment) {
            super(fieldId, fieldName, fieldObjectInspector, fieldComment);
        }
    }
}

