/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Properties;

public class KVVersion
implements Comparable<KVVersion>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final KVVersion R1_2_123 = new KVVersion(11, 2, 1, 2, 123, null);
    public static final KVVersion R2_0_23 = new KVVersion(11, 2, 2, 0, 23, null);
    public static final KVVersion R2_1_0 = new KVVersion(12, 1, 2, 1, 0, null);
    public static final KVVersion R2_1 = new KVVersion(12, 1, 2, 1, 8, null);
    public static final KVVersion R3_0 = new KVVersion(12, 1, 3, 0, 5, null);
    public static final KVVersion R3_1 = new KVVersion(12, 1, 3, 1, 0, null);
    public static final KVVersion R3_2 = new KVVersion(12, 1, 3, 2, 0, null);
    public static final KVVersion R3_3 = new KVVersion(12, 1, 3, 3, 4, null);
    public static final KVVersion R3_4 = new KVVersion(12, 1, 3, 4, 7, null);
    public static final KVVersion R3_5 = new KVVersion(12, 1, 3, 5, 2, null);
    public static final KVVersion R4_0 = new KVVersion(12, 1, 4, 0, 9, null);
    public static final KVVersion R4_1 = new KVVersion(12, 1, 4, 1, 7, null);
    public static final KVVersion R4_2 = new KVVersion(12, 1, 4, 2, 14, null);
    public static final KVVersion R4_3 = new KVVersion(12, 1, 4, 3, 11, null);
    public static final KVVersion R4_4;
    public static final KVVersion CURRENT_VERSION;
    public static final KVVersion PREREQUISITE_VERSION;
    private final int oracleMajor;
    private final int oracleMinor;
    private final int majorNum;
    private final int minorNum;
    private final int patchNum;
    private String releaseId = null;
    private String releaseDate = null;
    private final String name;
    private Properties versionProps;

    public static void main(String[] argv) {
        System.out.println(CURRENT_VERSION);
    }

    public KVVersion(int oracleMajor, int oracleMinor, int majorNum, int minorNum, int patchNum, String name) {
        this.oracleMajor = oracleMajor;
        this.oracleMinor = oracleMinor;
        this.majorNum = majorNum;
        this.minorNum = minorNum;
        this.patchNum = patchNum;
        this.name = name;
    }

    public String toString() {
        return this.getVersionString();
    }

    public int getOracleMajor() {
        return this.oracleMajor;
    }

    public int getOracleMinor() {
        return this.oracleMinor;
    }

    public int getMajor() {
        return this.majorNum;
    }

    public int getMinor() {
        return this.minorNum;
    }

    public int getPatch() {
        return this.patchNum;
    }

    public String getReleaseId() {
        this.initVersionProps();
        return this.releaseId;
    }

    public String getReleaseDate() {
        this.initVersionProps();
        return this.releaseDate;
    }

    private synchronized void initVersionProps() {
        if (this.versionProps != null) {
            return;
        }
        InputStream releaseProps = KVVersion.class.getResourceAsStream("/version/build.properties");
        if (releaseProps == null) {
            return;
        }
        this.versionProps = new Properties();
        try {
            this.versionProps.load(releaseProps);
        }
        catch (IOException IOE) {
            throw new IllegalStateException(IOE);
        }
        this.releaseId = this.versionProps.getProperty("release.id");
        this.releaseDate = this.versionProps.getProperty("release.date");
    }

    public String getNumericVersionString() {
        StringBuilder version = new StringBuilder();
        version.append(this.oracleMajor).append(".");
        version.append(this.oracleMinor).append(".");
        version.append(this.majorNum).append(".");
        version.append(this.minorNum).append(".");
        version.append(this.patchNum);
        return version.toString();
    }

    public String getVersionString() {
        this.initVersionProps();
        StringBuilder version = new StringBuilder();
        version.append(this.oracleMajor);
        version.append(this.oracleMajor == 12 ? "cR" : "gR");
        version.append(this.oracleMinor).append(".");
        version.append(this.majorNum).append(".");
        version.append(this.minorNum).append(".");
        version.append(this.patchNum);
        if (this.name != null) {
            version.append(" (");
            version.append(this.name);
            version.append(")");
        }
        if (this.releaseId != null) {
            version.append(" ").append(this.releaseDate).append(" ");
            version.append(" Build id: ").append(this.releaseId);
        }
        return version.toString();
    }

    public static KVVersion parseVersion(String versionString) {
        String[] tokens = versionString.split(" ");
        String numericString = tokens[0].replaceAll("[cg]R", ".");
        String[] numericTokens = numericString.split("\\.");
        if (numericTokens.length != 5) {
            throw new IllegalArgumentException("Invalid version string: " + versionString);
        }
        try {
            return new KVVersion(Integer.parseInt(numericTokens[0]), Integer.parseInt(numericTokens[1]), Integer.parseInt(numericTokens[2]), Integer.parseInt(numericTokens[3]), Integer.parseInt(numericTokens[4]), null);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Invalid version string: " + versionString, nfe);
        }
    }

    public void setReleaseId(String releaseId) {
        this.initVersionProps();
        this.releaseId = releaseId;
    }

    @Override
    public int compareTo(KVVersion comparedVersion) {
        int result = 0;
        if (this.oracleMajor == comparedVersion.getOracleMajor()) {
            if (this.oracleMinor == comparedVersion.getOracleMinor()) {
                if (this.majorNum == comparedVersion.getMajor()) {
                    if (this.minorNum == comparedVersion.getMinor()) {
                        if (this.patchNum > comparedVersion.getPatch()) {
                            result = 1;
                        } else if (this.patchNum < comparedVersion.getPatch()) {
                            result = -1;
                        }
                    } else {
                        result = this.minorNum > comparedVersion.getMinor() ? 1 : -1;
                    }
                } else {
                    result = this.majorNum > comparedVersion.getMajor() ? 1 : -1;
                }
            } else {
                result = this.oracleMinor > comparedVersion.getOracleMinor() ? 1 : -1;
            }
        } else {
            result = this.oracleMajor > comparedVersion.getOracleMajor() ? 1 : -1;
        }
        return result;
    }

    public boolean equals(Object o) {
        return o instanceof KVVersion && this.compareTo((KVVersion)o) == 0;
    }

    public int hashCode() {
        return this.majorNum * 1000 * 1000 + this.minorNum * 1000 + this.patchNum;
    }

    static {
        CURRENT_VERSION = R4_4 = new KVVersion(12, 2, 4, 4, 6, null);
        PREREQUISITE_VERSION = R3_0;
    }
}

