/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import oracle.kv.Durability;
import oracle.kv.FaultException;
import oracle.kv.impl.util.ObjectUtil;
import oracle.kv.impl.util.SerializationUtil;

public class DurabilityException
extends FaultException {
    private static final long serialVersionUID = 1L;
    private final Durability.ReplicaAckPolicy ackPolicy;
    private final int requiredNodeCount;
    private final Set<String> availableReplicas;

    public DurabilityException(Throwable cause, Durability.ReplicaAckPolicy ackPolicy, int requiredNodeCount, Set<String> availableReplicas) {
        super(cause, true);
        this.ackPolicy = ackPolicy;
        this.requiredNodeCount = requiredNodeCount;
        this.availableReplicas = availableReplicas;
        this.checkValidFields();
    }

    private void checkValidFields() {
        ObjectUtil.checkNull("ackPolicy", this.ackPolicy);
        ObjectUtil.checkNull("availableReplicas", this.availableReplicas);
        for (String s : this.availableReplicas) {
            ObjectUtil.checkNull("element of availableReplicas", s);
        }
    }

    public DurabilityException(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.ackPolicy = Durability.ReplicaAckPolicy.readFastExternal(in, serialVersion);
        this.requiredNodeCount = SerializationUtil.readPackedInt(in);
        int availableReplicasCount = SerializationUtil.readNonNullSequenceLength(in);
        this.availableReplicas = new HashSet<String>(availableReplicasCount);
        for (int i = 0; i < availableReplicasCount; ++i) {
            this.availableReplicas.add(SerializationUtil.readNonNullString(in, serialVersion));
        }
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        this.ackPolicy.writeFastExternal(out, serialVersion);
        SerializationUtil.writePackedInt(out, this.requiredNodeCount);
        SerializationUtil.writeNonNullSequenceLength(out, this.availableReplicas.size());
        for (String s : this.availableReplicas) {
            SerializationUtil.writeNonNullString(out, serialVersion, s);
        }
    }

    public Durability.ReplicaAckPolicy getCommitPolicy() {
        return this.ackPolicy;
    }

    public int getRequiredNodeCount() {
        return this.requiredNodeCount;
    }

    public Set<String> getAvailableReplicas() {
        return this.availableReplicas;
    }
}

