/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.editors.graphical.xmlmodel;

import java.awt.Component;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListResourceBundle;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.raptor.navigator.IViewerNode;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.oviewer.base.NavSelectionListener;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.RaptorVersionTracker;
import oracle.dbtools.scheduler.editors.graphical.controller.GraphicalEditorArb;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineAction;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineDefinitions;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineDrop;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineEdge;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineEdgeType;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineGraph;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineModel;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineModelObserver;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineNode;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineNodeGenerator;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineNodeType;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineObject;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineType;
import oracle.dbtools.scheduler.editors.graphical.xmlmodel.XMLGraphEngineObject;
import oracle.dbtools.scheduler.editors.graphical.xmlmodel.XMLGraphEngineUtils;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.model.Element;
import oracle.ide.model.Node;

public class XMLGraphEngineModel
implements GraphEngineModel {
    private static final ResourceBundle emptyResourceBundle = new EmptyResourceBundle();
    Node node;
    Logger logger = Logger.getLogger(XMLGraphEngineModel.class.getName());
    List<GraphEngineModelObserver> observers = new Vector<GraphEngineModelObserver>();
    String name;
    GraphEngineDefinitions definitions;
    GraphEngineGraph graph;
    GraphPropertyChangeListener graphListener = new GraphPropertyChangeListener();
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private ResourceBundle resourceBundle = emptyResourceBundle;
    private boolean editor = false;
    private boolean enablePin = true;
    private boolean clearAllOnReload = false;
    Comparable version = null;

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public GraphEngineGraph getGraph() {
        return this.graph;
    }

    public void setGraph(GraphEngineGraph graphEngineGraph) {
        if (this.graph != null) {
            this.graph.removePropertyChangeListener(this.graphListener);
        }
        GraphEngineGraph graphEngineGraph2 = this.graph;
        this.graph = graphEngineGraph;
        this.propertyChangeSupport.firePropertyChange("graph", graphEngineGraph2, graphEngineGraph);
        if (this.graph != null) {
            this.graph.addPropertyChangeListener(this.graphListener);
        }
    }

    @Override
    public GraphEngineDefinitions getDefinitions() {
        return this.definitions;
    }

    public void setDefinitions(GraphEngineDefinitions graphEngineDefinitions) {
        GraphEngineDefinitions graphEngineDefinitions2 = this.definitions;
        this.definitions = graphEngineDefinitions;
        this.propertyChangeSupport.firePropertyChange("definitions", graphEngineDefinitions2, graphEngineDefinitions);
    }

    public void setName(String string) {
        String string2 = this.name;
        this.name = string;
        this.propertyChangeSupport.firePropertyChange("name", string2, string);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addObserver(GraphEngineModelObserver graphEngineModelObserver) {
        if (!this.observers.contains(graphEngineModelObserver)) {
            this.observers.add(graphEngineModelObserver);
        }
    }

    @Override
    public void removeObserver(GraphEngineModelObserver graphEngineModelObserver) {
        if (this.observers.contains(graphEngineModelObserver)) {
            this.observers.remove(graphEngineModelObserver);
        }
    }

    @Override
    public List<GraphEngineObject> importElement(Element element, Point2D point2D) {
        Vector<GraphEngineObject> vector = new Vector<GraphEngineObject>();
        if (point2D != null) {
            point2D = new Point2D.Double(point2D.getX(), point2D.getY());
        }
        if (element instanceof ViewerNode) {
            ViewerNode viewerNode = (ViewerNode)element;
            DBObject dBObject = viewerNode.getDBObject();
            if (!dBObject.getConnectionName().equals(this.getConnectionName())) {
                return vector;
            }
            try {
                String string = dBObject.getObjectType();
                String string2 = viewerNode.getShortLabel();
                List<GraphEngineNodeGenerator> list = this.definitions.getNodeGeneratorsFor(string);
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("dbobj", dBObject);
                hashMap.put("owner", dBObject.getSchemaName());
                hashMap.put("objectName", dBObject.getObjectName());
                hashMap.put("element", element);
                hashMap.put("objType", string);
                hashMap.put("name", string2);
                hashMap.put("location", point2D);
                for (GraphEngineNodeGenerator graphEngineNodeGenerator : list) {
                    List<GraphEngineObject> list2 = graphEngineNodeGenerator.generate(hashMap);
                    if (list2 == null) continue;
                    vector.addAll(list2);
                }
            }
            catch (Exception exception) {
                this.logger.log(Level.SEVERE, GraphicalEditorArb.get("GRAPH_EDITOR_IMPORT_NODE_EXCEPTION"), exception);
            }
        } else if (element instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)element;
            if (!objectNode.getConnectionName().equals(this.getConnectionName())) {
                return vector;
            }
            try {
                String string = objectNode.getObjectType();
                String string3 = objectNode.getShortLabel();
                DBObject dBObject = new DBObject(objectNode.getURL());
                List<GraphEngineNodeGenerator> list = this.definitions.getNodeGeneratorsFor(string);
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("dbobj", dBObject);
                hashMap.put("owner", objectNode.getSchemaName());
                hashMap.put("objectName", objectNode.getObjectName());
                hashMap.put("element", element);
                hashMap.put("objType", string);
                hashMap.put("name", string3);
                hashMap.put("location", point2D);
                for (GraphEngineNodeGenerator graphEngineNodeGenerator : list) {
                    List<GraphEngineObject> list3 = graphEngineNodeGenerator.generate(hashMap);
                    if (list3 == null) continue;
                    vector.addAll(list3);
                }
            }
            catch (Exception exception) {
                this.logger.log(Level.SEVERE, GraphicalEditorArb.get("GRAPH_EDITOR_IMPORT_NODE_EXCEPTION"), exception);
            }
        } else if (element instanceof ObjectFolder) {
            ObjectFolder objectFolder = (ObjectFolder)element;
            try {
                if (!objectFolder.isLoaded()) {
                    objectFolder.open();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Iterator iterator = objectFolder.getChildren();
            while (iterator != null && iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof Element)) continue;
                vector.addAll(this.importElement((Element)e, point2D));
                if (point2D == null) continue;
                point2D.setLocation(point2D.getX() + 32.0, point2D.getY() + 32.0);
            }
        }
        return vector;
    }

    @Override
    public boolean drop(GraphEngineObject graphEngineObject, GraphEngineObject[] graphEngineObjectArray) {
        GraphEngineDrop graphEngineDrop;
        GraphEngineObject graphEngineObject2;
        int n;
        GraphEngineType graphEngineType = graphEngineObject.getType();
        for (n = 0; n < graphEngineObjectArray.length; ++n) {
            graphEngineObject2 = graphEngineObjectArray[n];
            graphEngineDrop = graphEngineType.getDrop(graphEngineObject2.getType().getTypeId());
            if (graphEngineDrop != null) continue;
            return false;
        }
        for (n = 0; n < graphEngineObjectArray.length; ++n) {
            graphEngineObject2 = graphEngineObjectArray[n];
            graphEngineDrop = graphEngineType.getDrop(graphEngineObject2.getType().getTypeId());
            GraphEngineAction graphEngineAction = graphEngineDrop.getAction();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("SOURCE", graphEngineObject2);
            hashMap.put("TARGET", graphEngineObject);
            String string = graphEngineAction.execute(hashMap);
            if (string != null) continue;
            if (graphEngineAction.isDelete() && graphEngineObject2 != null) {
                GraphEngineObject graphEngineObject3;
                GraphEngineGraph graphEngineGraph = graphEngineObject2.getGraph();
                if (graphEngineObject2 instanceof GraphEngineNode) {
                    graphEngineObject3 = (GraphEngineNode)graphEngineObject2;
                    graphEngineGraph.remove((GraphEngineNode)graphEngineObject3);
                }
                if (graphEngineObject2 instanceof GraphEngineEdge) {
                    graphEngineObject3 = (GraphEngineEdge)graphEngineObject2;
                    graphEngineGraph.remove((GraphEngineEdge)graphEngineObject3);
                }
            }
            if (!graphEngineAction.isReload()) continue;
            if (graphEngineObject2 instanceof GraphEngineNode) {
                XMLGraphEngineUtils.removeEdgesFrom(graphEngineObject2.getGraph(), (GraphEngineNode)graphEngineObject2);
            }
            if (graphEngineObject instanceof GraphEngineNode) {
                XMLGraphEngineUtils.removeEdgesFrom(graphEngineObject2.getGraph(), (GraphEngineNode)graphEngineObject);
            }
            if (graphEngineObject2 instanceof GraphEngineNode) {
                XMLGraphEngineUtils.generateEdgesFor(graphEngineObject2.getGraph().getModel().getDefinitions(), (GraphEngineNode)graphEngineObject2);
            }
            if (!(graphEngineObject instanceof GraphEngineNode)) continue;
            XMLGraphEngineUtils.generateEdgesFor(graphEngineObject2.getGraph().getModel().getDefinitions(), (GraphEngineNode)graphEngineObject);
        }
        return true;
    }

    private void fireNodeAdded(GraphEngineNode graphEngineNode) {
        for (GraphEngineModelObserver graphEngineModelObserver : this.observers) {
            graphEngineModelObserver.nodeAdded(graphEngineNode);
        }
    }

    private void fireNodeRemoved(GraphEngineNode graphEngineNode) {
        for (GraphEngineModelObserver graphEngineModelObserver : this.observers) {
            graphEngineModelObserver.nodeRemoved(graphEngineNode);
        }
    }

    private void fireEdgeAdded(GraphEngineEdge graphEngineEdge) {
        for (GraphEngineModelObserver graphEngineModelObserver : this.observers) {
            graphEngineModelObserver.edgeAdded(graphEngineEdge);
        }
    }

    private void fireEdgeRemoved(GraphEngineEdge graphEngineEdge) {
        for (GraphEngineModelObserver graphEngineModelObserver : this.observers) {
            graphEngineModelObserver.edgeRemoved(graphEngineEdge);
        }
    }

    @Override
    public String canMoveEdge(GraphEngineEdge graphEngineEdge, GraphEngineNode graphEngineNode, GraphEngineNode graphEngineNode2) {
        try {
            if (graphEngineEdge != null && graphEngineNode != null && graphEngineNode2 != null) {
                if (graphEngineEdge.getSource().getId().equals(graphEngineNode.getId()) && graphEngineEdge.getTarget().getId().equals(graphEngineNode2.getId())) {
                    return "";
                }
                GraphEngineEdgeType graphEngineEdgeType = graphEngineEdge.getType();
                if (graphEngineEdge.getSource().getId().equals(graphEngineNode.getId())) {
                    return graphEngineEdgeType.canMoveEdgeTarget(graphEngineNode.getType(), graphEngineNode2.getType());
                }
                return graphEngineEdgeType.canMoveEdgeSource(graphEngineNode.getType(), graphEngineNode2.getType());
            }
        }
        catch (Throwable throwable) {
            return throwable.getLocalizedMessage();
        }
        return "";
    }

    @Override
    public void moveEdge(GraphEngineEdge graphEngineEdge, GraphEngineNode graphEngineNode, GraphEngineNode graphEngineNode2) {
        try {
            if (graphEngineEdge == null) break block6;
            if (graphEngineNode == null) break block7;
            if (graphEngineNode2 != null) {
                if (graphEngineEdge.getSource().getId().equals(graphEngineNode.getId()) && graphEngineEdge.getTarget().getId().equals(graphEngineNode2.getId())) {
                    return;
                }
                GraphEngineEdgeType graphEngineEdgeType = graphEngineEdge.getType();
                if (graphEngineEdge.getSource().getId().equals(graphEngineNode.getId())) {
                    graphEngineEdgeType.moveEdgeTarget(graphEngineEdge, graphEngineNode2);
                }
                graphEngineEdgeType.moveEdgeSource(graphEngineEdge, graphEngineNode);
            }
        }
        finally {
            return;
        }
        {
            block6: {
                block7: {
                }
            }
        }
    }

    @Override
    public String canCreateEdge(GraphEngineNode graphEngineNode, GraphEngineNode graphEngineNode2) {
        try {
            GraphEngineNodeType graphEngineNodeType = graphEngineNode.getType();
            GraphEngineNodeType graphEngineNodeType2 = graphEngineNode2.getType();
            GraphEngineDefinitions graphEngineDefinitions = this.getDefinitions();
            Map<String, GraphEngineEdgeType> map = graphEngineDefinitions.getEdgeDefinitions();
            for (GraphEngineEdgeType graphEngineEdgeType : map.values()) {
                if (graphEngineEdgeType.getSourceType().equals(graphEngineNodeType.getTypeId()) && graphEngineEdgeType.getTargetType().equals(graphEngineNodeType2.getTypeId())) {
                    return null;
                }
                if (!graphEngineEdgeType.isCreateReversed() || !graphEngineEdgeType.getSourceType().equals(graphEngineNodeType2.getTypeId()) || !graphEngineEdgeType.getTargetType().equals(graphEngineNodeType.getTypeId())) continue;
                return null;
            }
            if (graphEngineNodeType != null && graphEngineNodeType2 != null) {
                return graphEngineNodeType.canCreateEdge(graphEngineNodeType2);
            }
        }
        catch (Throwable throwable) {
            return throwable.getLocalizedMessage();
        }
        return "";
    }

    @Override
    public List<GraphEngineEdgeType> getEdgeTypes(GraphEngineNode graphEngineNode, GraphEngineNode graphEngineNode2) {
        Comparable comparable;
        Comparable comparable2;
        GraphEngineNodeType graphEngineNodeType = graphEngineNode.getType();
        GraphEngineNodeType graphEngineNodeType2 = graphEngineNode2.getType();
        GraphEngineDefinitions graphEngineDefinitions = this.getDefinitions();
        Map<String, GraphEngineEdgeType> map = graphEngineDefinitions.getEdgeDefinitions();
        Vector<GraphEngineEdgeType> vector = new Vector<GraphEngineEdgeType>();
        Version version = this.getConnectionVersion();
        for (GraphEngineEdgeType graphEngineEdgeType : map.values()) {
            if (!graphEngineEdgeType.getSourceType().equals(graphEngineNodeType.getTypeId()) || !graphEngineEdgeType.getTargetType().equals(graphEngineNodeType2.getTypeId())) continue;
            comparable2 = graphEngineEdgeType.getMinVersion();
            comparable = graphEngineEdgeType.getMaxVersion();
            if (version != null && comparable2 != null && version.compareTo(comparable2) < 0 || version != null && comparable != null && version.compareTo(comparable) >= 0) continue;
            vector.add(graphEngineEdgeType);
        }
        if (vector.size() == 0) {
            for (GraphEngineEdgeType graphEngineEdgeType : map.values()) {
                if (!graphEngineEdgeType.isCreateReversed() || !graphEngineEdgeType.getSourceType().equals(graphEngineNodeType2.getTypeId()) || !graphEngineEdgeType.getTargetType().equals(graphEngineNodeType.getTypeId())) continue;
                comparable2 = graphEngineEdgeType.getMinVersion();
                comparable = graphEngineEdgeType.getMaxVersion();
                if (version != null && comparable2 != null && version.compareTo(comparable2) < 0 || version != null && comparable != null && version.compareTo(comparable) >= 0) continue;
                vector.add(graphEngineEdgeType);
            }
        }
        return vector;
    }

    @Override
    public void createEdge(GraphEngineEdgeType graphEngineEdgeType, GraphEngineNode graphEngineNode, GraphEngineNode graphEngineNode2) {
        if (graphEngineEdgeType != null) {
            graphEngineEdgeType.create(graphEngineNode, graphEngineNode2);
        }
    }

    @Override
    public void setNode(Node node) {
        Node node2 = this.node;
        this.node = node;
        this.propertyChangeSupport.firePropertyChange("Node", node2, node);
        if (node2 != node && this.getGraph() != null) {
            this.getGraph().clear();
        }
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public String getConnectionName() {
        if (this.node instanceof IViewerNode) {
            IViewerNode iViewerNode = (IViewerNode)this.node;
            return iViewerNode.getDBObject().getConnectionName();
        }
        return null;
    }

    @Override
    public String getSchemaName() {
        if (this.node instanceof IViewerNode) {
            IViewerNode iViewerNode = (IViewerNode)this.node;
            return iViewerNode.getDBObject().getSchemaName();
        }
        return null;
    }

    @Override
    public Connection getConnection() {
        if (this.node instanceof IViewerNode) {
            IViewerNode iViewerNode = (IViewerNode)this.node;
            return iViewerNode.getDBObject().getConnection();
        }
        return null;
    }

    @Override
    public String getConnectionVersionString() {
        Version version = this.getConnectionVersion();
        if (version != null) {
            return version.toCanonicalString();
        }
        return null;
    }

    public Version getConnectionVersion() {
        Connection connection = this.getConnection();
        if (connection != null) {
            return RaptorVersionTracker.getDbVersion((Connection)connection);
        }
        return null;
    }

    @Override
    public void edit(GraphEngineObject graphEngineObject) {
        if (graphEngineObject instanceof XMLGraphEngineObject) {
            XMLGraphEngineObject xMLGraphEngineObject = (XMLGraphEngineObject)graphEngineObject;
            Element element = xMLGraphEngineObject.getElement();
            if (element == null || !(element instanceof ObjectNode)) {
                String string = this.getSchemaName();
                String string2 = xMLGraphEngineObject.getId();
                if (string2 != null && string2.contains(".")) {
                    string = string2.substring(0, string2.indexOf(46));
                    string2 = string2.substring(string2.indexOf(46) + 1);
                }
                element = XMLGraphEngineUtils.getDatabaseNode(this.getConnectionName(), xMLGraphEngineObject.getType().getTypeId(), string, string2);
                xMLGraphEngineObject.setElement(element);
            }
            if (element != null) {
                this.openEditor(element);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openEditor(Element element) {
        WaitCursor waitCursor = new WaitCursor((Component)Ide.getMainWindow());
        try {
            waitCursor.show();
            NavSelectionListener navSelectionListener = NavSelectionListener.getInstance();
            navSelectionListener.performDrill(element, "1");
        }
        finally {
            waitCursor.hide();
        }
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public void setResourceBundle(String string) {
        try {
            this.resourceBundle = ListResourceBundle.getBundle(string);
        }
        catch (Throwable throwable) {
            this.resourceBundle = emptyResourceBundle;
        }
    }

    @Override
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    @Override
    public boolean isEnablePin() {
        return this.enablePin;
    }

    public void setEnablePin(boolean bl) {
        this.enablePin = bl;
    }

    @Override
    public boolean isClearAllOnReload() {
        return this.clearAllOnReload;
    }

    public void setClearAllOnReload(boolean bl) {
        this.clearAllOnReload = bl;
    }

    public void setEditor(boolean bl) {
        this.editor = bl;
    }

    @Override
    public boolean isEditor() {
        return this.editor;
    }

    @Override
    public void setVersion(Comparable comparable) {
        this.version = comparable;
    }

    private static class EmptyResourceBundle
    extends ListResourceBundle {
        private EmptyResourceBundle() {
        }

        @Override
        protected Object[][] getContents() {
            return new Object[0][];
        }
    }

    private class GraphPropertyChangeListener
    implements PropertyChangeListener {
        private GraphPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equalsIgnoreCase("nodeAdded")) {
                GraphEngineNode graphEngineNode = (GraphEngineNode)propertyChangeEvent.getNewValue();
                XMLGraphEngineModel.this.fireNodeAdded(graphEngineNode);
            } else if (propertyChangeEvent.getPropertyName().equalsIgnoreCase("edgeAdded")) {
                GraphEngineEdge graphEngineEdge = (GraphEngineEdge)propertyChangeEvent.getNewValue();
                XMLGraphEngineModel.this.fireEdgeAdded(graphEngineEdge);
            } else if (propertyChangeEvent.getPropertyName().equalsIgnoreCase("nodeRemoved")) {
                GraphEngineNode graphEngineNode = (GraphEngineNode)propertyChangeEvent.getNewValue();
                XMLGraphEngineModel.this.fireNodeRemoved(graphEngineNode);
            } else if (propertyChangeEvent.getPropertyName().equalsIgnoreCase("edgeRemoved")) {
                GraphEngineEdge graphEngineEdge = (GraphEngineEdge)propertyChangeEvent.getNewValue();
                XMLGraphEngineModel.this.fireEdgeRemoved(graphEngineEdge);
            }
        }
    }
}

