/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.dialogs.newjob;

import java.sql.Connection;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.LabelActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.dialogs.newjob.Messages;
import oracle.dbtools.scheduler.generator.DBMSSchedulerCodeGenerator;

public class NewJobDropAction
extends ActionDialog {
    private static final String JOB_NAME = "name";
    private static final String FORCE = "force";
    private static final String DEFER = "defer";
    private static final String DROP_MSG = "msg";
    private String jobName;
    private boolean force = false;
    private boolean defer = false;

    public NewJobDropAction() {
        this.setScriptEditingEnabled(false);
    }

    protected List<ActionControl> createControls(Connection connection) {
        try {
            String string = this.getObjectName();
            this.jobName = "\"" + string + "\"";
        }
        catch (Exception exception) {
            return null;
        }
        try {
            String string = this.getDBObjectSchemaName();
            if (string == null) {
                string = this.getDBObject().getSchemaName();
            }
            if (NewJobDropAction.checkNull(string) != null) {
                this.jobName = "\"" + string + "\"." + this.jobName;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        TextBoxActionControl textBoxActionControl = new TextBoxActionControl(JOB_NAME, SchedulerArb.getString("JOB_DROP_NAME_LABEL"), this.jobName);
        LabelActionControl labelActionControl = new LabelActionControl(DROP_MSG, SchedulerArb.getString("JOB_DROP_LABEL"));
        BooleanCheckBoxActionControl booleanCheckBoxActionControl = new BooleanCheckBoxActionControl(FORCE, SchedulerArb.getString("JOB_DROP_FORCE_LABEL"), this.force);
        BooleanCheckBoxActionControl booleanCheckBoxActionControl2 = new BooleanCheckBoxActionControl(DEFER, SchedulerArb.getString("JOB_DROP_DEFER_LABEL"), this.defer);
        Vector<ActionControl> vector = new Vector<ActionControl>();
        textBoxActionControl.setEditable(false);
        vector.add((ActionControl)textBoxActionControl);
        vector.add((ActionControl)booleanCheckBoxActionControl);
        if (!this.getDBObject().getDBVersion().startsWith("10")) {
            vector.add((ActionControl)booleanCheckBoxActionControl2);
        }
        vector.add((ActionControl)labelActionControl);
        return vector;
    }

    protected String getScript(ActionDialog.Values values) {
        String string = this.getDBObject().getDBVersion();
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        String string2 = values.get(FORCE);
        String string3 = values.get(DEFER);
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put(JOB_NAME, this.jobName);
        treeMap.put(FORCE, string2);
        treeMap.put(DEFER, string3);
        TreeMap<String, Object> treeMap2 = new TreeMap<String, Object>();
        treeMap2.put("model", treeMap);
        String string4 = null;
        string4 = dBMSSchedulerCodeGenerator.generate(string, "JOB_DROP", treeMap2);
        return string4;
    }

    protected String getTitle() {
        return Messages.getString("JobDropAction.77");
    }

    public static String checkNull(String string) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        return string;
    }

    public static String checkQuotes(String string) {
        if ((string = NewJobDropAction.checkNull(string)) != null && string.length() > 0) {
            string = string.replace("'", "''");
        }
        return string;
    }
}

