/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.searchbar;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import oracle.ide.searchbar.Provider;
import oracle.ide.searchbar.Result;
import oracle.ideimpl.searchbar.Bundle;
import oracle.ideimpl.searchbar.ShowAllProvider;
import oracle.javatools.ui.table.GenericTableModel;

class ShowAllTableModel
extends AbstractTableModel
implements GenericTableModel {
    private List<Result> filteredResults = new ArrayList<Result>();
    private List<Result> allResults = new ArrayList<Result>();
    private Provider filterProvider;
    static String[] columns = new String[]{Bundle.get("TABLE_COLUMN_NAME"), Bundle.get("TABLE_COLUMN_KIND"), Bundle.get("TABLE_COLUMN_LOCATION")};

    ShowAllTableModel() {
    }

    @Override
    public int getRowCount() {
        return this.filteredResults.size();
    }

    @Override
    public int getColumnCount() {
        return columns.length;
    }

    @Override
    public String getColumnName(int colIndex) {
        return columns[colIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return columnIndex == 0 ? Result.class : String.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Result result = this.filteredResults.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return result;
            }
            case 1: {
                return result.provider().name();
            }
            case 2: {
                return result.displayLocation();
            }
        }
        return "";
    }

    public Result getRow(int rowIndex) {
        return this.filteredResults.get(rowIndex);
    }

    public void clear() {
        this.filteredResults.clear();
        this.allResults.clear();
        this.fireTableDataChanged();
    }

    private boolean filter(Result r) {
        if (this.filterProvider == null || this.filterProvider instanceof ShowAllProvider) {
            return true;
        }
        return this.filterProvider.equals(r.provider());
    }

    public void addResults(Collection<Result<?>> newResults) {
        for (Result<?> r : newResults) {
            this.allResults.add(r);
            if (!this.filter(r)) continue;
            this.filteredResults.add(r);
        }
        this.fireTableDataChanged();
    }

    public void removeResults(Collection<Result<?>> deletedResults) {
        for (Result<?> r : deletedResults) {
            this.allResults.remove(r);
            this.filteredResults.remove(r);
        }
        this.fireTableDataChanged();
    }

    public void removeResult(Result deletedResult) {
        int i = this.filteredResults.indexOf(deletedResult);
        this.allResults.remove(deletedResult);
        this.filteredResults.remove(deletedResult);
        if (i >= 0) {
            this.fireTableRowsDeleted(i, i);
        }
    }

    void filterProvider(Provider provider) {
        this.filterProvider = provider;
        this.filteredResults.clear();
        for (Result r : this.allResults) {
            if (!this.filter(r)) continue;
            this.filteredResults.add(r);
        }
        this.fireTableDataChanged();
    }

    public int getColumnAlignment(int column) {
        return 2;
    }

    public boolean canHide(int column) {
        return column != 0;
    }
}

