/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.process_validation;

import java.util.ArrayList;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import oracle.dbtools.unit_test.process_validation.BooleanFunction;
import oracle.dbtools.unit_test.process_validation.IValidation;
import oracle.dbtools.unit_test.process_validation.NullValidation;
import oracle.dbtools.unit_test.process_validation.PlSqlValidation;
import oracle.dbtools.unit_test.process_validation.QueryReturningNoRows;
import oracle.dbtools.unit_test.process_validation.QueryReturningRows;
import oracle.dbtools.unit_test.process_validation.ResultSetCompare;
import oracle.dbtools.unit_test.process_validation.TableCompare;
import oracle.dbtools.unit_test.process_validation.ValidationArb;

public class ValidationRegistry {
    private static TreeMap<String, Class> _registry = new TreeMap();

    public static synchronized ArrayList<String> getLovValues() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : _registry.keySet()) {
            arrayList.add(string);
        }
        return arrayList;
    }

    public static synchronized JComboBox getComboBox() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem(ValidationArb.getString("NONE"));
        for (String string : _registry.keySet()) {
            jComboBox.addItem(string);
        }
        return jComboBox;
    }

    public static synchronized void registerValidation(String string, Class clazz) {
        if (!IValidation.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class must be instance of IValidation");
        }
        _registry.put(string, clazz);
    }

    public static synchronized void unregisterValidation(String string) {
        _registry.remove(string);
    }

    public static synchronized Class getClassFor(String string) {
        return _registry.get(string);
    }

    public static synchronized String getKeyFor(String string) {
        String string2 = null;
        for (String string3 : _registry.keySet()) {
            Class clazz = _registry.get(string3);
            if (!clazz.getName().equals(string)) continue;
            string2 = string3;
            break;
        }
        return string2;
    }

    public static IValidation getInstanceFor(String string) {
        Class clazz = ValidationRegistry.getClassFor(string);
        if (clazz != null) {
            try {
                return (IValidation)clazz.newInstance();
            }
            catch (Exception exception) {
                Logger.getLogger(ValidationRegistry.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                return null;
            }
        }
        return null;
    }

    public static synchronized boolean isSupported(String string) {
        return _registry.get(string) != null;
    }

    static {
        ValidationRegistry.registerValidation(ValidationArb.getString("NONE"), NullValidation.class);
        ValidationRegistry.registerValidation(ValidationArb.getString("CODE_VALIDATION_NAME"), PlSqlValidation.class);
        ValidationRegistry.registerValidation(ValidationArb.getString("QUERY_ROWS_NAME"), QueryReturningRows.class);
        ValidationRegistry.registerValidation(ValidationArb.getString("QUERY_NO_ROWS_NAME"), QueryReturningNoRows.class);
        ValidationRegistry.registerValidation(ValidationArb.getString("BOOLEAN_FUNCTION_NAME"), BooleanFunction.class);
        ValidationRegistry.registerValidation(ValidationArb.getString("TABLE_COMPARE_NAME"), TableCompare.class);
        ValidationRegistry.registerValidation(ValidationArb.getString("RESULTSET_COMPARE_NAME"), ResultSetCompare.class);
    }
}

