/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.codehook;

import java.util.List;
import oracle.dbtools.unit_test.codehook.CodeHookLookup;
import oracle.dbtools.unit_test.process_validation.IValidation;
import oracle.dbtools.unit_test.startup.IStartup;
import oracle.dbtools.unit_test.teardown.ITeardown;

public class CodeHookDefaults {
    private static String EMPTY = "";
    private String _ownerName;
    private String _tableName;
    private String _tempTableName;
    private String _predicate;

    public CodeHookDefaults() {
        this(EMPTY, EMPTY, EMPTY);
    }

    public CodeHookDefaults(String string, String string2, String string3) {
        this._ownerName = EMPTY;
        this._tableName = string;
        this._tempTableName = string2;
        this._predicate = string3;
        this.finalizeValues();
    }

    public CodeHookDefaults(CodeHookLookup codeHookLookup) {
        this._ownerName = codeHookLookup.getOwnerName();
        List<IStartup> list = codeHookLookup.getStartups();
        List<ITeardown> list2 = codeHookLookup.getTeardowns();
        List<IValidation> list3 = codeHookLookup.getValidations();
        if (list != null) {
            for (IStartup iCodeHook : list) {
                this.mergeValues(iCodeHook.getDefaults());
            }
        }
        if (list2 != null) {
            for (ITeardown iTeardown : list2) {
                this.mergeValues(iTeardown.getDefaults());
            }
        }
        if (list3 != null) {
            for (IValidation iValidation : list3) {
                this.mergeValues(iValidation.getDefaults());
            }
        }
        this.finalizeValues();
    }

    private void mergeValues(CodeHookDefaults codeHookDefaults) {
        if (this._tableName == null && !codeHookDefaults._tableName.equals(EMPTY)) {
            this._tableName = codeHookDefaults._tableName;
        }
        if (this._tempTableName == null && !codeHookDefaults._tempTableName.equals(EMPTY)) {
            this._tempTableName = codeHookDefaults._tempTableName;
        }
        if (this._predicate == null && !codeHookDefaults._predicate.equals(EMPTY)) {
            this._predicate = codeHookDefaults._predicate;
        }
    }

    private void finalizeValues() {
        if (this._tableName == null) {
            this._tableName = EMPTY;
        }
        if (this._tempTableName == null) {
            this._tempTableName = EMPTY;
        }
        if (this._predicate == null) {
            this._predicate = EMPTY;
        }
    }

    public String getOwnerName() {
        return this._ownerName;
    }

    public String getTableName() {
        return this._tableName;
    }

    public String getTempTableName() {
        return this._tempTableName;
    }

    public String getPredicate() {
        return this._predicate;
    }
}

