/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.ui;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.DBConnectionComboBox;
import oracle.dbtools.raptor.report.ui.EditMode;
import oracle.dbtools.raptor.report.ui.ReportArb;
import oracle.dbtools.raptor.report.ui.ReportTreeContext;
import oracle.dbtools.raptor.report.ui.ReportTreeNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.javatools.db.DBException;

public class ReportOptionsPanel
extends JPanel {
    public static final String DB_NAME = "DB_NAME";
    private JLabel _reportTitle;
    private JCheckBox _advanced;
    private JButton _testButton;
    private DBConnectionComboBox _dbConnectionCombo;
    private JPanel _reportPanel;
    private String dbName;
    private PropertyChangeListener _contextListener;
    private ReportTreeNode _selectedNode;

    public ReportOptionsPanel(ReportTreeContext reportTreeContext, PropertyChangeListener propertyChangeListener) {
        this.init(reportTreeContext, propertyChangeListener);
    }

    private void init(final ReportTreeContext reportTreeContext, final PropertyChangeListener propertyChangeListener) {
        this._reportTitle = new JLabel();
        Font font = this._reportTitle.getFont();
        this._reportTitle.setFont(font.deriveFont(font.getStyle() | 1, font.getSize() + 2));
        EditMode editMode = reportTreeContext.mode();
        if (editMode != EditMode.EDIT) {
            this._advanced = new JCheckBox(ReportArb.getString("ADVANCED"), editMode == EditMode.NEW_ADVANCED);
            this._advanced.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    reportTreeContext.setMode(ReportOptionsPanel.this._advanced.isSelected() ? EditMode.NEW_ADVANCED : EditMode.NEW);
                }
            });
            reportTreeContext.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    String string = propertyChangeEvent.getPropertyName();
                    if (string.equals("SQLVARIANTSENABLED")) {
                        ReportOptionsPanel.this._advanced.setEnabled(!reportTreeContext.sqlVariantsEnabled());
                    }
                }
            });
        }
        Icon icon = ReportArb.getIcon("TEST_REPORT_ICON");
        this._testButton = new JButton(icon);
        this._testButton.setToolTipText(ReportArb.getString("TEST_REPORT"));
        this._testButton.setEnabled(false);
        this._dbConnectionCombo = new DBConnectionComboBox();
        JComboBox jComboBox = this._dbConnectionCombo.getJComboBox();
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                String string;
                if (itemEvent.getStateChange() == 1 && (string = ReportOptionsPanel.this._dbConnectionCombo.getCurrentConnectionName()) != null && !string.equals(ReportOptionsPanel.this.dbName)) {
                    RaptorTask<Void> raptorTask = new RaptorTask<Void>(ReportArb.getString("OPENING_CONNECTION"), true, IRaptorTaskRunMode.MODAL){

                        protected Void doWork() throws TaskException {
                            Connection connection = null;
                            try {
                                connection = Connections.getInstance().getConnection(string);
                            }
                            catch (DBException dBException) {
                                ExceptionHandler.handleException((Throwable)dBException.getCause());
                            }
                            if (connection != null) {
                                ReportOptionsPanel.this.dbName = string;
                            } else {
                                ReportOptionsPanel.this._dbConnectionCombo.setCurrentConnection(ReportOptionsPanel.this.dbName);
                            }
                            final boolean bl = ReportOptionsPanel.this.dbName != null && !ReportOptionsPanel.this.dbName.equals("");
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ReportOptionsPanel.this._testButton.setEnabled(bl);
                                }
                            });
                            propertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, ReportOptionsPanel.DB_NAME, null, ReportOptionsPanel.this.dbName));
                            return null;
                        }
                    };
                    RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
                }
            }
        });
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(6, 6, 10, 6);
        int n = 0;
        this.add((Component)this._reportTitle, new GridBagConstraints(n++, 0, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        if (this._advanced != null) {
            this.add((Component)this._advanced, new GridBagConstraints(n++, 0, 1, 1, 0.0, 0.0, 13, 0, insets, 0, 0));
        }
        this.add((Component)this._testButton, new GridBagConstraints(n++, 0, 1, 1, 0.0, 0.0, 13, 0, insets, 0, 0));
        this.add((Component)jComboBox, new GridBagConstraints(n++, 0, 1, 1, 0.0, 0.0, 13, 0, insets, 0, 0));
        this._contextListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (ReportOptionsPanel.this._selectedNode != null && propertyChangeEvent.getPropertyName().equals("NAME")) {
                    String string = ReportOptionsPanel.this._selectedNode.title();
                    ReportOptionsPanel.this.setTitle(string);
                    ReportOptionsPanel.this.revalidate();
                    ReportOptionsPanel.this.repaint();
                }
            }
        };
    }

    public void setConnectionName(String string) {
        this._dbConnectionCombo.setCurrentConnection(string);
    }

    void cleanUp() {
        this._dbConnectionCombo.dispose();
        this._reportPanel = null;
    }

    public JButton testButton() {
        return this._testButton;
    }

    public String dbName() {
        return this.dbName;
    }

    public void onSelectNode(ReportTreeNode reportTreeNode) {
        if (this._selectedNode != null) {
            this._selectedNode.context().removePropertyChangeListener(this._contextListener);
        }
        String string = reportTreeNode.title();
        this.setTitle(string);
        JPanel jPanel = reportTreeNode.panel();
        this.setPanel(jPanel);
        reportTreeNode.context().addPropertyChangeListener(this._contextListener);
        this._selectedNode = reportTreeNode;
        this.revalidate();
        this.repaint();
    }

    private void setTitle(String string) {
        this._reportTitle.setText(string);
    }

    private void setPanel(JPanel jPanel) {
        if (this._reportPanel != null) {
            this.remove(this._reportPanel);
        }
        if (jPanel != null) {
            Insets insets = new Insets(0, 6, 6, 6);
            this.add((Component)jPanel, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 17, 1, insets, 0, 0));
        }
        this._reportPanel = jPanel;
    }
}

