/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.util.ArrayList;
import java.util.Locale;
import oracle.help.common.View;
import oracle.help.common.navigator.searchNavigator.SearchModel;
import oracle.help.common.navigator.searchNavigator.SearchModelData;
import oracle.help.common.search.BooleanExpression;
import oracle.help.common.search.QueryStringBreaker;
import oracle.help.common.search.SearchExpression;
import oracle.help.common.search.StringExpression;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.navigator.searchNavigator.OHJSearchModelData;
import oracle.ide.util.SwingWorker;
import oracle.javatools.ui.search.SearchProgress;
import oracle.jdevimpl.help.AbstractRSSQueryHandler;
import oracle.jdevimpl.help.HelpCenterWindow;
import oracle.jdevimpl.help.OTNQueryHandler;
import oracle.jdevimpl.help.OTNQueryView;
import oracle.jdevimpl.help.TahitiQueryHandler;
import oracle.jdevimpl.help.TahitiQueryView;
import oracle.jdevimpl.help.UserQuery;

public class SearchWorker {
    protected UserQuery _userQuery;
    protected SearchModel _searchModel;
    protected SwingWorker _swingWorker;
    private SearchProgress _searchProgress;
    protected WorkerType _workerType;
    protected boolean _searchDone;
    private String _errorText;

    public SearchWorker(UserQuery userQuery, WorkerType workerType, SearchProgress searchProgress) {
        this._userQuery = userQuery;
        this._workerType = workerType;
        this._searchProgress = searchProgress;
    }

    public boolean searchDone() {
        return this._searchDone;
    }

    public void setSearchDone(boolean done) {
        this._searchDone = done;
    }

    public UserQuery getUserQuery() {
        return this._userQuery;
    }

    public WorkerType getWorkerType() {
        return this._workerType;
    }

    public SearchModel getSearchModel() {
        return this._searchModel;
    }

    public String getErrorText() {
        return this._errorText;
    }

    public boolean searchStopped() {
        if (this._searchProgress != null) {
            return this._searchProgress.isStopped();
        }
        return false;
    }

    public void setSwingWorker(SwingWorker worker) {
        this._swingWorker = worker;
    }

    public SwingWorker getSwingWorker() {
        return this._swingWorker;
    }

    public void stopSearch() {
        if (this._swingWorker != null) {
            this._swingWorker.interrupt();
        }
    }

    public void startSearch() {
        this._swingWorker = new SwingWorker(){

            public Object construct() {
                SearchRunnable searchRunnable = new SearchRunnable();
                searchRunnable.start();
                while (!searchRunnable.isDone() && !SearchWorker.this.searchStopped()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interuptEx) {
                        return "Done";
                    }
                }
                if (SearchWorker.this.searchStopped() && SearchWorker.this._searchModel != null) {
                    SearchWorker.this._searchModel.stopSearch();
                }
                return "Done";
            }

            public void finished() {
                SearchWorker.this._swingWorker = null;
                SearchWorker.this._searchDone = true;
            }
        };
        this._swingWorker.start();
    }

    public static enum WorkerType {
        LOCAL,
        OTN,
        TAHITI;

    }

    public class SearchRunnable
    implements Runnable {
        protected boolean _done;

        public void start() {
            this._done = false;
            this.run();
        }

        public boolean isDone() {
            return this._done;
        }

        @Override
        public void run() {
            try {
                AbstractRSSQueryHandler rssQueryHandler = null;
                if (SearchWorker.this._workerType == WorkerType.OTN) {
                    OTNQueryView otnQueryView = new OTNQueryView(null, null, null, null, null, null, null, null, null);
                    SearchWorker.this._searchModel = new SearchModel((SearchModelData)new OHJSearchModelData(), new View[]{otnQueryView});
                    rssQueryHandler = (OTNQueryHandler)((Object)otnQueryView.getViewData());
                } else if (SearchWorker.this._workerType == WorkerType.TAHITI) {
                    TahitiQueryView tahitiQueryView = new TahitiQueryView(null, null, null, null, null, null, null, null, null);
                    tahitiQueryView.setSearchList(SearchWorker.this._userQuery.getTahitiSearchList());
                    tahitiQueryView.setLocalInSearch(SearchWorker.this._userQuery.includeLocal());
                    SearchWorker.this._searchModel = new SearchModel((SearchModelData)new OHJSearchModelData(), new View[]{tahitiQueryView});
                    rssQueryHandler = (TahitiQueryHandler)((Object)tahitiQueryView.getViewData());
                }
                if (SearchWorker.this._workerType == WorkerType.OTN || SearchWorker.this._workerType == WorkerType.TAHITI) {
                    StringExpression searchExpr = new StringExpression(SearchWorker.this._userQuery.getQueryText(), false);
                    SearchWorker.this._searchModel.startSearch((SearchExpression)searchExpr);
                    SearchWorker.this._errorText = rssQueryHandler.getErrorText();
                } else {
                    this.runLocalSearch();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this._done = true;
        }

        public void runLocalSearch() {
            try {
                SearchWorker.this._searchModel = HelpCenterWindow.getSearchModel();
                if (SearchWorker.this._userQuery.getSearchType() != 2) {
                    boolean allWords = SearchWorker.this._userQuery.getSearchType() == 0;
                    ArrayList wordsArrayList = new ArrayList();
                    QueryStringBreaker.breakQueryString((String)SearchWorker.this._userQuery.getQueryText(), (Locale)StaticLocaleContext.getLocale(), wordsArrayList, (boolean)SearchWorker.this._userQuery.getCaseSensitive());
                    String[] words = new String[wordsArrayList.size()];
                    wordsArrayList.toArray(words);
                    SearchWorker.this._searchModel.startSearch(words, allWords, SearchWorker.this._userQuery.getCaseSensitive());
                    ((OHJSearchModelData)SearchWorker.this._searchModel.getSearchModelData()).sort(0, false);
                } else {
                    SearchExpression expr = BooleanExpression.buildExpressionTree((String)SearchWorker.this._userQuery.getQueryText(), (boolean)SearchWorker.this._userQuery.getCaseSensitive());
                    if (expr != null) {
                        SearchWorker.this._searchModel.startSearch(expr);
                        ((OHJSearchModelData)SearchWorker.this._searchModel.getSearchModelData()).sort(0, false);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

