/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.gallery;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Icon;
import oracle.ide.gallery.GalleryElement;
import oracle.ide.gallery.GalleryElementHierarchyMgr;
import oracle.ide.gallery.GalleryFolder;
import oracle.ide.resource.GalleryArb;
import oracle.javatools.icons.OracleIcons;

final class AllItemsFolder
extends GalleryFolder {
    private String searchText;
    private final GalleryElementHierarchyMgr _elementHierarchyMgr;

    AllItemsFolder(GalleryElementHierarchyMgr mgr, List<GalleryElement> children) {
        this._elementHierarchyMgr = mgr;
        this.setList(children);
    }

    @Override
    public Icon getIcon() {
        return OracleIcons.getIcon((String)"new.png");
    }

    @Override
    public String getShortLabel() {
        return GalleryArb.getString((int)18);
    }

    @Override
    public String getName() {
        return this.getShortLabel();
    }

    @Override
    public String getLongLabel() {
        return this.getShortLabel();
    }

    @Override
    protected final GalleryElement[] getElementChildren() {
        GalleryElement[] elements = super.getElementChildren();
        if (this.getSearchText() != null && this.getSearchText().trim().length() > 0) {
            Pattern pattern = Pattern.compile(this.getSearchText(), 18);
            ArrayList<GalleryElement> list = new ArrayList<GalleryElement>();
            block0: for (GalleryElement element : elements) {
                if (pattern.matcher(element.getShortLabel()).find() || pattern.matcher(this._elementHierarchyMgr.getParentFolder(element)).find()) {
                    list.add(element);
                    continue;
                }
                if (element.getTechnologyKeys().length <= 0) continue;
                for (String techKey : element.getTechnologyKeys()) {
                    if (!pattern.matcher(techKey).find()) continue;
                    list.add(element);
                    continue block0;
                }
            }
            return list.toArray(new GalleryElement[list.size()]);
        }
        return elements;
    }

    void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    private String getSearchText() {
        return this.searchText;
    }

    @Override
    protected final GalleryElement[] getSortedElementChildren() {
        GalleryElement[] children = this.getElementChildren();
        Arrays.sort(children, GalleryElement.LABEL_ONLY_COMPARATOR);
        return children;
    }
}

