/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.util.xpath;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathNamespaceContext
implements NamespaceContext {
    private Map<String, String> _prefixMap = new HashMap<String, String>();

    public XPathNamespaceContext() {
    }

    public XPathNamespaceContext(Map<String, String> prefixMap) {
        this._prefixMap = prefixMap == null ? new HashMap<String, String>() : prefixMap;
    }

    public void addNamespacePrefix(String prefix, String namespace) {
        this._prefixMap.put(prefix, namespace);
    }

    public void removeNamespacePrefix(String prefix) {
        this._prefixMap.remove(prefix);
    }

    public Map<String, String> getPrefixNamespaceMap() {
        return new HashMap<String, String>(this._prefixMap);
    }

    public void setPrefixNamespaceMap(Map<String, String> prefixMap) {
        this._prefixMap = prefixMap;
    }

    public boolean containsPrefix(String prefix) {
        return this._prefixMap.containsKey(prefix);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this._prefixMap.get(prefix);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        if (namespaceURI != null) {
            for (Map.Entry<String, String> entry : this._prefixMap.entrySet()) {
                if (!namespaceURI.equalsIgnoreCase(entry.getValue())) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public Iterator getPrefixes(String namespaceURI) {
        if (namespaceURI != null) {
            ArrayList<String> prefixes = new ArrayList<String>();
            for (Map.Entry<String, String> entry : this._prefixMap.entrySet()) {
                if (!namespaceURI.equalsIgnoreCase(entry.getValue())) continue;
                prefixes.add(entry.getKey());
            }
            return prefixes.iterator();
        }
        return null;
    }
}

