/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import java.util.List;
import oracle.olapi.metadata.mdm.MdmHierarchy;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.syntax.AggregationCase;
import oracle.olapi.syntax.Condition;
import oracle.olapi.syntax.ConsistentSolveCommand;
import oracle.olapi.syntax.FunctionArgument;
import oracle.olapi.syntax.SolveStepCommand;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.ValidationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AggregationCommand
extends SolveStepCommand
implements ConsistentSolveCommand {
    public static boolean IGNORE_NULLS_DEFAULT = true;
    public static boolean ALLOW_OVERFLOW_DEFAULT = true;
    public static boolean ALLOW_DIVISION_BY_ZERO_DEFAULT = true;
    public static boolean MAINTAIN_COUNT_DEFAULT = false;
    private MdmPrimaryDimension m_PrimaryDimension;
    private MdmHierarchy[] m_Hierarchies;
    private AggregationCase[] m_AggregationCases;
    private boolean m_IgnoreNulls = false;
    private boolean m_AllowOverflow = false;
    private boolean m_AllowDivisionByZero = false;
    private boolean m_MaintainCount = false;
    private Condition m_MembersCondition;

    private MdmHierarchy[] getHierarchiesInternal() {
        return this.m_Hierarchies;
    }

    private AggregationCase[] getAggregationCasesInternal() {
        return this.m_AggregationCases;
    }

    private AggregationCommand(String string, FunctionArgument[] functionArgumentArray, AggregationCase[] aggregationCaseArray, MdmPrimaryDimension mdmPrimaryDimension, MdmHierarchy[] mdmHierarchyArray, boolean bl, boolean bl2, boolean bl3, boolean bl4, Condition condition, boolean bl5) {
        super(string, functionArgumentArray, bl5);
        this.m_PrimaryDimension = mdmPrimaryDimension;
        this.m_AllowDivisionByZero = bl3;
        this.m_AllowOverflow = bl2;
        this.m_MaintainCount = bl4;
        this.m_IgnoreNulls = bl;
        this.m_MembersCondition = null;
        if (null != mdmPrimaryDimension) {
            AggregationCommand.validateValue(mdmPrimaryDimension);
        }
        if (null != mdmHierarchyArray) {
            AggregationCommand.validateValues(mdmHierarchyArray);
            AggregationCommand.validateValue(mdmPrimaryDimension);
            this.m_Hierarchies = bl5 ? (MdmHierarchy[])mdmHierarchyArray.clone() : mdmHierarchyArray;
        }
        if (null != aggregationCaseArray) {
            AggregationCommand.validateValues(aggregationCaseArray);
            this.m_AggregationCases = bl5 ? (AggregationCase[])aggregationCaseArray.clone() : aggregationCaseArray;
        }
        if (null != condition) {
            AggregationCommand.validateValue(condition);
            this.m_MembersCondition = condition;
        }
        this.initialize();
    }

    private static MdmHierarchy[] createMdmHierarchyArray(List<MdmHierarchy> list) {
        if (null == list) {
            return null;
        }
        MdmHierarchy[] mdmHierarchyArray = new MdmHierarchy[list.size()];
        list.toArray(mdmHierarchyArray);
        return mdmHierarchyArray;
    }

    private static AggregationCase[] createAggregationCaseArray(List<AggregationCase> list) {
        if (null == list) {
            return null;
        }
        AggregationCase[] aggregationCaseArray = new AggregationCase[list.size()];
        list.toArray(aggregationCaseArray);
        return aggregationCaseArray;
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        this.validate(16, validationContext);
        if (null != this.m_MembersCondition) {
            validationContext.validateCond(this.m_MembersCondition);
        }
        if (null != this.m_AggregationCases) {
            validationContext.validateComponents(this, this.m_AggregationCases);
        }
        return this;
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        int n;
        boolean bl = false;
        if (null != this.getAggregationCasesInternal() && 0 < this.getAggregationCasesInternal().length) {
            syntaxPrintingContext.append("AGGREGATE USING MEASURE ");
            for (n = 0; n < this.getAggregationCasesInternal().length; ++n) {
                syntaxPrintingContext.newLineAndIndent();
                syntaxPrintingContext.print(this.getAggregationCasesInternal()[n]);
            }
            syntaxPrintingContext.newLineAndIndent();
            syntaxPrintingContext.append("ELSE ");
            bl = true;
        }
        super.toSyntax(syntaxPrintingContext);
        if (this.getMaintainCount()) {
            syntaxPrintingContext.newLineAndIndent();
            syntaxPrintingContext.append("MAINTAIN COUNT");
            bl = true;
        }
        if (!this.getAllowOverflow()) {
            syntaxPrintingContext.newLineAndIndent();
            syntaxPrintingContext.append("DISALLOW OVERFLOW");
            bl = true;
        }
        if (!this.getAllowDivisionByZero()) {
            syntaxPrintingContext.newLineAndIndent();
            syntaxPrintingContext.append("DISALLOW DIVISION BY ZERO");
            bl = true;
        }
        if (!this.getIgnoreNulls()) {
            syntaxPrintingContext.newLineAndIndent();
            syntaxPrintingContext.append("CONSIDER NULLS");
            bl = true;
        }
        if (bl) {
            syntaxPrintingContext.newLineAndIndent();
        }
        syntaxPrintingContext.append(" OVER ");
        if (null == this.getPrimaryDimension()) {
            syntaxPrintingContext.append("ALL");
        } else {
            syntaxPrintingContext.appendIdentifier(this.getPrimaryDimension().getID());
            if (null != this.getHierarchiesInternal()) {
                syntaxPrintingContext.append(" HIERARCHIES (");
                for (n = 0; n < this.getHierarchiesInternal().length; ++n) {
                    if (0 != n) {
                        syntaxPrintingContext.append(", ");
                    }
                    syntaxPrintingContext.appendIdentifierComponent(this.getHierarchiesInternal()[n].getName(), true);
                }
                syntaxPrintingContext.append(")");
            }
        }
        if (null != this.getMembersCondition()) {
            syntaxPrintingContext.append(" FROM MEMBERS WHERE ");
            syntaxPrintingContext.print(this.getMembersCondition());
        }
    }

    public AggregationCommand(String string) {
        this(string, null, null, null, null, IGNORE_NULLS_DEFAULT, ALLOW_OVERFLOW_DEFAULT, ALLOW_DIVISION_BY_ZERO_DEFAULT, MAINTAIN_COUNT_DEFAULT, null, true);
    }

    public AggregationCommand(String string, FunctionArgument[] functionArgumentArray, MdmPrimaryDimension mdmPrimaryDimension) {
        this(string, functionArgumentArray, null, mdmPrimaryDimension, null, IGNORE_NULLS_DEFAULT, ALLOW_OVERFLOW_DEFAULT, ALLOW_DIVISION_BY_ZERO_DEFAULT, MAINTAIN_COUNT_DEFAULT, null, true);
    }

    public AggregationCommand(String string, FunctionArgument[] functionArgumentArray, MdmPrimaryDimension mdmPrimaryDimension, MdmHierarchy[] mdmHierarchyArray) {
        this(string, functionArgumentArray, null, mdmPrimaryDimension, mdmHierarchyArray, IGNORE_NULLS_DEFAULT, ALLOW_OVERFLOW_DEFAULT, ALLOW_DIVISION_BY_ZERO_DEFAULT, MAINTAIN_COUNT_DEFAULT, null, true);
    }

    public AggregationCommand(String string, FunctionArgument[] functionArgumentArray, AggregationCase[] aggregationCaseArray, MdmPrimaryDimension mdmPrimaryDimension, MdmHierarchy[] mdmHierarchyArray, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(string, functionArgumentArray, aggregationCaseArray, mdmPrimaryDimension, mdmHierarchyArray, bl, bl2, bl3, bl4, null, true);
    }

    public AggregationCommand(String string, FunctionArgument[] functionArgumentArray, AggregationCase[] aggregationCaseArray, MdmPrimaryDimension mdmPrimaryDimension, MdmHierarchy[] mdmHierarchyArray, boolean bl, boolean bl2, boolean bl3, boolean bl4, Condition condition) {
        this(string, functionArgumentArray, aggregationCaseArray, mdmPrimaryDimension, mdmHierarchyArray, bl, bl2, bl3, bl4, condition, true);
    }

    public AggregationCommand(String string, List<FunctionArgument> list, List<AggregationCase> list2, MdmPrimaryDimension mdmPrimaryDimension, List<MdmHierarchy> list3, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(string, AggregationCommand.getFunctionArgumentArrayClone(list), AggregationCommand.createAggregationCaseArray(list2), mdmPrimaryDimension, AggregationCommand.createMdmHierarchyArray(list3), bl, bl2, bl3, bl4, null, false);
    }

    public AggregationCommand(String string, List<FunctionArgument> list, List<AggregationCase> list2, MdmPrimaryDimension mdmPrimaryDimension, List<MdmHierarchy> list3, boolean bl, boolean bl2, boolean bl3, boolean bl4, Condition condition) {
        this(string, AggregationCommand.getFunctionArgumentArrayClone(list), AggregationCommand.createAggregationCaseArray(list2), mdmPrimaryDimension, AggregationCommand.createMdmHierarchyArray(list3), bl, bl2, bl3, bl4, condition, false);
    }

    public AggregationCommand(String string, List<FunctionArgument> list, MdmPrimaryDimension mdmPrimaryDimension, List<MdmHierarchy> list2) {
        this(string, AggregationCommand.getFunctionArgumentArrayClone(list), null, mdmPrimaryDimension, AggregationCommand.createMdmHierarchyArray(list2), IGNORE_NULLS_DEFAULT, ALLOW_OVERFLOW_DEFAULT, ALLOW_DIVISION_BY_ZERO_DEFAULT, MAINTAIN_COUNT_DEFAULT, null, false);
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitAggregationCommand(this, object);
    }

    public MdmHierarchy[] getHierarchies() {
        if (null == this.getHierarchiesInternal()) {
            return null;
        }
        return (MdmHierarchy[])this.getHierarchiesInternal().clone();
    }

    public AggregationCase[] getAggregationCases() {
        if (null == this.getAggregationCasesInternal()) {
            return null;
        }
        return (AggregationCase[])this.getAggregationCasesInternal().clone();
    }

    public MdmPrimaryDimension getPrimaryDimension() {
        return this.m_PrimaryDimension;
    }

    public boolean getIgnoreNulls() {
        return this.m_IgnoreNulls;
    }

    public boolean getAllowOverflow() {
        return this.m_AllowOverflow;
    }

    public boolean getAllowDivisionByZero() {
        return this.m_AllowDivisionByZero;
    }

    public boolean getMaintainCount() {
        return this.m_MaintainCount;
    }

    public Condition getMembersCondition() {
        return this.m_MembersCondition;
    }
}

