/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mtm;

import java.util.List;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.mdm.MdmHierarchy;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mtm.MtmAggregationStep;
import oracle.olapi.metadata.mtm.MtmDimensionMap;
import oracle.olapi.metadata.mtm.MtmObjectVisitor;
import oracle.olapi.metadata.mtm.MtmSolveSpecification;
import oracle.olapi.metadata.mtm.MtmXMLTags;

public class MtmAggregationSpecification
extends MtmSolveSpecification {
    MtmAggregationSpecification(BaseMetadataProvider baseMetadataProvider) {
        super(baseMetadataProvider);
    }

    public Object acceptVisitor(MtmObjectVisitor mtmObjectVisitor, Object object) {
        return mtmObjectVisitor.visitMtmAggregationSpecification(this, object);
    }

    public void addAggregationStep(MtmAggregationStep mtmAggregationStep) {
        this.addToListProperty(MtmXMLTags.AGGR_STEP_REF, mtmAggregationStep);
    }

    public List getAggregationSteps() {
        return this.getPropertyListValues(MtmXMLTags.AGGR_STEP_REF);
    }

    protected XMLTag getXMLTag() {
        return MtmXMLTags.AGGR_SPEC_TAG;
    }

    protected XMLTag getPropertyXMLTag(String string, String string2) {
        if (MtmXMLTags.AGGR_STEP_REF.matches(string, string2)) {
            return MtmXMLTags.AGGR_STEP_REF;
        }
        return super.getPropertyXMLTag(string, string2);
    }

    private MtmAggregationStep findAggregationStep(MtmDimensionMap mtmDimensionMap) {
        for (MtmAggregationStep mtmAggregationStep : this.getAggregationSteps()) {
            if (!mtmAggregationStep.getDimensionMaps().contains(mtmDimensionMap)) continue;
            return mtmAggregationStep;
        }
        return null;
    }

    void addDimensionMap(MtmDimensionMap mtmDimensionMap) {
        MtmAggregationStep mtmAggregationStep = ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMtmCustomObjectFactory().createDefaultAggregationStep((MdmHierarchy)mtmDimensionMap.getMdmSource());
        this.addToListProperty(MtmXMLTags.AGGR_STEP_REF, mtmAggregationStep);
    }

    void removeDimensionMap(MtmDimensionMap mtmDimensionMap) {
        this.removeAggregationStep(mtmDimensionMap);
    }

    void removeAggregationStep(MtmDimensionMap mtmDimensionMap) {
        MtmAggregationStep mtmAggregationStep = this.findAggregationStep(mtmDimensionMap);
        if (mtmAggregationStep != null) {
            if (mtmAggregationStep.getDimensionMaps().size() > 1) {
                mtmAggregationStep.removeDimensionMap(mtmDimensionMap);
            } else {
                this.removeFromListProperty(MtmXMLTags.AGGR_STEP_REF, mtmAggregationStep);
            }
        }
    }

    void applyAggregationStep(MtmAggregationStep mtmAggregationStep) {
        for (MtmDimensionMap mtmDimensionMap : mtmAggregationStep.getDimensionMaps()) {
            this.removeAggregationStep(mtmDimensionMap);
        }
        this.addAggregationStep(mtmAggregationStep);
    }

    public final void removeAggregationStep(MtmAggregationStep mtmAggregationStep) {
        this.removeFromListProperty(MtmXMLTags.AGGR_STEP_REF, mtmAggregationStep);
    }
}

