/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mdm;

import java.util.ArrayList;
import java.util.List;
import oracle.olapi.data.source.Assignment;
import oracle.olapi.data.source.Model;
import oracle.olapi.data.source.ModelAssignmentManager;
import oracle.olapi.data.source.Qualification;
import oracle.olapi.data.source.Source;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.MetadataToXMLConverter;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.mdm.MdmAssignment;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmObject;
import oracle.olapi.metadata.mdm.MdmSource;
import oracle.olapi.metadata.mdm.MdmXMLTags;
import oracle.olapi.syntax.Expression;
import oracle.olapi.transaction.Transaction;

public abstract class MdmModel
extends MdmObject
implements Model {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{MdmXMLTags.ASSIGNMENT_REF};
    private ModelAssignmentManager m_Manager = null;

    public MdmModel(MdmMetadataProvider mdmMetadataProvider) {
        super(mdmMetadataProvider);
        this.m_Manager = new ModelAssignmentManager(this, mdmMetadataProvider.getDataProvider());
    }

    public MdmModel(String string, String string2, short s, BaseMetadataObject baseMetadataObject) {
        super(baseMetadataObject.getBaseMetadataProvider(), string2, string, s, baseMetadataObject);
        this.m_Manager = new ModelAssignmentManager(this, baseMetadataObject.getBaseMetadataProvider().getDataProvider());
    }

    protected ModelAssignmentManager getManager() {
        return this.m_Manager;
    }

    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    public abstract MdmSource getMdmSource();

    public abstract Source getType();

    public abstract List getInputs();

    public final List getOutputs() {
        return new ArrayList();
    }

    public abstract List getParentModels();

    public List getAssignments() {
        return this.getManager().getAssignments();
    }

    public List getAssignments(Transaction transaction) {
        return this.getManager().getAssignments(transaction);
    }

    public void assign(Qualification[] qualificationArray, Source source) {
        this.getManager().assign(qualificationArray, source);
    }

    public void assign(Qualification[] qualificationArray, Source source, int n) {
        this.getManager().assign(qualificationArray, source, n);
    }

    public void assign(String string, Source source) {
        this.getManager().assign(string, source);
    }

    public void assign(String string, Source source, int n) {
        this.getManager().assign(string, source, n);
    }

    public void assign(String[] stringArray, Source source) {
        this.getManager().assign(stringArray, source);
    }

    public void assign(String[] stringArray, Source source, int n) {
        this.getManager().assign(stringArray, source, n);
    }

    public void unassign(Assignment assignment) {
        this.getManager().unassign(assignment);
    }

    public int getDefaultPrecedence() {
        return this.getManager().getDefaultPrecedence();
    }

    public void setDefaultPrecedence(int n) {
        this.getManager().setDefaultPrecedence(n);
    }

    public void gatherReferencedSources(List list, Transaction transaction) {
        this.getManager().gatherReferencedSources(list, transaction);
        super.gatherReferencedSources(list, transaction);
    }

    protected void appendAdditionalXMLSubobjects(MetadataToXMLConverter metadataToXMLConverter) {
        if (metadataToXMLConverter.getXMLFormat().is10gMode()) {
            this.getManager().writeXML(metadataToXMLConverter.getWriter());
        }
        super.appendAdditionalXMLSubobjects(metadataToXMLConverter);
    }

    public final Source createSolvedSource() {
        return this.getManager().createSolvedSource();
    }

    public final Source createSolvedSource(Source source) {
        return this.getManager().createSolvedSource(source);
    }

    protected final boolean isModified(Object object, Object object2, Transaction transaction) {
        if (super.isModified(object, object2, transaction)) {
            return true;
        }
        return this.getManager().isModified(transaction);
    }

    protected final boolean isModified(long l, long l2, Transaction transaction) {
        if (super.isModified(l, l2, transaction)) {
            return true;
        }
        return this.getManager().isModified(transaction);
    }

    public final Transaction getActiveTransaction() {
        if (null == this.getManager()) {
            return null;
        }
        return this.getManager().getActiveTransaction();
    }

    public final MdmAssignment findAssignment(String string) {
        String string2 = MdmModel.generateID(new String[]{this.getID(), string});
        return (MdmAssignment)this.getMetadataProvider().fetchMetadataObject(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MdmAssignment findOrCreateAssignment(String string) {
        MdmAssignment mdmAssignment = this.findAssignment(string);
        if (null == mdmAssignment) {
            MdmMetadataProvider mdmMetadataProvider = this.getMetadataProvider();
            synchronized (mdmMetadataProvider) {
                mdmAssignment = this.findAssignment(string);
                if (null == mdmAssignment) {
                    mdmAssignment = new MdmAssignment(string, 0, this);
                }
            }
        }
        this.addToListProperty(MdmXMLTags.ASSIGNMENT_REF, mdmAssignment);
        return mdmAssignment;
    }

    public final MdmAssignment assign(String string, Expression expression) {
        MdmAssignment mdmAssignment = this.findOrCreateAssignment(string);
        mdmAssignment.setMemberExpression(expression);
        return mdmAssignment;
    }

    public final void removeMdmAssignment(MdmAssignment mdmAssignment) {
        this.removeFromListProperty(MdmXMLTags.ASSIGNMENT_REF, mdmAssignment);
    }

    public final List getMdmAssignments() {
        return this.getPropertyListValues(MdmXMLTags.ASSIGNMENT_REF);
    }
}

