/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mdm;

import java.util.List;
import oracle.express.mdm.MetadataNotFoundException;
import oracle.olapi.metadata.mdm.MdmBaseObjectVisitor;
import oracle.olapi.metadata.mdm.MdmDimension;
import oracle.olapi.metadata.mdm.MdmDimensionMemberInfo;
import oracle.olapi.metadata.mdm.MdmHierarchy;
import oracle.olapi.metadata.mdm.MdmInvalidValueException;
import oracle.olapi.metadata.mdm.MdmLevel;
import oracle.olapi.metadata.mdm.MdmLevelHierarchy;
import oracle.olapi.metadata.mdm.MdmMeasureDimension;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmObject;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.metadata.mdm.MdmSubDimension;
import oracle.olapi.metadata.mdm.MdmValueConverter;
import oracle.olapi.metadata.mdm.MdmValueHierarchy;

class MdmDefaultValueConverter
extends MdmBaseObjectVisitor
implements MdmValueConverter {
    MdmDefaultValueConverter() {
    }

    public String convertLocalValueToUniqueValue(MdmMetadataProvider mdmMetadataProvider, MdmLevel mdmLevel, String string) {
        if (mdmLevel.getPrimaryDimension() == mdmMetadataProvider.getRootSchema().getMeasureDimension()) {
            return string;
        }
        String string2 = mdmLevel.getPrimaryDimension().getValueSeparationString();
        String string3 = mdmLevel.getLevelHierarchy().getName();
        String string4 = mdmLevel.getName();
        return string3 + string2 + string4 + string2 + string;
    }

    public String convertLocalValueToUniqueValue(MdmMetadataProvider mdmMetadataProvider, MdmValueHierarchy mdmValueHierarchy, String string) {
        String string2 = mdmValueHierarchy.getPrimaryDimension().getValueSeparationString();
        String string3 = mdmValueHierarchy.getName();
        return string3 + string2 + string;
    }

    private String getField(String string, int n, MdmDimension mdmDimension) {
        int n2;
        String string2 = mdmDimension.getPrimaryDimension().getValueSeparationString();
        int n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            int n4 = string.indexOf(string2, n3);
            if (n4 == -1) {
                throw new MdmInvalidValueException();
            }
            n3 = n4 + string2.length();
        }
        n2 = string.indexOf(string2, n3);
        if (n2 == -1 || n == 2) {
            if (n2 != -1) {
                throw new MdmInvalidValueException();
            }
            n2 = string.length();
        }
        return string.substring(n3, n2);
    }

    public void convertUniqueValueToMemberInfo(MdmMetadataProvider mdmMetadataProvider, String string, MdmDimensionMemberInfo mdmDimensionMemberInfo) throws MdmInvalidValueException, MetadataNotFoundException {
        throw new MdmInvalidValueException("The default value conversion requires an MdmPrimaryDimension in addition to a unique value.");
    }

    public void convertUniqueValueToMemberInfo(MdmPrimaryDimension mdmPrimaryDimension, String string, MdmDimensionMemberInfo mdmDimensionMemberInfo) throws MdmInvalidValueException, MetadataNotFoundException {
        if (mdmDimensionMemberInfo.getUniqueValue() != string) {
            mdmDimensionMemberInfo.setUniqueValue(string);
        }
        mdmPrimaryDimension.acceptVisitor(this, mdmDimensionMemberInfo);
    }

    public MdmDimensionMemberInfo convertUniqueValueToMemberInfo(MdmDimension mdmDimension, String string) throws MdmInvalidValueException, MetadataNotFoundException {
        MdmDimensionMemberInfo mdmDimensionMemberInfo = new MdmDimensionMemberInfo(mdmDimension.getPrimaryDimension(), string);
        this.convertUniqueValueToMemberInfo(mdmDimension.getPrimaryDimension(), string, mdmDimensionMemberInfo);
        return mdmDimensionMemberInfo;
    }

    public Object visitMdmMeasureDimension(MdmMeasureDimension mdmMeasureDimension, Object object) {
        MdmDimensionMemberInfo mdmDimensionMemberInfo = (MdmDimensionMemberInfo)object;
        String string = mdmDimensionMemberInfo.getUniqueValue();
        MdmObject mdmObject = null;
        MdmHierarchy mdmHierarchy = mdmMeasureDimension.getDefaultHierarchy();
        mdmObject = mdmHierarchy instanceof MdmLevelHierarchy ? (MdmObject)((MdmLevelHierarchy)mdmHierarchy).getLevels().get(0) : mdmHierarchy;
        mdmDimensionMemberInfo.populate(mdmObject, string, string);
        return mdmDimensionMemberInfo;
    }

    public Object visitMdmPrimaryDimension(MdmPrimaryDimension mdmPrimaryDimension, Object object) {
        MdmDimensionMemberInfo mdmDimensionMemberInfo = (MdmDimensionMemberInfo)object;
        String string = mdmDimensionMemberInfo.getUniqueValue();
        String string2 = this.getField(string, 0, mdmPrimaryDimension);
        List list = mdmPrimaryDimension.getHierarchies();
        if (list.isEmpty()) {
            mdmDimensionMemberInfo.populate(mdmPrimaryDimension, string, string);
            return mdmDimensionMemberInfo;
        }
        for (MdmSubDimension mdmSubDimension : list) {
            if (!string2.equals(mdmSubDimension.getName())) continue;
            return mdmSubDimension.acceptVisitor(this, mdmDimensionMemberInfo);
        }
        throw new MetadataNotFoundException("Could not find a level hierarchy named '" + string2 + "' in union hierarchy '" + mdmPrimaryDimension.getName() + "' while processing value '" + string + "'.");
    }

    public Object visitMdmHierarchy(MdmHierarchy mdmHierarchy, Object object) {
        MdmDimensionMemberInfo mdmDimensionMemberInfo = (MdmDimensionMemberInfo)object;
        String string = mdmDimensionMemberInfo.getUniqueValue();
        if (mdmHierarchy instanceof MdmLevelHierarchy) {
            String string2 = this.getField(string, 1, mdmHierarchy);
            MdmLevelHierarchy mdmLevelHierarchy = (MdmLevelHierarchy)mdmHierarchy;
            for (MdmLevel mdmLevel : mdmLevelHierarchy.getLevels()) {
                if (!string2.equals(mdmLevel.getName())) continue;
                return this.visitMdmLevel(mdmLevel, mdmDimensionMemberInfo);
            }
            throw new MetadataNotFoundException("Could not find a level named '" + string2 + "' in level hierarchy '" + mdmLevelHierarchy.getName() + "' while processing value '" + string + "'.");
        }
        throw new MdmInvalidValueException("Unique values unsupported for value hierarchies.");
    }

    public Object visitMdmLevel(MdmLevel mdmLevel, Object object) {
        MdmDimensionMemberInfo mdmDimensionMemberInfo = (MdmDimensionMemberInfo)object;
        String string = mdmDimensionMemberInfo.getUniqueValue();
        String string2 = this.getField(string, 2, mdmLevel);
        if (!mdmLevel.getName().equals(this.getField(string, 1, mdmLevel)) || !mdmLevel.getLevelHierarchy().getName().equals(this.getField(string, 0, mdmLevel))) {
            throw new MdmInvalidValueException("Value '" + string + "' is not contained in level '" + mdmLevel.getName() + "' in level hierarchy '" + mdmLevel.getLevelHierarchy().getName() + "'.");
        }
        mdmDimensionMemberInfo.populate(mdmLevel, string2, string);
        return mdmDimensionMemberInfo;
    }
}

