/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.deployment;

import java.util.ArrayList;
import java.util.List;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.MetadataXMLReader;
import oracle.olapi.metadata.PersistentLanguageFetcher;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.deployment.AWCubeOrganization;
import oracle.olapi.metadata.deployment.AWPrimaryDimensionOrganization;
import oracle.olapi.metadata.deployment.CubeOrganization;
import oracle.olapi.metadata.deployment.DeploymentXMLTags;
import oracle.olapi.metadata.deployment.PrimaryDimensionOrganization;
import oracle.olapi.metadata.mdm.MdmCube;
import oracle.olapi.metadata.mdm.MdmDatabaseSchema;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmObject;
import oracle.olapi.metadata.mdm.MdmOrganizationalSchema;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import org.xml.sax.SAXException;

public class AW
extends BaseMetadataObject {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{DeploymentXMLTags.NAME, DeploymentXMLTags.OWNER, DeploymentXMLTags.TABLESPACE_NAME, DeploymentXMLTags.VERSION};
    public static final String AW_COMPONENT = "AW";

    AW(MdmMetadataProvider mdmMetadataProvider) {
        super(mdmMetadataProvider);
    }

    public AW(String string, String string2, short s, BaseMetadataProvider baseMetadataProvider) {
        super(baseMetadataProvider, string2, s, null);
        DeploymentXMLTags.NAME.initializeProperty((BaseMetadataObject)this, (Object)string, s);
    }

    protected XMLTag getXMLTag() {
        return DeploymentXMLTags.AW_TAG;
    }

    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    public final String getName() {
        return this.getPropertyStringValue(DeploymentXMLTags.NAME);
    }

    public final void setName(String string) {
        this.setPropertyStringValue(DeploymentXMLTags.NAME, string);
    }

    public final MdmDatabaseSchema getOwner() {
        return (MdmDatabaseSchema)this.getPropertyObjectValue(DeploymentXMLTags.OWNER);
    }

    public final void setOwner(MdmDatabaseSchema mdmDatabaseSchema) {
        this.setPropertyObjectValue(DeploymentXMLTags.OWNER, mdmDatabaseSchema);
    }

    public final String getTablespace() {
        return this.getPropertyStringValue(DeploymentXMLTags.TABLESPACE_NAME);
    }

    public final void setTablespace(String string) {
        this.setPropertyStringValue(DeploymentXMLTags.TABLESPACE_NAME, string);
    }

    public static String generateIDFromXML(BaseMetadataObject baseMetadataObject, XMLTag xMLTag, String string, String string2, String string3, MetadataXMLReader metadataXMLReader) throws SAXException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(AW_COMPONENT);
        return AW.generateIDFromXML(baseMetadataObject, xMLTag, string, string2, null, metadataXMLReader, arrayList);
    }

    public final List getDimensions() {
        ArrayList<MdmPrimaryDimension> arrayList = new ArrayList<MdmPrimaryDimension>();
        MdmDatabaseSchema mdmDatabaseSchema = this.getOwner();
        for (MdmPrimaryDimension mdmPrimaryDimension : mdmDatabaseSchema.getDimensions()) {
            PrimaryDimensionOrganization primaryDimensionOrganization = mdmPrimaryDimension.getOrganization();
            if (!(primaryDimensionOrganization instanceof AWPrimaryDimensionOrganization) || ((AWPrimaryDimensionOrganization)primaryDimensionOrganization).getAW() != this) continue;
            arrayList.add(mdmPrimaryDimension);
        }
        return arrayList;
    }

    public final List getCubes() {
        ArrayList<MdmCube> arrayList = new ArrayList<MdmCube>();
        MdmDatabaseSchema mdmDatabaseSchema = this.getOwner();
        for (MdmCube mdmCube : mdmDatabaseSchema.getCubes()) {
            CubeOrganization cubeOrganization = mdmCube.getOrganization();
            if (!(cubeOrganization instanceof AWCubeOrganization) || ((AWCubeOrganization)cubeOrganization).getAW() != this) continue;
            arrayList.add(mdmCube);
        }
        return arrayList;
    }

    public final List getOrganizationalSchemas() {
        ArrayList<MdmOrganizationalSchema> arrayList = new ArrayList<MdmOrganizationalSchema>();
        MdmDatabaseSchema mdmDatabaseSchema = this.getOwner();
        for (MdmOrganizationalSchema mdmOrganizationalSchema : mdmDatabaseSchema.getOrganizationalSchemas()) {
            if (mdmOrganizationalSchema.getAW() != this) continue;
            arrayList.add(mdmOrganizationalSchema);
        }
        return arrayList;
    }

    public List getPersistentLanguages() {
        List list = this.getCubes();
        List list2 = this.getDimensions();
        int n = list.size() + list2.size();
        String[] stringArray = new String[n];
        ArrayList arrayList = new ArrayList();
        this.addIDs(list, arrayList);
        this.addIDs(list2, arrayList);
        arrayList.toArray(stringArray);
        return PersistentLanguageFetcher.fetchPersistentLanguages(stringArray, this.getBaseMetadataProvider().getDataProvider());
    }

    private void addIDs(List list, List list2) {
        for (MdmObject mdmObject : list) {
            list2.add(mdmObject.getID());
        }
    }

    public static final XMLTag classGetContainedByPropertyTag() {
        return null;
    }

    public final String getVersion() {
        return this.getPropertyStringValue(DeploymentXMLTags.VERSION);
    }
}

