/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.conversion;

import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.conversion.LegacyXMLAWObject;
import oracle.olapi.metadata.conversion.LegacyXMLBaseObject;
import oracle.olapi.metadata.conversion.LegacyXMLConverter;
import oracle.olapi.metadata.conversion.LegacyXMLDimensionMapGroup;
import oracle.olapi.metadata.conversion.LegacyXMLHierarchy;
import oracle.olapi.metadata.conversion.LegacyXMLLevel;
import oracle.olapi.metadata.conversion.LegacyXMLTags;
import oracle.olapi.metadata.mdm.MdmDimensionLevel;
import oracle.olapi.metadata.mdm.MdmHierarchyLevel;
import oracle.olapi.metadata.mdm.MdmLevelHierarchy;

final class LegacyXMLHierarchyLevelAssociation
extends LegacyXMLAWObject {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{LegacyXMLTags.LEVEL_LC_REF};

    protected LegacyXMLHierarchyLevelAssociation(BaseMetadataProvider baseMetadataProvider) {
        super(baseMetadataProvider);
    }

    LegacyXMLLevel getLevel() {
        return (LegacyXMLLevel)this.getPropertyObjectValue(LegacyXMLTags.LEVEL_LC_REF);
    }

    LegacyXMLHierarchy getHierarchy() {
        return (LegacyXMLHierarchy)this.getContainedByObject();
    }

    LegacyXMLHierarchyLevelAssociation getParentLevel() {
        return this.getHierarchy().getParentLevel(this);
    }

    LegacyXMLHierarchyLevelAssociation getChildLevel() {
        return this.getHierarchy().getChildLevel(this);
    }

    LegacyXMLDimensionMapGroup getDimensionMapGroup() {
        return (LegacyXMLDimensionMapGroup)this.getSourceMappingGroup();
    }

    MdmHierarchyLevel getMdmHierarchyLevel() {
        return (MdmHierarchyLevel)this.getConvertToObject();
    }

    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    protected XMLTag getXMLTag() {
        return LegacyXMLTags.HIERARCHY_LEVEL_ASSOCIATION_TAG;
    }

    protected boolean validateState(LegacyXMLConverter legacyXMLConverter) {
        if (!super.validateState(legacyXMLConverter)) {
            return false;
        }
        legacyXMLConverter.validateRequiredProperty(LegacyXMLTags.LEVEL_LC_REF, this.getLevel(), this);
        if (!this.getLevel().isValid()) {
            return false;
        }
        if (this.getHierarchy().isValueHierarchy()) {
            legacyXMLConverter.reportIgnoredProperty(LegacyXMLTags.HIERARCHY_LEVEL_ASSOCIATIONS, this.getID(), this.getHierarchy(), false);
        }
        return true;
    }

    protected void convertToMdm(LegacyXMLConverter legacyXMLConverter) {
        MdmLevelHierarchy mdmLevelHierarchy = (MdmLevelHierarchy)this.getHierarchy().getMdmHierarchy();
        MdmDimensionLevel mdmDimensionLevel = this.getLevel().getMdmDimensionLevel();
        String string = this.getName();
        MdmHierarchyLevel mdmHierarchyLevel = mdmLevelHierarchy.findOrCreateHierarchyLevel(mdmDimensionLevel);
        this.setMdmHierarchyLevel(mdmHierarchyLevel);
        super.convertToMdm(legacyXMLConverter);
    }

    protected int getBaseConvertOrderNumber(LegacyXMLConverter legacyXMLConverter) {
        if (null == this.getLevel()) {
            return super.getBaseConvertOrderNumber(legacyXMLConverter);
        }
        return this.getLevel().getConvertOrderNumber(legacyXMLConverter) + 1;
    }

    void validateSubDimRefs(LegacyXMLConverter legacyXMLConverter, LegacyXMLHierarchy legacyXMLHierarchy, LegacyXMLLevel legacyXMLLevel, LegacyXMLBaseObject legacyXMLBaseObject) {
        if (this.getHierarchy() != legacyXMLHierarchy) {
            legacyXMLConverter.reportIgnoredProperty(LegacyXMLTags.HIERARCHY_REF, legacyXMLHierarchy, legacyXMLBaseObject);
        }
        if (this.getLevel() != legacyXMLLevel) {
            legacyXMLConverter.reportIgnoredProperty(LegacyXMLTags.LEVEL_REF, legacyXMLLevel, legacyXMLBaseObject);
        }
    }

    private void setMdmHierarchyLevel(MdmHierarchyLevel mdmHierarchyLevel) {
        this.setConvertToObject(mdmHierarchyLevel);
    }
}

