/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.conversion;

import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.conversion.LegacyXMLAW;
import oracle.olapi.metadata.conversion.LegacyXMLAction;
import oracle.olapi.metadata.conversion.LegacyXMLConverter;
import oracle.olapi.metadata.conversion.LegacyXMLObject;
import oracle.olapi.metadata.conversion.LegacyXMLTags;
import oracle.olapi.metadata.conversion.MetadataLegacyXMLParserCallback;
import oracle.olapi.metadata.mdm.MdmDatabaseSchema;
import oracle.olapi.metadata.mdm.MdmDescriptionType;
import oracle.olapi.metadata.mdm.MdmObject;
import oracle.olapi.metadata.mdm.MdmRootSchema;
import oracle.olapi.syntax.Expression;
import oracle.olapi.syntax.Query;

abstract class LegacyXMLBaseObject
extends LegacyXMLObject {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{LegacyXMLTags.NAME, LegacyXMLTags.LONG_NAME, LegacyXMLTags.SHORT_NAME, LegacyXMLTags.PLURAL_NAME, LegacyXMLTags.SCHEMA};

    protected LegacyXMLBaseObject(BaseMetadataProvider baseMetadataProvider) {
        super(baseMetadataProvider);
    }

    public final String getName() {
        return this.getPropertyStringValue(LegacyXMLTags.NAME);
    }

    final String getLongName() {
        return this.getPropertyStringValue(LegacyXMLTags.LONG_NAME);
    }

    final String getShortName() {
        return this.getPropertyStringValue(LegacyXMLTags.SHORT_NAME);
    }

    final String getPluralName() {
        return this.getPropertyStringValue(LegacyXMLTags.PLURAL_NAME);
    }

    final String getSchema() {
        return this.getPropertyStringValue(LegacyXMLTags.SCHEMA);
    }

    final String getSchemaName() {
        String string = this.getSchema();
        if (null != string && string.length() > 0) {
            return string;
        }
        LegacyXMLObject legacyXMLObject = (LegacyXMLObject)this.getContainedByObject();
        if (null != legacyXMLObject && legacyXMLObject instanceof LegacyXMLBaseObject) {
            return ((LegacyXMLBaseObject)legacyXMLObject).getSchemaName();
        }
        return null;
    }

    final String getLocalName() {
        String string = this.getSchemaName() + ".";
        if (0 == this.getName().indexOf(string)) {
            return this.getName().substring(string.length());
        }
        return this.getName();
    }

    final MdmDatabaseSchema getMdmDatabaseSchema(LegacyXMLConverter legacyXMLConverter) {
        MdmRootSchema mdmRootSchema = (MdmRootSchema)this.getMdmMetadataProvider().getRootSchema();
        String string = this.getSchemaName();
        if (null == string || string.length() == 0 || legacyXMLConverter.getLegacyXMLDefaultValue().equals(string)) {
            return legacyXMLConverter.getDefaultSchema();
        }
        return mdmRootSchema.getDatabaseSchema(this.getSchemaName());
    }

    final Expression toSyntaxExpression(String string) {
        return this.toSyntaxExpression(string, this.getSchemaName());
    }

    final Expression toSyntaxExpression(String string, MetadataLegacyXMLParserCallback metadataLegacyXMLParserCallback) {
        return this.toSyntaxExpression(string, this.getSchemaName(), metadataLegacyXMLParserCallback);
    }

    final Query toSyntaxQuery(String string) {
        return this.toSyntaxQuery(string, this.getSchemaName());
    }

    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    protected boolean validateState(LegacyXMLConverter legacyXMLConverter) {
        if (!super.validateState(legacyXMLConverter)) {
            return false;
        }
        LegacyXMLObject legacyXMLObject = (LegacyXMLObject)this.getContainedByObject();
        if (legacyXMLObject instanceof LegacyXMLAW || legacyXMLObject instanceof LegacyXMLAction) {
            if (null == this.getMdmDatabaseSchema(legacyXMLConverter)) {
                String[] stringArray = new String[]{this.getSchema(), this.getID()};
                legacyXMLConverter.reportError("InvalidSchema", stringArray);
            }
        } else if (!(null == this.getSchema() || this.getSchema().length() <= 0 || this.getSchema().equals(legacyXMLConverter.getLegacyXMLDefaultValue()) || legacyXMLObject instanceof LegacyXMLBaseObject && this.getSchema().equals(((LegacyXMLBaseObject)legacyXMLObject).getSchemaName()))) {
            legacyXMLConverter.reportIgnoredProperty(LegacyXMLTags.SCHEMA, this.getSchema(), this);
        }
        legacyXMLConverter.validateRequiredProperty(LegacyXMLTags.NAME, this.getName(), this);
        return true;
    }

    protected void convertToMdm(LegacyXMLConverter legacyXMLConverter) {
        if (this.getConvertToObject() instanceof MdmObject) {
            MdmObject mdmObject = (MdmObject)this.getConvertToObject();
            String string = null;
            if (null != this.getName() && this.getName().length() > 0) {
                string = this.getName();
            }
            String[] stringArray = new String[]{this.getShortName(), this.getLongName(), this.getPluralName()};
            MdmDescriptionType[] mdmDescriptionTypeArray = new MdmDescriptionType[]{MdmDescriptionType.getShortNameDescriptionType(), MdmDescriptionType.getLongNameDescriptionType(), MdmDescriptionType.getPluralNameDescriptionType()};
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = null;
                string2 = null != stringArray[i] && stringArray[i].length() > 0 ? stringArray[i] : string;
                if (null == string2) continue;
                mdmObject.setDescription(mdmDescriptionTypeArray[i], string2);
            }
        }
        super.convertToMdm(legacyXMLConverter);
    }
}

