/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.conversion;

import java.util.List;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.conversion.LegacyXMLBaseObject;
import oracle.olapi.metadata.conversion.LegacyXMLConverter;
import oracle.olapi.metadata.conversion.LegacyXMLCube;
import oracle.olapi.metadata.conversion.LegacyXMLDimension;
import oracle.olapi.metadata.conversion.LegacyXMLExtendedProperty;
import oracle.olapi.metadata.conversion.LegacyXMLMeasureFolder;
import oracle.olapi.metadata.conversion.LegacyXMLSolveGroup;
import oracle.olapi.metadata.conversion.LegacyXMLTags;
import oracle.olapi.metadata.deployment.AW;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LegacyXMLAW
extends LegacyXMLBaseObject {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{LegacyXMLTags.TABLE_SPACE, LegacyXMLTags.META_DATA_FORMAT, LegacyXMLTags.DEFAULT_LANGUAGE, LegacyXMLTags.LANGUAGES, LegacyXMLTags.DIMENSIONS, LegacyXMLTags.CUBES, LegacyXMLTags.SOLVE_GROUPS, LegacyXMLTags.MEASURE_FOLDERS, LegacyXMLTags.EXTENDED_PROPERTIES};

    protected LegacyXMLAW(BaseMetadataProvider baseMetadataProvider) {
        super(baseMetadataProvider);
    }

    String getTableSpace() {
        return this.getPropertyStringValue(LegacyXMLTags.TABLE_SPACE);
    }

    String getMetaDataFormat() {
        return this.getPropertyStringValue(LegacyXMLTags.META_DATA_FORMAT);
    }

    String getDefaultLanguage() {
        return this.getPropertyStringValue(LegacyXMLTags.DEFAULT_LANGUAGE);
    }

    String getLanguages() {
        return this.getPropertyStringValue(LegacyXMLTags.LANGUAGES);
    }

    List<LegacyXMLDimension> getDimensions() {
        return this.getPropertyListValues(LegacyXMLTags.DIMENSIONS);
    }

    List<LegacyXMLCube> getCubes() {
        return this.getPropertyListValues(LegacyXMLTags.CUBES);
    }

    List<LegacyXMLSolveGroup> getSolveGroups() {
        return this.getPropertyListValues(LegacyXMLTags.SOLVE_GROUPS);
    }

    List<LegacyXMLMeasureFolder> getMeasureFolders() {
        return this.getPropertyListValues(LegacyXMLTags.MEASURE_FOLDERS);
    }

    List<LegacyXMLExtendedProperty> getExtendedProperties() {
        return this.getPropertyListValues(LegacyXMLTags.EXTENDED_PROPERTIES);
    }

    AW getMdmAW() {
        return (AW)this.getConvertToObject();
    }

    @Override
    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    @Override
    protected XMLTag getXMLTag() {
        return LegacyXMLTags.AW_TAG;
    }

    @Override
    protected void convertToMdm(LegacyXMLConverter legacyXMLConverter) {
        AW aW = this.getMdmDatabaseSchema(legacyXMLConverter).findOrCreateAW(this.getLocalName());
        if (aW.isPersistent()) {
            legacyXMLConverter.reportError("DuplicateMetadataID", aW.getID());
        }
        if (null != this.getTableSpace() && this.getTableSpace().length() > 0) {
            aW.setTablespace(this.getTableSpace());
        }
        this.setMdmAW(aW);
        super.convertToMdm(legacyXMLConverter);
    }

    private void setMdmAW(AW aW) {
        this.setConvertToObject(aW);
    }
}

