/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata;

import oracle.olapi.metadata.BaseMetadataXMLReader;
import oracle.olapi.metadata.MetadataToXMLConverter;
import oracle.olapi.metadata.MetadataXMLFormat;

public final class XMLTagVersionInfo {
    public static final int VISIBLE_TYPE_PUBLIC = 0;
    public static final int VISIBLE_TYPE_CLIENT_RO = 1;
    public static final int VISIBLE_TYPE_NONE = 2;
    private String[] m_Versions = null;
    private int[] m_VisibilityTypes = null;

    public XMLTagVersionInfo(String[] stringArray, int[] nArray) {
        if (stringArray.length != nArray.length) {
            throw new RuntimeException("Length mismatch in XMLTagVersionInfo");
        }
        this.m_Versions = stringArray;
        this.m_VisibilityTypes = nArray;
    }

    public XMLTagVersionInfo(String string, int n) {
        this(new String[]{string}, new int[]{n});
    }

    public XMLTagVersionInfo(String string) {
        this(string, 0);
    }

    String getOldestVersion() {
        for (int i = this.m_Versions.length - 1; i >= 0; --i) {
            if (2 == this.m_VisibilityTypes[i]) continue;
            return this.m_Versions[i];
        }
        throw new RuntimeException("Oldest version not found");
    }

    boolean isReadableForVersion(BaseMetadataXMLReader baseMetadataXMLReader) {
        return this.isReadableForVersion(baseMetadataXMLReader, baseMetadataXMLReader.getXMLFormat());
    }

    private boolean isReadableForVersion(BaseMetadataXMLReader baseMetadataXMLReader, MetadataXMLFormat metadataXMLFormat) {
        int n = this.getVisibleType(metadataXMLFormat);
        if (0 == n) {
            return true;
        }
        if (1 == n) {
            return 0 != baseMetadataXMLReader.getPersistenceType();
        }
        return false;
    }

    boolean isWritableForVersion(MetadataToXMLConverter metadataToXMLConverter) {
        int n = this.getVisibleType(metadataToXMLConverter.getXMLFormat());
        return 0 == n;
    }

    String getPriorValidXmlVersion(BaseMetadataXMLReader baseMetadataXMLReader) {
        for (int i = 0; i < this.m_Versions.length && !baseMetadataXMLReader.getXMLFormat().isSameOrLaterThan(this.m_Versions[i]); ++i) {
        }
        for (int i = i + 1; i < this.m_Versions.length; ++i) {
            MetadataXMLFormat metadataXMLFormat = new MetadataXMLFormat(this.m_Versions[i]);
            if (!this.isReadableForVersion(baseMetadataXMLReader, metadataXMLFormat)) continue;
            return this.m_Versions[i];
        }
        return null;
    }

    private int getVisibleType(MetadataXMLFormat metadataXMLFormat) {
        for (int i = 0; i < this.m_Versions.length; ++i) {
            if (!metadataXMLFormat.isSameOrLaterThan(this.m_Versions[i])) continue;
            return this.m_VisibilityTypes[i];
        }
        return 2;
    }
}

