/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.olapi.metadata.MetadataObjectClass;
import oracle.olapi.metadata.mdm.MdmAttribute;
import oracle.olapi.metadata.mdm.MdmMeasure;
import oracle.olapi.metadata.mdm.MdmQueryColumn;
import oracle.olapi.syntax.parser.Identifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class XMLRenameMap {
    private Map<Identifier, RenameNode> m_RenameMapXMLIDToNewID = new HashMap<Identifier, RenameNode>();
    private Map<Identifier, Identifier> m_RenameMapNewIDToXMLID = new HashMap<Identifier, Identifier>();

    XMLRenameMap() {
    }

    void addRename(Identifier identifier, Identifier identifier2, MetadataObjectClass metadataObjectClass) {
        RenameNode renameNode = this.getRenameNode(identifier);
        renameNode.addID(identifier2, metadataObjectClass);
        this.getReverseRenameMap().put(identifier2, identifier);
    }

    Identifier getNewIdFromXmlId(Identifier identifier, MetadataObjectClass metadataObjectClass) {
        return this.getRenameMap().get(identifier).getID(metadataObjectClass);
    }

    Identifier getXmlIdFromNewId(Identifier identifier) {
        return this.getReverseRenameMap().get(identifier);
    }

    boolean containsXmlId(Identifier identifier) {
        return this.getRenameMap().containsKey(identifier);
    }

    boolean containsNewId(Identifier identifier) {
        return this.getReverseRenameMap().containsKey(identifier);
    }

    private Map<Identifier, RenameNode> getRenameMap() {
        return this.m_RenameMapXMLIDToNewID;
    }

    private Map<Identifier, Identifier> getReverseRenameMap() {
        return this.m_RenameMapNewIDToXMLID;
    }

    private RenameNode getRenameNode(Identifier identifier) {
        return this.getRenameNodeFromMap(this.getRenameMap(), identifier);
    }

    private RenameNode getRenameNodeFromMap(Map<Identifier, RenameNode> map, Identifier identifier) {
        if (map.containsKey(identifier)) {
            return map.get(identifier);
        }
        RenameNode renameNode = new RenameNode();
        map.put(identifier, renameNode);
        return renameNode;
    }

    static final class RenameNode {
        ArrayList<Identifier> m_IDs = new ArrayList();
        ArrayList<MetadataObjectClass> m_ObjectClasses = new ArrayList();

        RenameNode() {
        }

        void addID(Identifier identifier, MetadataObjectClass metadataObjectClass) {
            this.m_IDs.add(identifier);
            this.m_ObjectClasses.add(metadataObjectClass);
        }

        Identifier getID(MetadataObjectClass metadataObjectClass) {
            for (int i = 0; i < this.m_IDs.size(); ++i) {
                Identifier identifier = this.m_IDs.get(i);
                MetadataObjectClass metadataObjectClass2 = this.m_ObjectClasses.get(i);
                if (!this.isAssignableFrom(metadataObjectClass, metadataObjectClass2)) continue;
                return identifier;
            }
            return null;
        }

        private boolean isAssignableFrom(MetadataObjectClass metadataObjectClass, MetadataObjectClass metadataObjectClass2) {
            if (MdmQueryColumn.class == metadataObjectClass.getObjectClass() && (MdmMeasure.class.isAssignableFrom(metadataObjectClass2.getObjectClass()) || MdmAttribute.class.isAssignableFrom(metadataObjectClass2.getObjectClass()))) {
                return true;
            }
            return metadataObjectClass.isAssignableFrom(metadataObjectClass2);
        }
    }
}

