/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.data.source;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import oracle.olapi.data.source.DataDescriptorDefinitionVisitor;
import oracle.olapi.data.source.ImmutableDefinition;
import oracle.olapi.data.source.Model;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.SourceDefinition;
import oracle.olapi.transaction.Transaction;

public final class ConstantListDefinition
extends ImmutableDefinition {
    private SourceDefinition m_Type = null;
    private SourceDefinition m_ElementType = null;
    private List m_UnmodifiableElements = null;
    private Model m_CalculationModel = null;

    ConstantListDefinition(List list, SourceDefinition sourceDefinition, SourceDefinition sourceDefinition2, Transaction transaction) {
        super(sourceDefinition2.getDataProvider()._getSourceIDProvider().createConstantListID(), sourceDefinition2.getDataProvider(), transaction);
        this.setUnmodifiableElements(Collections.unmodifiableList(list));
        this.setType(sourceDefinition2);
        this.setElementType(sourceDefinition);
    }

    public final Object acceptVisitor(DataDescriptorDefinitionVisitor dataDescriptorDefinitionVisitor, Object object) {
        return dataDescriptorDefinitionVisitor.visitConstantListDefinition(this, object);
    }

    final void accumulateInputs(Set set, Transaction transaction, boolean bl, boolean bl2) {
    }

    final void accumulateOutputs(List list, Transaction transaction) {
        Object e = this.getUnmodifiableElements().get(0);
        if (e instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)e;
            for (int i = arrayList.size() - 1; i > 0; --i) {
                list.add(this.getDataProvider().getConstantDataType(arrayList.get(i)).getSource());
            }
        }
    }

    public Model findOrCreateExtractModel(Source source, Transaction transaction) {
        return this.getCalculationModel();
    }

    public final Model getCalculationModel() {
        return this.m_CalculationModel;
    }

    public final List getElements() {
        return this.getElements(0);
    }

    public final List getElements(int n) {
        return this.getUnmodifiableElements(n);
    }

    public final List getTuples() {
        return this.getUnmodifiableElements();
    }

    protected final SourceDefinition getType() {
        return this.m_Type;
    }

    protected final SourceDefinition getElementType() {
        return this.m_ElementType;
    }

    void accumulateElementOutputsList(List list, List list2, Transaction transaction) {
        if (list.isEmpty()) {
            return;
        }
        if (!(list.get(0) instanceof SourceDefinition)) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        int n = -1;
        for (SourceDefinition sourceDefinition : list) {
            ArrayList arrayList2 = new ArrayList();
            arrayList.add(arrayList2);
            sourceDefinition.accumulateOutputs(arrayList2, transaction);
            if (-1 == n) {
                n = arrayList2.size();
            } else if (arrayList2.size() < n) {
                n = arrayList2.size();
            }
            if (0 != n) continue;
            break;
        }
        for (int i = 0; i < n; ++i) {
            SourceDefinition sourceDefinition;
            sourceDefinition = null;
            for (List list3 : arrayList) {
                Source source = (Source)list3.get(i);
                SourceDefinition sourceDefinition2 = source.getDefinition();
                if (null == sourceDefinition) {
                    sourceDefinition = sourceDefinition2;
                    continue;
                }
                sourceDefinition = sourceDefinition.getCommonType(sourceDefinition2, transaction);
            }
            list2.add(sourceDefinition.getSource());
        }
    }

    void accumulateElementOutputs(List list, Transaction transaction) {
        Object e = this.getUnmodifiableElements().get(0);
        if (e instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)e;
            for (int i = arrayList.size() - 1; i > 0; --i) {
                list.add(this.getDataProvider().getConstantDataType(arrayList.get(i)).getSource());
            }
        } else {
            this.accumulateElementOutputsList(this.getUnmodifiableElements(), list, transaction);
        }
    }

    private final List getUnmodifiableElements() {
        return this.m_UnmodifiableElements;
    }

    private final List getUnmodifiableElements(int n) {
        ArrayList arrayList = this.getUnmodifiableElements();
        Object e = arrayList.get(0);
        if (e instanceof ArrayList) {
            ArrayList arrayList2 = null;
            arrayList = new ArrayList(this.getUnmodifiableElements().size());
            for (int i = 0; i < this.getUnmodifiableElements().size(); ++i) {
                arrayList2 = (ArrayList)this.getUnmodifiableElements().get(i);
                arrayList.add(arrayList2.get(n));
            }
        }
        return arrayList;
    }

    final void setCalculationModel(Model model) {
        this.m_CalculationModel = model;
    }

    private final void setType(SourceDefinition sourceDefinition) {
        this.m_Type = sourceDefinition;
    }

    private final void setElementType(SourceDefinition sourceDefinition) {
        this.m_ElementType = sourceDefinition;
    }

    private final void setUnmodifiableElements(List list) {
        this.m_UnmodifiableElements = list;
    }
}

