/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.xml;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.listener.model.ListenerModel;
import oracle.dbtools.listener.nosql.NoSQLExportStores;
import oracle.dbtools.listener.utils.ListenerZipFileWriter;
import oracle.dbtools.listener.xml.ListenerImportAdmin;
import oracle.dbtools.listener.xml.ListenerXMLUtils;

public class ListenerExportAdmin {
    private ListenerModel _model;
    private ListenerXMLUtils _xmlUtils;
    private ListenerZipFileWriter _zip;
    private boolean _isPreserveSettings;

    public ListenerExportAdmin(ListenerModel listenerModel) {
        this._model = listenerModel;
    }

    public boolean exportAdministration(File file, String string, boolean bl) {
        return this.exportAdministration(file.getAbsolutePath(), string, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exportAdministration(String string, String string2, boolean bl) {
        boolean bl2 = false;
        try {
            this._isPreserveSettings = bl;
            this.initExport(string, string2);
            this.exportGlobalSettings(this._model);
            this.exportDBSettings(this._model);
            this.exportURLMappings(this._model);
            NoSQLExportStores.exportNoSQLStores(this._zip, this._model.getNoSQLStores());
            bl2 = true;
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        finally {
            this.closeExport();
        }
        return bl2;
    }

    private void initExport(String string, String string2) throws IOException {
        this._zip = new ListenerZipFileWriter();
        this._zip.openFile(string, string2);
        this._xmlUtils = ListenerXMLUtils.getInstance();
    }

    private void exportGlobalSettings(ListenerModel listenerModel) throws IOException {
        this._zip.addEntry(this.getFileName("defaults"));
        Properties properties = null;
        if (this._isPreserveSettings) {
            properties = ListenerImportAdmin.getInstance().getGlobalSettingsProperties();
        }
        this.exportSettings(listenerModel, null, properties);
    }

    private void exportDBSettings(ListenerModel listenerModel) throws IOException {
        if (listenerModel.getChildren() != null) {
            for (ListenerModel listenerModel2 : listenerModel.getChildren()) {
                if (listenerModel2.getConnectionSettings() != null && this.containsValue(listenerModel2.getConnectionSettings().getUserName()) && this.containsValue(listenerModel2.getConnectionSettings().getPassword())) {
                    String string = "conf/" + this.getFileName(listenerModel2.getName());
                    this._zip.addEntry(string);
                    Properties properties = null;
                    if (this._isPreserveSettings) {
                        properties = ListenerImportAdmin.getInstance().getDBSettingsProperties(string);
                    }
                    this.exportSettings(listenerModel, listenerModel2, properties);
                }
                this.exportRESTUsers(listenerModel, listenerModel2, "conf/" + listenerModel2.getName());
            }
        }
    }

    private void exportRESTUsers(ListenerModel listenerModel, ListenerModel listenerModel2, String string) throws IOException {
        if (this.containsValue(listenerModel2.getConnectionSettings().getListenerPassword()) && this.containsValue(listenerModel2.getConnectionSettings().getListenerPassword())) {
            this.exportRESTUser(listenerModel, listenerModel2, string + "_al", "APEX_LISTENER");
            this.exportRESTUser(listenerModel, listenerModel2, string + "_rt", "APEX_REST_PUBLIC_USER");
        }
        if (this.containsValue(listenerModel2.getConnectionSettings().getPublicPassword())) {
            this.exportRESTUser(listenerModel, listenerModel2, string + "_pu", "ORDS_PUBLIC_USER");
        }
    }

    private void exportRESTUser(ListenerModel listenerModel, ListenerModel listenerModel2, String string, String string2) throws IOException {
        String string3 = this.getFileName(string);
        this._zip.addEntry(string3);
        Properties properties = null;
        if (this._isPreserveSettings) {
            properties = ListenerImportAdmin.getInstance().getRESTSettingsProperties(string3);
        }
        String string4 = this._xmlUtils.formatRESTUserToXML(listenerModel, listenerModel2, string2, properties);
        this._zip.writeText(string4);
    }

    private void exportURLMappings(ListenerModel listenerModel) throws IOException {
        this._zip.addEntry("url-mapping.xml");
        String string = this._xmlUtils.formatURLMappingsToXML(listenerModel);
        this._zip.writeText(string);
    }

    private void exportSettings(ListenerModel listenerModel, ListenerModel listenerModel2, Properties properties) throws IOException {
        String string = this._xmlUtils.formatSettingsToXML(listenerModel, listenerModel2, properties);
        this._zip.writeText(string);
    }

    private void closeExport() {
        try {
            this._zip.closeFile();
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    private String getFileName(String string) {
        return string + ".xml";
    }

    private boolean containsValue(String string) {
        return string != null && !string.isEmpty() && string.trim() != "";
    }
}

