/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.utils;

import java.io.IOException;
import java.io.InputStream;
import oracle.dbtools.http.SessionException;
import oracle.dbtools.listener.ListenerArb;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;

public abstract class ListenerZipFileHandler<V>
implements ResponseHandler<V> {
    public final V handleResponse(HttpResponse httpResponse) throws IOException {
        StatusLine statusLine = httpResponse.getStatusLine();
        int n = statusLine.getStatusCode();
        if (n != 200) {
            throw new IOException((Throwable)new SessionException(statusLine.getReasonPhrase()));
        }
        Header header = httpResponse.getFirstHeader("Content-Type");
        if (header == null) {
            throw new IOException(ListenerArb.getString("MISSING_CONTENT_TYPE"));
        }
        String string = header.getValue();
        if (!"application/zip".equals(string)) {
            throw new IOException("Unexpected Content-Type: " + string);
        }
        HttpEntity httpEntity = null;
        InputStream inputStream = null;
        try {
            httpEntity = httpResponse.getEntity();
            if (httpEntity == null) {
                throw new IOException("Error obtaining the zip file.  Entity is null");
            }
            inputStream = httpEntity.getContent();
            V v = this.load(inputStream);
            return v;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (httpEntity != null) {
                EntityUtils.consume((HttpEntity)httpEntity);
            }
        }
    }

    protected abstract V load(InputStream var1) throws IOException;
}

