/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JPanel;
import oracle.dbtools.common.util.Passwords;
import oracle.dbtools.listener.model.ListenerConnectionSettings;
import oracle.dbtools.listener.model.ListenerModel;
import oracle.dbtools.listener.ui.ListenerSettings;
import oracle.dbtools.listener.ui.ListenerUserPasswdPanel;
import oracle.dbtools.raptor.ui.LayoutControl;

public class ListenerPLSQLGatewayUserPanel
extends ListenerSettings {
    ListenerUserPasswdPanel _userPanel;

    public ListenerPLSQLGatewayUserPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this._userPanel = new ListenerUserPasswdPanel("PLSQL_GATEWAY_DESCRIP", true, false);
        int n = 0;
        JPanel jPanel = LayoutControl.GBC.createPanel();
        jPanel.add((Component)this._userPanel, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        LayoutControl.GBC.addVSpring((JPanel)jPanel, (int)(++n));
        this.addSettingsPanel(jPanel);
    }

    @Override
    public void assignSettings(ListenerModel listenerModel, ListenerModel listenerModel2) {
        this.initSettings(listenerModel, listenerModel2, "PLSQLGatewayConnections");
        this.assignSettings(this._model);
    }

    @Override
    public void assignSettings(ListenerModel listenerModel) {
        if (listenerModel != null && listenerModel.getConnectionSettings() != null) {
            ListenerConnectionSettings listenerConnectionSettings = listenerModel.getConnectionSettings();
            this._userPanel.setUsername(listenerConnectionSettings.getUserName());
            this._userPanel.setPasswords(listenerConnectionSettings.getPassword());
            if (this._parentModel != null) {
                this.highlightGlobalValues(this._parentModel);
            } else {
                this._userPanel.setGlobalSetting(true);
            }
        }
    }

    @Override
    public ListenerModel getSettings() {
        if (this._model != null && this._model.getConnectionSettings() != null) {
            ListenerConnectionSettings listenerConnectionSettings = this._model.getConnectionSettings();
            listenerConnectionSettings.setUserName(this._userPanel.getUsername());
            listenerConnectionSettings.setPassword(this._userPanel.getPassword());
        }
        return this._model;
    }

    @Override
    public void highlightGlobalValues(ListenerModel listenerModel) {
        String string = listenerModel.getConnectionSettings().getDefaultPassword();
        if (string != null && !string.isEmpty() && string.trim().length() > 0 && string.startsWith("@")) {
            string = string.length() > 1 ? Passwords.comingIn((String)string.substring(1)) : "";
        }
        this.updateTextHandler(this._userPanel.getPasswordField(), string);
        this.updateTextHandler(this._userPanel.getConfirmPasswordField(), string);
    }

    @Override
    public boolean validateInfo() {
        if (this._userPanel.validInfo()) {
            return true;
        }
        this._userPanel.showErrors("PLSQL_GATEWAY_USER_NODE");
        return false;
    }

    @Override
    public boolean resetSettings() {
        if (this._parentModel != null && this._parentModel.getConnectionSettings() != null) {
            ListenerConnectionSettings listenerConnectionSettings = this._parentModel.getConnectionSettings();
            this._userPanel.setPasswords(listenerConnectionSettings.getDefaultPassword());
            if (this._parentModel != null) {
                this.highlightGlobalValues(this._parentModel);
            } else {
                this._userPanel.setGlobalSetting(true);
            }
            return true;
        }
        return false;
    }
}

