/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.listener.ListenerArb;
import oracle.dbtools.listener.model.ListenerCacheSettings;
import oracle.dbtools.listener.model.ListenerModel;
import oracle.dbtools.listener.ui.ListenerSettings;
import oracle.ide.util.ResourceUtils;

public class ListenerCacheOptionsPanel
extends ListenerSettings {
    private JTextField _directory;

    public ListenerCacheOptionsPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(300, 275));
        this._directory = new JTextField();
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._directory, (String)ListenerArb.getString("CACHE_FILE_LOCATION"));
        int n = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 2, new Insets(8, 8, 0, 6), 0, 0));
        jPanel.add((Component)this._directory, new GridBagConstraints(1, n, 1, 1, 0.5, 0.0, 23, 2, new Insets(8, 0, 0, 8), 0, 0));
        n = 0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)jPanel, new GridBagConstraints(0, ++n, 1, 1, 0.5, 0.0, 23, 2, new Insets(8, 8, 8, 8), 0, 0));
        jPanel2.add(Box.createGlue(), new GridBagConstraints(0, ++n, 1, 1, 0.3, 0.3, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addSettingsPanel(jPanel2);
    }

    @Override
    public void assignSettings(ListenerModel listenerModel, ListenerModel listenerModel2) {
        this.initSettings(listenerModel, listenerModel2, "Caching");
        if (this._model != null && this._model.getCacheSettings() != null) {
            this.assignSettings(this._model);
        }
    }

    @Override
    public void assignSettings(ListenerModel listenerModel) {
        if (listenerModel != null && listenerModel.getCacheSettings() != null) {
            this._directory.setText(listenerModel.getCacheSettings().getDirectory());
            if (this._parentModel != null) {
                this.highlightGlobalValues(this._parentModel);
            }
        }
    }

    @Override
    public ListenerModel getSettings() {
        if (this._model != null && this._model.getCacheSettings() != null) {
            ListenerCacheSettings listenerCacheSettings = this._model.getCacheSettings();
            listenerCacheSettings.setDirectory(this._directory.getText());
        }
        return this._model;
    }

    @Override
    public void highlightGlobalValues(ListenerModel listenerModel) {
        this.updateTextHandler(this._directory, listenerModel.getCacheSettings().getDirectory());
    }

    @Override
    public boolean isGlobalSettingsChange() {
        if (this._parentModel == null) {
            ListenerCacheSettings listenerCacheSettings = this._model.getCacheSettings();
            if (this._directory.getText() != listenerCacheSettings.getDirectory()) {
                return true;
            }
        }
        return false;
    }
}

