/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.nosql.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.listener.ListenerArb;
import oracle.dbtools.listener.model.NoSQLStoreConfig;
import oracle.dbtools.listener.nosql.NoSQLConstants;
import oracle.dbtools.listener.nosql.ui.NoSQLStorePanel;
import oracle.dbtools.listener.ui.ListenerPanel;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;

public class NoSQLStoreAdd
implements ActionListener {
    private JEWTDialog _dialog;
    private NoSQLStorePanel _storePanel = new NoSQLStorePanel(false);
    private String _errMsg;

    public static boolean addNoSQLStore(String string) {
        return new NoSQLStoreAdd().addStore(string);
    }

    private NoSQLStoreAdd() {
    }

    private boolean addStore(String string) {
        if (this.runDialog()) {
            NoSQLStoreConfig noSQLStoreConfig = this.getNoSQLStore();
            String string2 = string + File.separator + "nosql" + File.separator + noSQLStoreConfig.getStoreAlias();
            File file = new File(string2);
            try {
                if (file.mkdirs()) {
                    noSQLStoreConfig.setStoreMode(NoSQLConstants.StoreMode.ADD);
                    noSQLStoreConfig.setStorePath(file.getPath());
                    ListenerPanel.getInstance().newNoSQLStore(noSQLStoreConfig);
                    return true;
                }
                this._errMsg = ListenerArb.format("NOSQL_ERR_CREATE_STORE_ERROR", file.getPath());
                Logger.warn(this.getClass(), (String)this._errMsg);
                this.showError(this._errMsg);
            }
            catch (Exception exception) {
                this._errMsg = exception.getLocalizedMessage();
                Logger.warn(this.getClass(), (String)this._errMsg);
                this.showError(this._errMsg);
            }
        }
        return false;
    }

    private void initDialog() {
        JPanel jPanel = this.getNoSQLStorePanel();
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_nosql_add_store_html");
        this._dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, null, (String)ListenerArb.getString("NOSQL_ADD"), (int)14);
        this._dialog.addActionListener((ActionListener)this);
        Dimension dimension = new Dimension(450, 450);
        this._dialog.setMinimumSize(dimension);
        this._dialog.setPreferredSize(dimension);
        this._dialog.setSize(dimension);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this._dialog);
    }

    private JPanel getNoSQLStorePanel() {
        return this._storePanel.getNoSQLStoreConfigPanel();
    }

    private boolean validInfo() {
        return this._storePanel.validateInfo();
    }

    private void showError() {
        this.showError(this._errMsg);
    }

    private void showError(String string) {
        MessageDialog.error((Component)this._dialog, (Object)this._errMsg, (String)ListenerArb.format("ERROR_TITLE", ListenerArb.getString("NOSQL_STORE_CONFIG")), null);
    }

    public NoSQLStoreConfig getNoSQLStore() {
        return this._storePanel.getValues();
    }

    public boolean runDialog() {
        boolean bl = false;
        try {
            this.initDialog();
            bl = WizardLauncher.runDialog((JDialog)this._dialog);
        }
        catch (Exception exception) {
        }
        finally {
            if (this._dialog != null) {
                this._dialog.removeActionListener((ActionListener)this);
                this._dialog.dispose();
                this._dialog = null;
            }
        }
        return bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.validInfo()) {
            this._dialog.dispose();
        } else {
            this.showError();
        }
    }
}

