/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.nosql.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.dbtools.listener.ListenerArb;
import oracle.ide.controls.Toolbar;
import oracle.javatools.icons.OracleIcons;

public class NoSQLRolesPanel
extends JPanel {
    private static final int ROLE_COL = 0;
    private JTable _table;
    private DefaultTableModel _tableModel;

    public NoSQLRolesPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(150, 125));
        this._tableModel = new DefaultTableModel();
        this._tableModel.addColumn(ListenerArb.getString("NOSQL_ROLE"));
        this._table = new JTable(this._tableModel){

            @Override
            public TableCellEditor getCellEditor(int n, int n2) {
                switch (n2) {
                    case 0: {
                        return new DefaultCellEditor(new JTextField());
                    }
                }
                return new DefaultCellEditor(new JTextField());
            }

            @Override
            public TableCellRenderer getCellRenderer(int n, int n2) {
                return new CustomCellRenderer();
            }
        };
        this._table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        JScrollPane jScrollPane = new JScrollPane(this._table);
        JButton jButton = new JButton();
        jButton.setIcon(OracleIcons.getIcon((String)"add.png"));
        JButton jButton2 = new JButton();
        jButton2.setIcon(OracleIcons.getIcon((String)"delete.png"));
        Toolbar toolbar = new Toolbar();
        toolbar.setFloatable(false);
        toolbar.add((Component)jButton);
        toolbar.add((Component)jButton2);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add((Component)toolbar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        int n = 0;
        this.add((Component)jPanel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 23, 2, new Insets(8, 0, 0, 8), 0, 0));
        this.add((Component)jScrollPane, new GridBagConstraints(0, ++n, 1, 2, 1.0, 1.0, 23, 1, new Insets(0, 0, 0, 8), 0, 0));
        this._table.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (NoSQLRolesPanel.this._table.getEditingColumn() > -1 && NoSQLRolesPanel.this._table.getEditingRow() > -1) {
                    NoSQLRolesPanel.this._table.getCellEditor(NoSQLRolesPanel.this._table.getEditingRow(), NoSQLRolesPanel.this._table.getEditingColumn()).stopCellEditing();
                }
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NoSQLRolesPanel.this.addRow(null);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                while (NoSQLRolesPanel.this._table.getSelectedRowCount() > 0) {
                    NoSQLRolesPanel.this._tableModel.removeRow(NoSQLRolesPanel.this._table.getSelectedRow());
                }
            }
        });
    }

    private void addRow(String string) {
        this._tableModel.addRow(new Object[]{string});
    }

    public void addRoles(List<String> list) {
        if (list != null) {
            for (String string : list) {
                this.addRow(string);
            }
        }
    }

    public List<String> getRoleList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this._table != null && this._table.getCellEditor() != null && this._table.isEditing()) {
            this._table.getCellEditor().stopCellEditing();
        }
        for (int i = 0; i < this._table.getRowCount(); ++i) {
            String string = (String)this._table.getModel().getValueAt(i, 0);
            arrayList.add(string);
        }
        return arrayList;
    }

    class CustomCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        CustomCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (bl2) {
                component.setBackground(Color.BLUE);
                component.setForeground(Color.WHITE);
            } else {
                component.setBackground(Color.WHITE);
                component.setForeground(Color.BLACK);
            }
            return component;
        }
    }
}

