/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.nosql.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.dbtools.listener.ListenerArb;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.WholeNumberField;
import oracle.javatools.icons.OracleIcons;

public class NoSQLHostPortPanel
extends JPanel {
    private static final int HOST_COL = 0;
    private static final int PORT_COL = 1;
    private static final String COLON = ":";
    private JTable _table;
    private DefaultTableModel _tableModel;
    private StringBuilder errMsgs = new StringBuilder();

    public NoSQLHostPortPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(150, 125));
        this._tableModel = new DefaultTableModel();
        this._tableModel.addColumn(ListenerArb.getString("NOSQL_HOST"));
        this._tableModel.addColumn(ListenerArb.getString("NOSQL_PORT"));
        this._table = new JTable(this._tableModel){

            @Override
            public TableCellEditor getCellEditor(int n, int n2) {
                switch (n2) {
                    case 0: {
                        return new DefaultCellEditor(new JTextField());
                    }
                    case 1: {
                        return new WholeNumberEditor();
                    }
                }
                return new DefaultCellEditor(new JTextField());
            }

            @Override
            public TableCellRenderer getCellRenderer(int n, int n2) {
                return new CustomCellRenderer();
            }
        };
        this._table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        JScrollPane jScrollPane = new JScrollPane(this._table);
        JButton jButton = new JButton();
        jButton.setIcon(OracleIcons.getIcon((String)"add.png"));
        JButton jButton2 = new JButton();
        jButton2.setIcon(OracleIcons.getIcon((String)"delete.png"));
        Toolbar toolbar = new Toolbar();
        toolbar.setFloatable(false);
        toolbar.add((Component)jButton);
        toolbar.add((Component)jButton2);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add((Component)toolbar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        int n = 0;
        this.add((Component)jPanel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 23, 2, new Insets(8, 0, 0, 8), 0, 0));
        this.add((Component)jScrollPane, new GridBagConstraints(0, ++n, 1, 2, 1.0, 1.0, 23, 1, new Insets(0, 0, 0, 8), 0, 0));
        this.add(Box.createHorizontalGlue(), new GridBagConstraints(0, ++n, 1, 1, 1.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this._table.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (NoSQLHostPortPanel.this._table.getEditingColumn() > -1 && NoSQLHostPortPanel.this._table.getEditingRow() > -1) {
                    NoSQLHostPortPanel.this._table.getCellEditor(NoSQLHostPortPanel.this._table.getEditingRow(), NoSQLHostPortPanel.this._table.getEditingColumn()).stopCellEditing();
                }
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NoSQLHostPortPanel.this.addRow(null, 5000);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                while (NoSQLHostPortPanel.this._table.getSelectedRowCount() > 0) {
                    NoSQLHostPortPanel.this._tableModel.removeRow(NoSQLHostPortPanel.this._table.getSelectedRow());
                }
            }
        });
    }

    public void addRow(String string, int n) {
        this._tableModel.addRow(new Object[]{string, n});
    }

    public String getErrorMessages() {
        if (this.errMsgs != null) {
            return this.errMsgs.toString();
        }
        return "";
    }

    public void addHostPorts(List<String> list) {
        if (list != null) {
            for (String string : list) {
                this.addHostPort(string);
            }
        }
    }

    public void addHostPort(String string) {
        if (string != null) {
            String[] stringArray = string.split(COLON);
            this.addRow(stringArray[0], Integer.parseInt(stringArray[1]));
        }
    }

    public List<String> getHostColonPortList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this._table != null && this._table.getCellEditor() != null && this._table.isEditing()) {
            this._table.getCellEditor().stopCellEditing();
        }
        for (int i = 0; i < this._table.getRowCount(); ++i) {
            String string = (String)this._table.getModel().getValueAt(i, 0);
            Integer n = (Integer)this._table.getModel().getValueAt(i, 1);
            String string2 = string + COLON + n.toString();
            arrayList.add(string2);
        }
        return arrayList;
    }

    public boolean validateInfo() {
        if (this._table != null && this._table.getCellEditor() != null && this._table.isEditing()) {
            this._table.getCellEditor().stopCellEditing();
        }
        if (this.errMsgs.length() > 0) {
            this.errMsgs.delete(0, this.errMsgs.length());
        }
        int n = 0;
        for (int i = 0; i < this._table.getRowCount(); ++i) {
            String string = (String)this._table.getModel().getValueAt(i, 0);
            Integer n2 = (Integer)this._table.getModel().getValueAt(i, 1);
            if ((string == null || string.trim().length() == 0) && n2 == null) continue;
            if ((string == null || string.trim().length() == 0) && n2 != null) {
                this.errMsgs.append(ListenerArb.format("ROW", String.valueOf(i))).append(" ").append(ListenerArb.format("NOSQL_ERR_MISSING", ListenerArb.getString("NOSQL_HOST"), ListenerArb.getString("NOSQL_HOST"))).append("\n");
                continue;
            }
            if (string != null && string.trim().length() > 0 && n2 == null) {
                this.errMsgs.append(ListenerArb.format("ROW", String.valueOf(i))).append(" ").append(ListenerArb.format("NOSQL_ERR_MISSING", ListenerArb.getString("NOSQL_PORT"), ListenerArb.getString("NOSQL_PORT"))).append("\n");
                continue;
            }
            ++n;
        }
        if (this.errMsgs.length() > 0) {
            return false;
        }
        if (n == 0) {
            this.errMsgs.append(ListenerArb.format("NOSQL_ERR_REQUIRED", ListenerArb.getString("NOSQL_HOST"), ListenerArb.getString("NOSQL_HOST"))).append("\n");
            this.errMsgs.append(ListenerArb.format("NOSQL_ERR_REQUIRED", ListenerArb.getString("NOSQL_PORT"), ListenerArb.getString("NOSQL_PORT"))).append("\n");
            return false;
        }
        return true;
    }

    class CustomCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        CustomCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (bl2) {
                component.setBackground(Color.BLUE);
                component.setForeground(Color.WHITE);
            } else {
                component.setBackground(Color.WHITE);
                component.setForeground(Color.BLACK);
            }
            return component;
        }
    }

    class WholeNumberEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        WholeNumberField numField = new WholeNumberField(5);

        WholeNumberEditor() {
        }

        @Override
        public Object getCellEditorValue() {
            return this.numField.getValue();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.numField.setValue(((Integer)object).intValue());
            return this.numField;
        }
    }
}

