/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyEditor;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import oracle.bali.inspector.PropertyEditorAdapter;
import oracle.bali.inspector.PropertyEditorFactory;
import oracle.bali.inspector.PropertyModel;

class PropertyEditorRenderer
extends JPanel
implements TableCellRenderer {
    private static final PropertyEditorRenderer _sINSTANCE = new PropertyEditorRenderer();
    private PropertyEditor _editor;
    private Map<Object, PropertyEditor> editorsByValue = new WeakHashMap<Object, PropertyEditor>();

    private PropertyEditorRenderer() {
    }

    public static TableCellRenderer getTableCellRenderer() {
        return _sINSTANCE;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        PropertyModel model = (PropertyModel)table.getModel();
        PropertyEditorFactory editorFactory = model.getPropertyEditorFactory(row);
        this._editor = editorFactory instanceof PropertyEditorAdapter ? ((PropertyEditorAdapter)editorFactory).getPropertyEditor() : null;
        this.editorsByValue.put(value, this._editor);
        this.setOpaque(true);
        return this;
    }

    public void paintComponent(Graphics g) {
        if (this._editor != null) {
            Rectangle r = this.getBounds();
            r.x = 0;
            r.y = 0;
            Color c = g.getColor();
            g.setColor(this.getBackground());
            g.fillRect(r.x, r.y, r.width, r.height);
            g.setColor(c);
            this._editor.paintValue(g, r);
        }
    }

    @Deprecated
    PropertyEditor __getEditor() {
        return this._editor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PropertyEditor __getEditor(Object forValue) {
        PropertyEditor editor = this.editorsByValue.get(forValue);
        try {
            PropertyEditor propertyEditor = editor;
            return propertyEditor;
        }
        finally {
            this._editor = editor;
        }
    }
}

