/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.partition;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.DBNavigable;
import oracle.ideimpl.db.panels.DBTabbedPanel;
import oracle.ideimpl.db.panels.partition.PartitionByPanel;
import oracle.ideimpl.db.panels.partition.PartitionPanel;
import oracle.ideimpl.db.panels.partition.PartitionProperty;
import oracle.ideimpl.db.panels.partition.SubpartitionTemplatePanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;

public class TablePartitionPanel
extends ChildObjectEditorPanel<OracleTablePartitions, Table> {
    private DBTabbedPanel m_tabbedPanel;
    private TraversableContext m_context;
    private DBNavigable[] m_navs = null;
    private boolean m_firstTime = true;
    private static final int PARTITION_BY_TAB_POSITION = 0;
    private static final int PARTITION_DEFINITION_TAB_POSITION = 1;
    private static final int SUBPARTITION_TEMPLATE_TAB_POSITION = 2;
    private static final int NUMBER_OF_TABS = 3;

    public TablePartitionPanel() {
        super("TablePartitionPanel", null, true);
    }

    @Override
    public void initialiseChildComponents() {
        DBObjectProvider dBObjectProvider = this.getProvider();
        DBUILayoutHelper dBUILayoutHelper = this.getDBUILayoutHelper();
        if (dBObjectProvider instanceof OracleDatabase && !((OracleDatabase)dBObjectProvider).supportsPartitioning()) {
            dBUILayoutHelper.add((Component)new JWrappedLabel(UIBundle.get("PART_DISABLED_ERR")));
            dBUILayoutHelper.pushUp();
        } else {
            if (this.m_navs == null) {
                this.m_navs = new DBNavigable[3];
                Class[] classArray = new Class[]{TablePartitionPanel.class};
                Object[] objectArray = new TablePartitionPanel[]{this};
                this.m_navs[0] = new DBNavigable(UIBundle.get("PARTITIONS_SUBTAB_BY"), PartitionByPanel.class, classArray, objectArray);
                this.m_navs[0].setProperties(Arrays.asList(PartitionProperty.PARTITION_TYPE, PartitionProperty.PARTITION_COLS, PartitionProperty.SUBPARTITION_TYPE, PartitionProperty.SUBPARTITION_COLS));
                this.m_navs[1] = new DBNavigable(UIBundle.get("PARTITIONS_SUBTAB_DEF"), PartitionPanel.class);
                this.m_navs[1].setProperties(Arrays.asList(PartitionProperty.PARTITIONS, PartitionProperty.HASH_QUANTITY, PartitionProperty.HASH_TABLESPACES));
                this.m_navs[2] = new DBNavigable(UIBundle.get("PARTITIONS_SUBTAB_TEMPLATE"), SubpartitionTemplatePanel.class);
                this.m_navs[2].setProperties(Arrays.asList(PartitionProperty.SUBPARTITIONS_FOR_TABLE, PartitionProperty.SUBPARTITION_TEMPLATE_HASH_QUANTITY, PartitionProperty.SUBPARTITION_TEMPLATE_HASH_TABLESPACES));
            }
            if (this.m_tabbedPanel == null) {
                this.m_tabbedPanel = new DBTabbedPanel(this.m_navs);
                this.m_tabbedPanel.setPreferredSize(new Dimension(500, 350));
                this.m_tabbedPanel.setName("TablePartitioningTabbedPanel");
            }
            dBUILayoutHelper.add((Component)((Object)this.m_tabbedPanel), 1, 1, true, true);
        }
        dBUILayoutHelper.layout();
    }

    @Override
    public void initialisePanel() {
        super.initialisePanel();
        if (this.m_tabbedPanel != null) {
            if (this.m_context == null) {
                this.m_context = new TraversableContext(this.getDataContext().getParent(), 0);
            }
            OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)this.getChildObject();
            if (!(this.m_firstTime || oracleTablePartitions != null && oracleTablePartitions.getPartitionType() != null)) {
                this.enablePartitionDefintionTab(false);
                this.enableSubpartitionTemplateTab(false);
            }
            this.m_firstTime = false;
            TablePartition tablePartition = this.getInitialSelection(TablePartition.class);
            if (tablePartition != null) {
                int n = tablePartition.getObjectType() == OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE ? 2 : 1;
                this.m_context.putDesignTimeObject("TabbedPanel.DEFAULT_TAB_INDEX", (Object)n);
            }
            this.m_tabbedPanel.onEntry(this.m_context);
        }
    }

    @Override
    public void commitPanel() throws TraversalException {
        super.commitPanel();
        if (this.m_tabbedPanel != null) {
            if (this.shouldValidateOnExit()) {
                this.validateObject();
            }
            this.m_tabbedPanel.onExit(this.m_context);
        }
    }

    void enablePartitionDefintionTab(boolean bl) {
        if (this.m_tabbedPanel != null) {
            this.m_tabbedPanel.enableTabForNavigable(this.m_navs[1], bl);
        }
    }

    void enableSubpartitionTemplateTab(boolean bl) {
        if (this.m_tabbedPanel != null) {
            this.m_tabbedPanel.enableTabForNavigable(this.m_navs[2], bl);
        }
    }

    @Override
    protected String getPropertyPath() {
        return "OracleTablePartitions";
    }

    @Override
    public boolean requestFocusForEditorConfig() {
        boolean bl = false;
        if (this.m_tabbedPanel != null) {
            bl = this.m_tabbedPanel.requestFocusForEditorConfig();
        }
        if (!bl) {
            bl = super.requestFocusForEditorConfig();
        }
        return bl;
    }
}

