/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ceditor;

import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.execute.DBRequestProcessor;
import oracle.ide.db.execute.DBRequestProcessorFactory;
import oracle.ide.db.model.BaseDBObjectTextNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.model.Node;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;
import oracle.ideimpl.db.ceditor.PlSqlFeatures;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.plsql.PlSqlSchemaObject;
import oracle.javatools.db.plsql.PlSqlSchemaObjectSpec;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlSubProgram;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.gutter.GutterColumn;
import oracle.javatools.editor.gutter.GutterColumnListener;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Tuple;

public class PlSqlGutterPlugin
implements EditorPlugin,
GutterColumnListener {
    private static final String COLUMN_NAME = "PLSQL_IMPLEMENTATIONS";
    private static final String RECALCULATE = "oracle.ideimpl.db.ceditor.PlSqlGutterPlugin.RECALCULATE";
    private static final Iterator<String> s_tsKeyGen = DBUtil.getTimestampKeyGenerator((String)PlSqlGutterPlugin.class.getName());
    private final ViewListener m_viewListener = new ViewListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void viewActivated(ViewEvent viewEvent) {
            if (PlSqlGutterPlugin.this.m_column != null) {
                if (PlSqlGutterPlugin.this.m_done) {
                    BaseDBObjectTextNode baseDBObjectTextNode;
                    BaseDBObjectTextNode baseDBObjectTextNode2 = PlSqlGutterPlugin.this.getTextNode();
                    try {
                        baseDBObjectTextNode = DBObjectNodeUtil.getCompanionNode(baseDBObjectTextNode2);
                    }
                    catch (DBException dBException) {
                        DBLog.getLogger((Object)this).warning(dBException.getMessage());
                        baseDBObjectTextNode = null;
                    }
                    Integer n = null;
                    if (baseDBObjectTextNode != null) {
                        try {
                            TextBuffer textBuffer = baseDBObjectTextNode.acquireTextBuffer();
                            n = textBuffer.getChangeId();
                        }
                        finally {
                            baseDBObjectTextNode.releaseTextBuffer();
                        }
                    }
                    if (ModelUtil.areDifferent((Object)PlSqlGutterPlugin.this.m_companionChangeID, n)) {
                        PlSqlGutterPlugin.this.m_done = false;
                        PlSqlGutterPlugin.this.m_companionChangeID = n;
                    }
                }
                if (!PlSqlGutterPlugin.this.m_done) {
                    PlSqlGutterPlugin.this.propertyChange(new PropertyChangeEvent(this, PlSqlGutterPlugin.RECALCULATE, true, false));
                    PlSqlGutterPlugin.this.m_done = true;
                }
            }
        }

        public void viewDeactivated(ViewEvent viewEvent) {
        }

        public void viewClosed(ViewEvent viewEvent) {
        }
    };
    private BasicEditorPane m_editor;
    private GutterColumn m_column;
    private boolean m_done;
    private Integer m_companionChangeID;
    private DBRequestProcessor m_reqProc;

    public void install(BasicEditorPane basicEditorPane) {
        if (PlSqlFeatures.isSupportedGutterNavigation()) {
            CodeEditor.getCodeEditor((BasicEditorPane)basicEditorPane).addViewListener(this.m_viewListener);
            this.m_editor = basicEditorPane;
            BaseDBObjectTextNode baseDBObjectTextNode = this.getTextNode();
            if (baseDBObjectTextNode != null && baseDBObjectTextNode.getProvider() != null && this.isSupportedType(baseDBObjectTextNode.getObjectType())) {
                CodeEditorGutter codeEditorGutter = CodeEditor.getCodeEditor((BasicEditorPane)this.m_editor).getGutter();
                this.m_column = codeEditorGutter.createGutterColumn(COLUMN_NAME, (GutterColumnListener)this);
            }
        }
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        if (this.m_column != null) {
            CodeEditorGutter codeEditorGutter;
            if (this.m_reqProc != null) {
                this.m_reqProc.cancel(this.getRequestProcessorKey());
                this.m_reqProc = null;
            }
            if ((codeEditorGutter = CodeEditor.getCodeEditor((BasicEditorPane)basicEditorPane).getGutter()) != null) {
                codeEditorGutter.removeGutterColumn(this.m_column);
            }
            CodeEditor.getCodeEditor((BasicEditorPane)basicEditorPane).removeViewListener(this.m_viewListener);
            this.m_column = null;
            this.m_editor = null;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.m_column != null && (RECALCULATE.equals(propertyChangeEvent.getPropertyName()) || "compoundEditInProgress".equals(propertyChangeEvent.getPropertyName()) && Boolean.TRUE.equals(propertyChangeEvent.getOldValue()) && Boolean.FALSE.equals(propertyChangeEvent.getNewValue()))) {
            BaseDBObjectTextNode baseDBObjectTextNode = this.getTextNode();
            if (this.m_reqProc == null) {
                this.m_reqProc = DBRequestProcessorFactory.getProcessor(baseDBObjectTextNode);
            }
            String string = this.getRequestProcessorKey();
            DBRequestProcessor dBRequestProcessor = this.m_reqProc;
            dBRequestProcessor.getClass();
            this.m_reqProc.schedule(string, new DBRequestProcessor.DBRunnable(dBRequestProcessor, baseDBObjectTextNode.getProvider(), UIBundle.format("PLSQL_GUTTER_TASK", baseDBObjectTextNode.getShortLabel())){
                {
                    DBRequestProcessor dBRequestProcessor2 = dBRequestProcessor;
                    dBRequestProcessor2.getClass();
                    super(dBObjectProvider, string);
                }

                @Override
                protected void doWork() throws DBException {
                    PlSqlGutterPlugin.this.updateGutter();
                }
            }, 1500);
        }
    }

    public void markClicked(GutterMark gutterMark, int n, MouseEvent mouseEvent) {
        try {
            Tuple tuple = (Tuple)gutterMark.getUserData();
            BaseDBObjectTextNode baseDBObjectTextNode = (BaseDBObjectTextNode)tuple.object1();
            boolean bl = false;
            if (baseDBObjectTextNode != null && !(bl = baseDBObjectTextNode.isOpen())) {
                bl = baseDBObjectTextNode.getDBObject() instanceof PlSqlSchemaObject;
            }
            if (bl) {
                Integer n2 = (Integer)tuple.object2();
                Context context = Context.newIdeContext((Node)baseDBObjectTextNode);
                OffsetNavigationPoint offsetNavigationPoint = new OffsetNavigationPoint(context, n2.intValue(), 0);
                offsetNavigationPoint.setPreferredEditorType(null);
                NavigationManager navigationManager = NavigationManager.getNavigationManager();
                if (navigationManager != null) {
                    navigationManager.navigateTo((NavigationPoint)offsetNavigationPoint);
                } else {
                    offsetNavigationPoint.navigate();
                }
            } else {
                this.clearGutter();
            }
        }
        catch (Exception exception) {
            DBLog.getLogger((Object)this).log(DBLog.getExceptionLogLevel(), "Error in Go to Source for pl/sql", exception);
        }
    }

    public void markMoved(GutterMark gutterMark, int n, int n2) {
    }

    public void markRemoved(GutterMark gutterMark, int n) {
    }

    public String getMarkToolTip(GutterMark gutterMark, MouseEvent mouseEvent) {
        String string;
        BaseDBObjectTextNode baseDBObjectTextNode = this.getTextNode();
        DBObject dBObject = baseDBObjectTextNode.getDBObject();
        if (dBObject instanceof PlSqlSchemaObject && (string = PlSqlUtil.getCompanionObjectType((PlSqlSchemaObject)((PlSqlSchemaObject)dBObject))) != null) {
            return UIBundle.format("PLSQL_GUTTER_TOOLTIP", DBTypeDisplayRegistry.getSingularDisplayName(string));
        }
        return null;
    }

    private String getRequestProcessorKey() {
        return this.getClass().getSimpleName();
    }

    private BaseDBObjectTextNode getTextNode() {
        return PlSqlFeatures.getTextNode(this.m_editor);
    }

    private boolean isSupportedType(String string) {
        return "PACKAGE".equals(string) || "PACKAGE BODY".equals(string) || "TYPE".equals(string) || "TYPE BODY".equals(string);
    }

    private void clearGutter() {
        GutterColumn gutterColumn = this.m_column;
        if (gutterColumn != null) {
            gutterColumn.removeAllGutterMarks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateGutter() throws CancelledException {
        if (this.m_column != null) {
            Runnable runnable = null;
            BaseDBObjectTextNode baseDBObjectTextNode = this.getTextNode();
            DBObjectProvider dBObjectProvider = baseDBObjectTextNode.getProvider();
            String string = s_tsKeyGen.next();
            try {
                List list;
                PlSqlSourceObject plSqlSourceObject;
                BaseDBObjectTextNode baseDBObjectTextNode2;
                DBUtil.suspendTimestampChecking((DBObjectProvider)dBObjectProvider, (String)string);
                PlSqlSourceObject plSqlSourceObject2 = (PlSqlSourceObject)baseDBObjectTextNode.getDBObjectFromBuffer();
                if (plSqlSourceObject2 instanceof PlSqlSchemaObject && (baseDBObjectTextNode2 = DBObjectNodeUtil.getCompanionNode(baseDBObjectTextNode)) != null && (plSqlSourceObject = (PlSqlSourceObject)baseDBObjectTextNode2.getDBObjectFromBuffer()) != null && (list = PlSqlUtil.getTopLevelPlSqlFragments((DBObjectProvider)dBObjectProvider, (PlSqlSchemaObject)((PlSqlSchemaObject)plSqlSourceObject2), (PlSqlSchemaObject)((PlSqlSchemaObject)plSqlSourceObject))) != null) {
                    Icon icon = plSqlSourceObject2 instanceof PlSqlSchemaObjectSpec ? OracleIcons.getIcon((String)"gutter/down.png") : OracleIcons.getIcon((String)"gutter/up.png");
                    runnable = () -> this.updateGutterUI(list, icon, baseDBObjectTextNode2);
                }
            }
            catch (CancelledException cancelledException) {
                throw cancelledException;
            }
            catch (DBException dBException) {
                DBLog.getLogger((Object)this).warning(dBException.getMessage());
            }
            finally {
                DBUtil.resumeTimestampChecking((DBObjectProvider)dBObjectProvider, (String)string);
            }
            if (runnable == null) {
                runnable = () -> this.clearGutter();
            }
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void updateGutterUI(List<Tuple<PlSqlSubProgram, PlSqlSubProgram>> list, Icon icon, BaseDBObjectTextNode baseDBObjectTextNode) {
        this.clearGutter();
        if (this.m_column != null) {
            for (Tuple<PlSqlSubProgram, PlSqlSubProgram> tuple : list) {
                int n;
                int n2;
                GutterMark gutterMark;
                PlSqlSubProgram plSqlSubProgram = (PlSqlSubProgram)tuple.getFirst();
                PlSqlSubProgram plSqlSubProgram2 = (PlSqlSubProgram)tuple.getSecond();
                if (plSqlSubProgram == null || plSqlSubProgram2 == null || (gutterMark = this.m_column.addGutterMark(n2 = this.getTextNode().getLine(plSqlSubProgram.getStartOffset()), icon, null, 3000, n = 1)) == null) continue;
                gutterMark.setUserData((Object)new Tuple((Object)baseDBObjectTextNode, (Object)plSqlSubProgram2.getStartOffset()));
            }
        }
    }
}

