/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.dialogs;

import java.util.logging.Level;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.db.model.DBObjectTypeNode;
import oracle.ideimpl.db.extension.DatabaseUIExtensionHook;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.property.Metadata;

public class DBEditorFactoryRegistry {
    private DBEditorFactoryRegistry() {
    }

    public static DBEditorFactory findFactory(DBObjectProvider dBObjectProvider) {
        DatabaseUIExtensionHook databaseUIExtensionHook;
        DBEditorFactory dBEditorFactory = null;
        if (dBObjectProvider != null && (databaseUIExtensionHook = DatabaseUIExtensionHook.getHook()) != null) {
            dBEditorFactory = databaseUIExtensionHook.findEditorFactory(dBObjectProvider);
        }
        return dBEditorFactory;
    }

    public static DBEditorFactory findDatabaseFactory(DatabaseDescriptor databaseDescriptor) {
        DBEditorFactory dBEditorFactory = null;
        DatabaseUIExtensionHook databaseUIExtensionHook = DatabaseUIExtensionHook.getHook();
        if (databaseUIExtensionHook != null) {
            dBEditorFactory = databaseUIExtensionHook.findDatabaseEditorFactory(databaseDescriptor);
        }
        return dBEditorFactory;
    }

    @Deprecated
    public static DBEditorFactory findFactory(Class<? extends DBObjectProvider> clazz) {
        DatabaseDescriptor databaseDescriptor;
        DBEditorFactory dBEditorFactory = null;
        DatabaseUIExtensionHook databaseUIExtensionHook = DatabaseUIExtensionHook.getHook();
        if (databaseUIExtensionHook != null) {
            dBEditorFactory = databaseUIExtensionHook.findEditorFactory(clazz);
        }
        if (dBEditorFactory == null && Database.class.isAssignableFrom(clazz) && (databaseDescriptor = DatabaseFactory.getDatabaseDescriptor(clazz)) != null) {
            dBEditorFactory = DBEditorFactoryRegistry.findDatabaseFactory(databaseDescriptor);
        }
        return dBEditorFactory;
    }

    @Deprecated
    public static void registerDBEditorFactory(Class clazz, DBEditorFactory dBEditorFactory) {
    }

    public static DBEditorFactory getCreateFactory(DBEditorConfig dBEditorConfig) {
        return DBEditorFactoryRegistry.getCreateFactory(dBEditorConfig.getProvider(), dBEditorConfig.getObjectType());
    }

    public static DBEditorFactory getCreateFactory(DBObjectProvider dBObjectProvider, String string) {
        DBEditorFactory dBEditorFactory = null;
        DBEditorFactory dBEditorFactory2 = DBEditorFactoryRegistry.findFactory(dBObjectProvider);
        if (dBEditorFactory2 != null && dBEditorFactory2.canCreateDBObject(null, dBObjectProvider, string)) {
            dBEditorFactory = dBEditorFactory2;
        }
        return dBEditorFactory;
    }

    public static DBEditorFactory getCreateFactory(DBObjectTypeNode dBObjectTypeNode) {
        String string;
        DBEditorFactory dBEditorFactory = null;
        if (dBObjectTypeNode != null && (string = DBObjectNodeUtil.normalizeType(dBObjectTypeNode)) != null) {
            Object object = dBObjectTypeNode.getProviderIdentifier();
            String string2 = dBObjectTypeNode.getProviderType();
            if (object != null && string2 != null) {
                try {
                    dBEditorFactory = DBEditorFactoryRegistry.getCreateFactory(DBObjectProviderFactory.findOrCreateProvider((String)string2, (Object)object), string);
                }
                catch (DBException dBException) {
                    DBLog.getLogger(DBEditorFactoryRegistry.class).log(Level.FINE, "Couldn't get provider: " + dBException.getMessage());
                }
            }
        }
        return dBEditorFactory;
    }

    public static DBEditorFactory getEditFactory(DBEditorConfig dBEditorConfig) {
        Object var1_1 = null;
        Object object = dBEditorConfig.isChildEditOnly() ? dBEditorConfig.getChildObject() : dBEditorConfig.getOriginalObject();
        return DBEditorFactoryRegistry.getEditFactory(object, dBEditorConfig.getProvider());
    }

    public static DBEditorFactory getEditFactory(SchemaObject schemaObject, DBObjectProvider dBObjectProvider) {
        return DBEditorFactoryRegistry.getEditFactory((DBObject)schemaObject, dBObjectProvider);
    }

    public static DBEditorFactory getEditFactory(DBObject dBObject, DBObjectProvider dBObjectProvider) {
        DBEditorFactory dBEditorFactory = null;
        DBEditorFactory dBEditorFactory2 = DBEditorFactoryRegistry.findFactory(dBObjectProvider);
        if (dBEditorFactory2 != null && dBEditorFactory2.canEditDBObject(dBObject, dBObjectProvider)) {
            dBEditorFactory = dBEditorFactory2;
        }
        return dBEditorFactory;
    }

    public static DBEditorFactory getEditFactory(DBObjectNode dBObjectNode) {
        Class clazz;
        DBObjectProvider dBObjectProvider;
        DBEditorFactory dBEditorFactory = null;
        String string = DBObjectNodeUtil.normalizeType(dBObjectNode);
        if (string != null && (dBObjectProvider = dBObjectNode.getProvider()) != null && (clazz = Metadata.getInstance().getObjectClass(string)) != null) {
            DBObject dBObject = null;
            if (AbstractBuildableObject.class.isAssignableFrom(clazz) && SystemObject.class.isAssignableFrom(clazz)) {
                try {
                    dBObject = (DBObject)clazz.newInstance();
                    dBObject.setName(dBObjectNode.getObjectName());
                    if (dBObject instanceof SchemaObject) {
                        ((SchemaObject)dBObject).setSchema(new Schema(dBObjectNode.getSchemaName()));
                    }
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            if (dBObject == null) {
                dBObject = dBObjectNode.getDBObject();
            }
            dBEditorFactory = DBEditorFactoryRegistry.getEditFactory(dBObject, dBObjectProvider);
        }
        return dBEditorFactory;
    }
}

